/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.HelpTopicDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.schema.BeanPropertyDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.HelpTopicDefSource;
import weblogic.remoteconsole.common.repodef.schema.PageActionDefSource;
import weblogic.remoteconsole.common.repodef.schema.PageDefSource;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanPropertyDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.CreateFormDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.HelpTopicDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PageActionDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PagePropertyDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PageRepoDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.SliceFormDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.SliceTableDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.TableDefImpl;
import weblogic.remoteconsole.common.utils.CustomizerInvocationUtils;

public abstract class PageDefImpl
implements PageDef {
    private PageRepoDefImpl pageRepoDefImpl;
    private BaseBeanTypeDefImpl typeDefImpl;
    private PagePath pagePath;
    private PageDefSource source;
    private String pageKey;
    private LocalizableString introductionHTML;
    private List<HelpTopicDefImpl> helpTopicDefImpls = new ArrayList<HelpTopicDefImpl>();
    private List<HelpTopicDef> helpTopicDefs;
    private LocalizableString helpPageTitle;
    private List<PagePropertyDefImpl> allPropertyDefImpls = new ArrayList<PagePropertyDefImpl>();
    private List<PagePropertyDef> allPropertyDefs;
    private List<PageActionDefImpl> actionDefImpls = new ArrayList<PageActionDefImpl>();
    private List<PageActionDef> actionDefs;

    protected PageDefImpl(PageRepoDefImpl pageRepoDefImpl, PagePath pagePath, PageDefSource source, String pageKey) {
        this.pageRepoDefImpl = pageRepoDefImpl;
        this.pagePath = pagePath;
        this.source = source;
        this.pageKey = pageKey;
        this.typeDefImpl = this.getPageRepoDefImpl().getBeanRepoDefImpl().getTypeDefImpl(pagePath.getPagesPath().getTypeDef().getTypeName());
        this.customizePageDefSource();
        this.introductionHTML = this.createIntroductionHTML();
        this.createHelpTopicDefsAndImpls();
    }

    protected void finishPropertyBasedInitialization() {
        this.createActionDefImpls(this.source.getActions());
        this.initializeHelpPageTitle();
        this.createUsedIfDefImpls();
    }

    PageRepoDefImpl getPageRepoDefImpl() {
        return this.pageRepoDefImpl;
    }

    BaseBeanTypeDefImpl getTypeDefImpl() {
        return this.typeDefImpl;
    }

    @Override
    public PagePath getPagePath() {
        return this.pagePath;
    }

    protected PageDefSource getSource() {
        return this.source;
    }

    String getPageKey() {
        return this.pageKey;
    }

    @Override
    public LocalizableString getIntroductionHTML() {
        return this.introductionHTML;
    }

    @Override
    public LocalizableString getHelpPageTitle() {
        return this.helpPageTitle;
    }

    List<HelpTopicDefImpl> getHelpTopicDefImpls() {
        return this.helpTopicDefImpls;
    }

    @Override
    public List<HelpTopicDef> getHelpTopicDefs() {
        return this.helpTopicDefs;
    }

    List<PagePropertyDefImpl> getAllPropertyDefImpls() {
        return this.allPropertyDefImpls;
    }

    @Override
    public List<PagePropertyDef> getAllPropertyDefs() {
        return this.allPropertyDefs;
    }

    List<PageActionDefImpl> getActionDefImpls() {
        return this.actionDefImpls;
    }

    @Override
    public List<PageActionDef> getActionDefs() {
        return this.actionDefs;
    }

    PageActionDefImpl findActionDefImpl(String action) {
        return this.findActionDefImpl(this.getActionDefImpls(), action);
    }

    private PageActionDefImpl findActionDefImpl(List<PageActionDefImpl> actionDefImpls, String action) {
        for (PageActionDefImpl actionDefImpl : actionDefImpls) {
            if (actionDefImpl.getActionName().equals(action)) {
                return actionDefImpl;
            }
            PageActionDefImpl childActionDefImpl = this.findActionDefImpl(actionDefImpl.getActionDefImpls(), action);
            if (childActionDefImpl == null) continue;
            return childActionDefImpl;
        }
        return null;
    }

    @Override
    public String getCustomizePageDefMethod() {
        return this.source.getCustomizePageDefMethod();
    }

    @Override
    public String getCustomizePageMethod() {
        return this.source.getCustomizePageMethod();
    }

    @Override
    public boolean isInstanceBasedPDJ() {
        return this.source.isInstanceBasedPDJ();
    }

    private void customizePageDefSource() {
        String customizerName = this.source.getCustomizePageDefSourceMethod();
        if (StringUtils.isEmpty((String)customizerName)) {
            return;
        }
        Method method = CustomizerInvocationUtils.getMethod(customizerName);
        CustomizerInvocationUtils.checkSignature(method, Void.TYPE, new Type[]{PagePath.class, PageDefSource.class});
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.pagePath);
        args.add((Object)this.source);
        CustomizerInvocationUtils.invokeMethod(method, args);
    }

    protected void createUsedIfDefImpls() {
        for (PagePropertyDefImpl propertyDefImpl : this.allPropertyDefImpls) {
            propertyDefImpl.createUsedIfDefImpl();
        }
    }

    protected List<PagePropertyDefImpl> createPropertyDefImpls(List<BeanPropertyDefCustomizerSource> propertyCustomizerSources) {
        return this.createPropertyDefImpls(propertyCustomizerSources, false);
    }

    protected List<PagePropertyDefImpl> createPropertyDefImpls(List<BeanPropertyDefCustomizerSource> propertyCustomizerSources, boolean searchSubTypes) {
        ArrayList<PagePropertyDefImpl> rtn = new ArrayList<PagePropertyDefImpl>();
        for (BeanPropertyDefCustomizerSource propertyCustomizerSource : propertyCustomizerSources) {
            PagePropertyDefImpl propDefImpl = this.getPropertyDefImpl(propertyCustomizerSource, searchSubTypes);
            if (propDefImpl == null) continue;
            rtn.add(propDefImpl);
        }
        this.allPropertyDefImpls.addAll(rtn);
        this.allPropertyDefs = Collections.unmodifiableList(this.allPropertyDefImpls);
        return rtn;
    }

    private PagePropertyDefImpl getPropertyDefImpl(BeanPropertyDefCustomizerSource propertyCustomizerSource, boolean searchSubTypes) {
        if (propertyCustomizerSource.getDefinition() == null) {
            BeanPropertyDefImpl beanPropertyDefImpl = this.getTypeDefImpl().getPropertyDefImpl(new Path(propertyCustomizerSource.getName()), searchSubTypes);
            if (beanPropertyDefImpl == null) {
                return null;
            }
            return new PagePropertyDefImpl(this, beanPropertyDefImpl, propertyCustomizerSource);
        }
        propertyCustomizerSource.getDefinition().setName(propertyCustomizerSource.getName());
        return new PagePropertyDefImpl(this, propertyCustomizerSource);
    }

    private void createActionDefImpls(List<PageActionDefSource> actionCustomizerSources) {
        for (PageActionDefSource actionCustomizerSource : actionCustomizerSources) {
            PageActionDefImpl actionDefImpl = PageActionDefImpl.create(this, actionCustomizerSource);
            if (actionDefImpl == null) continue;
            this.actionDefImpls.add(actionDefImpl);
        }
        this.actionDefs = Collections.unmodifiableList(this.actionDefImpls);
    }

    private LocalizableString createIntroductionHTML() {
        String englishIntroductionHTML = this.getSource().getIntroductionHTML();
        if (StringUtils.isEmpty((String)englishIntroductionHTML)) {
            return this.getTypeDefImpl().getDescriptionHTML();
        }
        return new LocalizableString(this.getLocalizationKey("introductionHTML"), englishIntroductionHTML);
    }

    private void createHelpTopicDefsAndImpls() {
        int index = 0;
        for (HelpTopicDefSource helpTopicDefSource : this.getSource().getHelpTopics()) {
            this.getHelpTopicDefImpls().add(new HelpTopicDefImpl(this, helpTopicDefSource, index++));
        }
        this.helpTopicDefs = Collections.unmodifiableList(this.getHelpTopicDefImpls());
    }

    protected void initializeHelpPageTitle() {
        this.helpPageTitle = new LocalizableString(this.getLocalizationKey("helpPageTitle"), this.getEnglishHelpPageTitle(this.getTypeDefImpl().getInstanceName()));
    }

    protected abstract String getEnglishHelpPageTitle(String var1);

    String getLocalizationKey(String key) {
        return this.getTypeDefImpl().getLocalizationKey(this.pageKey + "." + key);
    }

    SliceFormDefImpl asSliceFormDefImpl() {
        return (SliceFormDefImpl)this;
    }

    SliceTableDefImpl asSliceTableDefImpl() {
        return (SliceTableDefImpl)this;
    }

    CreateFormDefImpl asCreateFormDefImpl() {
        return (CreateFormDefImpl)this;
    }

    TableDefImpl asTableDefImpl() {
        return (TableDefImpl)this;
    }

    public String toString() {
        return this.getPagePath().toString();
    }
}

