/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import weblogic.remoteconsole.common.repodef.LegalValueDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.PageFieldDef;
import weblogic.remoteconsole.common.repodef.yaml.PageActionParamDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.ValueUtils;
import weblogic.remoteconsole.server.repo.Value;

class PageActionParamLegalValueDefImpl
implements LegalValueDef {
    private PageActionParamDefImpl pageActionParamDefImpl;
    Value value;
    private LocalizableString label;
    private boolean omit;

    public PageActionParamLegalValueDefImpl(PageActionParamDefImpl pageActionParamDefImpl, Object value) {
        this.pageActionParamDefImpl = pageActionParamDefImpl;
        this.value = ValueUtils.createValue(value);
        this.initializeLabel(this.getValueAsString());
    }

    public PageActionParamLegalValueDefImpl(PageActionParamDefImpl pageActionParamDefImpl, Object value, String englishLabel) {
        this(pageActionParamDefImpl, value);
        this.initializeLabel(englishLabel);
    }

    public PageActionParamLegalValueDefImpl(PageActionParamDefImpl pageActionParamDefImpl, Object value, String englishLabel, boolean omit) {
        this(pageActionParamDefImpl, value);
        this.omit = omit;
        this.initializeLabel(englishLabel);
    }

    private void initializeLabel(String englishLabel) {
        this.label = new LocalizableString(this.getActionParamDefImpl().getLegalValueLocalizationKey(this.getValueAsString()), englishLabel);
    }

    PageActionParamDefImpl getActionParamDefImpl() {
        return this.pageActionParamDefImpl;
    }

    boolean isOmit() {
        return this.omit;
    }

    @Override
    public PageFieldDef getFieldDef() {
        return this.getActionParamDefImpl();
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    @Override
    public LocalizableString getLabel() {
        return this.label;
    }

    String getValueAsString() {
        if (this.getValue().isString()) {
            return this.getValue().asString().getValue();
        }
        if (this.getValue().isInt()) {
            return "" + this.getValue().asInt().getValue();
        }
        if (this.getValue().isLong()) {
            return "" + this.getValue().asLong().getValue();
        }
        throw new AssertionError((Object)("Unsupport legal value: " + String.valueOf(this.getValue())));
    }

    public String toString() {
        return "PageActionParamLegalValueDefImpl<" + this.getValueAsString() + "," + String.valueOf(this.getLabel()) + ">";
    }
}

