/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import weblogic.console.schema.beaninfo.BeanActionParamDefSource;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.ActionInputFormDef;
import weblogic.remoteconsole.common.repodef.BeanValueDef;
import weblogic.remoteconsole.common.repodef.LegalValueDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.PageActionParamDef;
import weblogic.remoteconsole.common.repodef.PageFieldPresentationDef;
import weblogic.remoteconsole.common.repodef.schema.BeanActionParamDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.LegalValueDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.yaml.ActionInputFormDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanActionParamDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.HelpHTMLUtils;
import weblogic.remoteconsole.common.repodef.yaml.PageActionParamLegalValueDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PageActionParamPresentationDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.UsageTracker;

class PageActionParamDefImpl
extends BeanActionParamDefImpl
implements PageActionParamDef {
    private static final Logger LOGGER = Logger.getLogger(PageActionParamDefImpl.class.getName());
    private ActionInputFormDefImpl inputFormDefImpl;
    private BeanActionParamDefCustomizerSource pageLevelCustomizerSource;
    private LocalizableString helpSummaryHTML;
    private LocalizableString detailedHelpHTML;
    private LocalizableString label;
    private PageActionParamPresentationDefImpl presentationDefImpl;
    private List<PageActionParamLegalValueDefImpl> legalValueDefImpls = new ArrayList<PageActionParamLegalValueDefImpl>();
    private List<LegalValueDef> legalValueDefs;

    static PageActionParamDefImpl create(ActionInputFormDefImpl inputFormDefImpl, BeanActionParamDefCustomizerSource pageLevelCustomizerSource) {
        if (pageLevelCustomizerSource.getDefinition() == null) {
            String paramName = pageLevelCustomizerSource.getName();
            BeanActionParamDefImpl beanParamDefImpl = inputFormDefImpl.getActionDefImpl().getParamDefImpl(paramName);
            BeanActionParamDefCustomizerSource customizerSource = new BeanActionParamDefCustomizerSource();
            customizerSource.merge(beanParamDefImpl.getCustomizerSource(), new Path());
            customizerSource.merge(pageLevelCustomizerSource, new Path());
            customizerSource.setName(paramName);
            return new PageActionParamDefImpl(inputFormDefImpl, beanParamDefImpl.getSource(), customizerSource, pageLevelCustomizerSource);
        }
        pageLevelCustomizerSource.getDefinition().setName(pageLevelCustomizerSource.getName());
        return new PageActionParamDefImpl(inputFormDefImpl, pageLevelCustomizerSource.getDefinition(), pageLevelCustomizerSource, pageLevelCustomizerSource);
    }

    private PageActionParamDefImpl(ActionInputFormDefImpl inputFormDefImpl, BeanActionParamDefSource source, BeanActionParamDefCustomizerSource customizerSource, BeanActionParamDefCustomizerSource pageLevelCustomizerSource) {
        super(inputFormDefImpl.getActionDefImpl(), source, customizerSource);
        this.inputFormDefImpl = inputFormDefImpl;
        this.pageLevelCustomizerSource = pageLevelCustomizerSource;
        this.initializeLabel();
        this.initializeHelp();
        this.initializePresentationDef();
        this.initializeLegalValueDefs();
    }

    ActionInputFormDefImpl getInputFormDefImpl() {
        return this.inputFormDefImpl;
    }

    @Override
    public ActionInputFormDef getInputFormDef() {
        return this.getInputFormDefImpl();
    }

    @Override
    public boolean isSupportsOptions() {
        return this.isReference();
    }

    @Override
    public List<String> getOptionsSources() {
        if (this.isSupportsOptions()) {
            return this.getCustomizerSource().getOptionsSources();
        }
        return null;
    }

    @Override
    public boolean isAllowNoneOption() {
        return false;
    }

    @Override
    public LocalizableString getLabel() {
        return this.label;
    }

    @Override
    public LocalizableString getHelpSummaryHTML() {
        return this.helpSummaryHTML;
    }

    @Override
    public LocalizableString getDetailedHelpHTML() {
        return this.detailedHelpHTML;
    }

    PageActionParamPresentationDefImpl getPresentationDefImpl() {
        return this.presentationDefImpl;
    }

    @Override
    public PageFieldPresentationDef getPresentationDef() {
        return this.getPresentationDefImpl();
    }

    @Override
    public boolean isPageLevelField() {
        return this.pageLevelCustomizerSource.getDefinition() != null;
    }

    @Override
    public BeanValueDef.ValueKind getValueKind() {
        BeanValueDef.ValueKind kind = super.getValueKind();
        if (this.pageLevelCustomizerSource.isSecret()) {
            if (kind == BeanValueDef.ValueKind.STRING) {
                kind = BeanValueDef.ValueKind.SECRET;
            } else {
                throw this.configurationError("Only string parameters can be secrets: " + this.getParamName());
            }
        }
        return kind;
    }

    @Override
    public boolean isReadOnly() {
        return this.pageLevelCustomizerSource.isReadOnly();
    }

    private void initializeLabel() {
        String englishLabel = this.getCustomizerSource().getLabel();
        if (StringUtils.isEmpty((String)englishLabel)) {
            englishLabel = StringUtils.camelCaseToUpperCaseWords((String)this.getCustomizerSource().getName());
        }
        this.label = new LocalizableString(this.getLocalizationKey("label"), englishLabel);
    }

    private void initializeHelp() {
        this.helpSummaryHTML = new LocalizableString(this.getLocalizationKey("helpSummaryHTML"), HelpHTMLUtils.getEnglishHelpSummaryHTML(this.getSource().getDescriptionHTML(), this.getCustomizerSource().getHelpHTML(), this.getCustomizerSource().getHelpSummaryHTML(), this.getCustomizerSource().getHelpDetailsHTML()));
        this.detailedHelpHTML = new LocalizableString(this.getLocalizationKey("detailedHelpHTML"), HelpHTMLUtils.getEnglishDetailedHelpHTML(this.getSource().getDescriptionHTML(), this.getCustomizerSource().getHelpHTML(), this.getCustomizerSource().getHelpSummaryHTML(), this.getCustomizerSource().getHelpDetailsHTML()));
    }

    private void initializePresentationDef() {
        this.presentationDefImpl = new PageActionParamPresentationDefImpl(this, this.getCustomizerSource().getPresentation());
    }

    private void initializeLegalValueDefs() {
        this.mergePageActionParamLegalValueDefImpls(this.createSourceLevelPageActionParamLegalValueDefImpls(), this.createCustomizerSourceLevelPageActionParamLegalValueDefImpls());
        this.legalValueDefs = Collections.unmodifiableList(this.getLegalValueDefImpls());
    }

    private void mergePageActionParamLegalValueDefImpls(List<PageActionParamLegalValueDefImpl> sourceVals, List<PageActionParamLegalValueDefImpl> customizerVals) {
        if (sourceVals.isEmpty()) {
            this.getLegalValueDefImpls().addAll(customizerVals);
        } else {
            for (PageActionParamLegalValueDefImpl sourceVal : sourceVals) {
                PageActionParamLegalValueDefImpl customizerVal = this.findPageActionParamLegalValueDefImpl(sourceVal, customizerVals);
                if (customizerVal != null) {
                    if (customizerVal.isOmit()) continue;
                    this.getLegalValueDefImpls().add(customizerVal);
                    continue;
                }
                this.getLegalValueDefImpls().add(sourceVal);
            }
            for (PageActionParamLegalValueDefImpl customizerVal : customizerVals) {
                String usageId = "action param legal value " + this.getActionDef().getTypeDef().getTypeName() + " " + String.valueOf(this.getActionDef().getActionPath()) + " " + this.getParamName() + " " + customizerVal.getValueAsString();
                if (this.findPageActionParamLegalValueDefImpl(customizerVal, sourceVals) == null) {
                    UsageTracker.used(usageId);
                    continue;
                }
                UsageTracker.notFound(usageId);
            }
        }
    }

    private List<PageActionParamLegalValueDefImpl> createSourceLevelPageActionParamLegalValueDefImpls() {
        ArrayList<PageActionParamLegalValueDefImpl> rtn = new ArrayList<PageActionParamLegalValueDefImpl>();
        for (Object legalValue : this.getSource().getLegalValues()) {
            if (this.getCustomizerSource().isUseUnlocalizedLegalValuesAsLabels()) {
                rtn.add(new PageActionParamLegalValueDefImpl(this, legalValue, null));
                continue;
            }
            rtn.add(new PageActionParamLegalValueDefImpl(this, legalValue));
        }
        return rtn;
    }

    private List<PageActionParamLegalValueDefImpl> createCustomizerSourceLevelPageActionParamLegalValueDefImpls() {
        ArrayList<PageActionParamLegalValueDefImpl> rtn = new ArrayList<PageActionParamLegalValueDefImpl>();
        for (LegalValueDefCustomizerSource src : this.getCustomizerSource().getLegalValues()) {
            boolean supported = this.getActionDefImpl().getTypeDefImpl().getBeanRepoDefImpl().supportsCapabilities(src.getRequiredCapabilities());
            if (!supported) continue;
            rtn.add(new PageActionParamLegalValueDefImpl(this, src.getValue(), src.getLabel(), src.isOmit()));
        }
        return rtn;
    }

    private PageActionParamLegalValueDefImpl findPageActionParamLegalValueDefImpl(PageActionParamLegalValueDefImpl want, List<PageActionParamLegalValueDefImpl> vals) {
        for (PageActionParamLegalValueDefImpl have : vals) {
            if (!StringUtils.nonNull((String)want.getValueAsString()).equals(StringUtils.nonNull((String)have.getValueAsString()))) continue;
            return have;
        }
        return null;
    }

    String getInlineFieldHelpLocalizationKey() {
        return this.getLocalizationKey("inlineFieldHelp");
    }

    String getLegalValueLocalizationKey(String legalValue) {
        return this.getLocalizationKey("legalValues." + legalValue);
    }

    @Override
    String getLocalizationKey(String key) {
        return this.getInputFormDefImpl().getLocalizationKey("params." + this.getParamName() + "." + key);
    }

    List<PageActionParamLegalValueDefImpl> getLegalValueDefImpls() {
        return this.legalValueDefImpls;
    }

    @Override
    public List<LegalValueDef> getLegalValueDefs() {
        return this.legalValueDefs;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getInputFormDef()) + " param=" + this.getParamName();
    }
}

