/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import weblogic.console.schema.beaninfo.BeanActionDefSource;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.ActionInputFormDef;
import weblogic.remoteconsole.common.repodef.BeanActionDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PageActionExternalHelpDef;
import weblogic.remoteconsole.common.repodef.PageActionPollingDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.schema.BeanActionDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.BeanActionPollingDefSource;
import weblogic.remoteconsole.common.repodef.schema.MBeanOperationDefSource;
import weblogic.remoteconsole.common.repodef.schema.PageActionDefSource;
import weblogic.remoteconsole.common.repodef.yaml.ActionInputFormDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanActionDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.HelpHTMLUtils;
import weblogic.remoteconsole.common.repodef.yaml.PageActionExternalHelpDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PageActionPollingDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PageDefImpl;
import weblogic.remoteconsole.common.utils.WebLogicRoles;

class PageActionDefImpl
extends BeanActionDefImpl
implements PageActionDef {
    private PageDefImpl pageDefImpl;
    private PageActionDefSource pageActionDefSource;
    private LocalizableString helpSummaryHTML;
    private LocalizableString detailedHelpHTML;
    private LocalizableString label;
    private LocalizableString helpLabel;
    private LocalizableString successMessage;
    private LocalizableString failureMessage;
    private ActionInputFormDefImpl inputFormDefImpl;
    private PageActionExternalHelpDefImpl externalHelpDefImpl;
    private List<PageActionDefImpl> actionDefImpls = new ArrayList<PageActionDefImpl>();
    private List<PageActionDef> actionDefs;
    private PageActionPollingDefImpl pollingDefImpl;

    static PageActionDefImpl create(PageDefImpl pageDefImpl, PageActionDefSource pageActionDefSource) {
        boolean supported = pageDefImpl.getPageRepoDefImpl().getBeanRepoDefImpl().supportsCapabilities(pageActionDefSource.getRequiredCapabilities());
        if (!supported) {
            return null;
        }
        if (!pageActionDefSource.getActions().isEmpty()) {
            if (pageDefImpl.getTypeDefImpl().hasActionDef(new Path(pageActionDefSource.getName()))) {
                throw new AssertionError((Object)("Action group name matches a bean action name: " + pageActionDefSource.getName() + " " + String.valueOf(pageDefImpl.getTypeDefImpl())));
            }
            BeanActionDefSource dummySource = new BeanActionDefSource();
            dummySource.setName(pageActionDefSource.getName());
            dummySource.setType("void");
            BeanActionDefCustomizerSource dummyCustomizerSource = new BeanActionDefCustomizerSource();
            dummyCustomizerSource.setDefinition(dummySource);
            dummyCustomizerSource.setName(dummySource.getName());
            PageActionDefImpl actionDefImpl = new PageActionDefImpl(pageDefImpl, pageDefImpl.getTypeDefImpl(), new Path(), dummySource, dummyCustomizerSource, pageActionDefSource);
            if (actionDefImpl.getActionDefs().isEmpty()) {
                return null;
            }
            return actionDefImpl;
        }
        BeanActionDefImpl beanActionDefImpl = pageDefImpl.getTypeDefImpl().getActionDefImpl(new Path(pageActionDefSource.getName()));
        if (beanActionDefImpl == null) {
            return null;
        }
        return new PageActionDefImpl(pageDefImpl, beanActionDefImpl.getTypeDefImpl(), beanActionDefImpl.getParentPath(), beanActionDefImpl.getSource(), beanActionDefImpl.getCustomizerSource(), pageActionDefSource);
    }

    private PageActionDefImpl(PageDefImpl pageDefImpl, BaseBeanTypeDefImpl typeDefImpl, Path parentPath, BeanActionDefSource beanActionDefSource, BeanActionDefCustomizerSource beanActionDefCustomizerSource, PageActionDefSource pageActionDefSource) {
        super(typeDefImpl, parentPath, beanActionDefSource, beanActionDefCustomizerSource);
        this.pageActionDefSource = pageActionDefSource;
        this.pageDefImpl = pageDefImpl;
        this.createActionDefImpls();
        this.actionDefs = Collections.unmodifiableList(this.getActionDefImpls());
        this.initializePollingDef();
        this.initializeMessagesAndLabels();
        this.initializeHelp();
        this.createInputFormDefImpl();
    }

    private void createInputFormDefImpl() {
        if (this.getCustomizerSource().getInputForm() != null) {
            this.inputFormDefImpl = new ActionInputFormDefImpl(this);
        }
    }

    private void createActionDefImpls() {
        for (PageActionDefSource childPageActionDefSource : this.pageActionDefSource.getActions()) {
            PageActionDefImpl actionDefImpl = PageActionDefImpl.create(this.pageDefImpl, childPageActionDefSource);
            if (actionDefImpl == null) continue;
            this.actionDefImpls.add(actionDefImpl);
        }
    }

    PageDefImpl getPageDefImpl() {
        return this.pageDefImpl;
    }

    @Override
    public PageDef getPageDef() {
        return this.getPageDefImpl();
    }

    @Override
    public LocalizableString getLabel() {
        return this.label;
    }

    @Override
    public LocalizableString getSuccessMessage() {
        return this.successMessage;
    }

    @Override
    public LocalizableString getFailureMessage() {
        return this.failureMessage;
    }

    @Override
    public LocalizableString getHelpLabel() {
        return this.helpLabel;
    }

    PageActionExternalHelpDefImpl getExternalHelpDefImpl() {
        return this.externalHelpDefImpl;
    }

    @Override
    public PageActionExternalHelpDef getExternalHelpDef() {
        return this.getExternalHelpDefImpl();
    }

    @Override
    public LocalizableString getHelpSummaryHTML() {
        return this.helpSummaryHTML;
    }

    @Override
    public LocalizableString getDetailedHelpHTML() {
        return this.detailedHelpHTML;
    }

    @Override
    public String getActionMethod() {
        return this.getCustomizerSource().getActionMethod();
    }

    List<PageActionDefImpl> getActionDefImpls() {
        return this.actionDefImpls;
    }

    @Override
    public List<PageActionDef> getActionDefs() {
        return this.actionDefs;
    }

    @Override
    public String getRows() {
        return this.pageActionDefSource.getRows().toString();
    }

    @Override
    public Set<String> getInvokeRoles() {
        if (this.isInvokable()) {
            return WebLogicRoles.ALL;
        }
        return WebLogicRoles.ALL;
    }

    ActionInputFormDefImpl getInputFormDefImpl() {
        return this.inputFormDefImpl;
    }

    @Override
    public ActionInputFormDef getInputFormDef() {
        return this.getInputFormDefImpl();
    }

    PageActionPollingDefImpl getPollingDefImpl() {
        return this.pollingDefImpl;
    }

    @Override
    public PageActionPollingDef getPollingDef() {
        return this.getPollingDefImpl();
    }

    private void initializePollingDef() {
        BeanActionPollingDefSource polling = this.getCustomizerSource().getPolling();
        this.pollingDefImpl = polling != null ? new PageActionPollingDefImpl(this, polling) : null;
    }

    private void initializeHelp() {
        this.initializeHelpSummaryHTML();
        this.initializeDetailedHelpHTML();
        this.initializePageActionExternalHelpDef();
    }

    private void initializeHelpSummaryHTML() {
        this.helpSummaryHTML = new LocalizableString(this.getHelpSummaryHTMLLocalizationKey(), this.getEnglishHelpSummaryHTML());
    }

    private void initializeDetailedHelpHTML() {
        this.detailedHelpHTML = new LocalizableString(this.getDetailedHelpHTMLLocalizationKey(), this.getEnglishDetailedHelpHTML());
    }

    private String getEnglishHelpSummaryHTML() {
        return HelpHTMLUtils.getEnglishHelpSummaryHTML(this.getSource().getDescriptionHTML(), this.getCustomizerSource().getHelpHTML(), this.getCustomizerSource().getHelpSummaryHTML(), this.getCustomizerSource().getHelpDetailsHTML());
    }

    private String getEnglishDetailedHelpHTML() {
        return HelpHTMLUtils.getEnglishDetailedHelpHTML(this.getSource().getDescriptionHTML(), this.getCustomizerSource().getHelpHTML(), this.getCustomizerSource().getHelpSummaryHTML(), this.getCustomizerSource().getHelpDetailsHTML());
    }

    private void initializePageActionExternalHelpDef() {
        BeanActionDef mbeanOperationActionDef = this.getMBeanOperationActionDef();
        if (mbeanOperationActionDef == null) {
            return;
        }
        this.externalHelpDefImpl = new PageActionExternalHelpDefImpl(this, mbeanOperationActionDef);
    }

    private BeanActionDef getMBeanOperationActionDef() {
        BeanActionDefImpl actionDefImpl;
        Path parentPath;
        if (this.getPageDefImpl().getPageRepoDefImpl().getBeanRepoDefImpl().getMBeansVersion().getWebLogicVersion() == null) {
            return null;
        }
        MBeanOperationDefSource source = this.getCustomizerSource().getMbeanOperation();
        String operationName = source.getOperation();
        if (StringUtils.isEmpty((String)operationName) && this.isPageLevelAction()) {
            return null;
        }
        String typeName = source.getType();
        BaseBeanTypeDefImpl typeDefImpl = StringUtils.isEmpty((String)typeName) ? this.getPageDefImpl().getTypeDefImpl() : this.getPageDefImpl().getTypeDefImpl().getBeanRepoDefImpl().getTypeDefImpl(typeName);
        boolean searchSubTypes = true;
        if (StringUtils.isEmpty((String)operationName)) {
            operationName = this.getActionName();
        }
        if (!(parentPath = (actionDefImpl = typeDefImpl.getActionDefImpl(new Path(operationName), searchSubTypes)).getParentPath()).isEmpty()) {
            actionDefImpl = typeDefImpl.getChildDefImpl(parentPath, searchSubTypes).getChildTypeDefImpl().getActionDefImpl(new Path(actionDefImpl.getActionName()), searchSubTypes);
        }
        if (actionDefImpl.getCustomizerSource().isDisableMBeanJavadoc() || actionDefImpl.getTypeDefImpl().isDisableMBeanJavadoc()) {
            return null;
        }
        return actionDefImpl;
    }

    private void initializeMessagesAndLabels() {
        this.label = new LocalizableString(this.getLabelLocalizationKey(), this.computeEnglishLabel());
        this.helpLabel = new LocalizableString(this.getHelpLabelLocalizationKey(), this.computeEnglishHelpLabel());
        String message = this.getCustomizerSource().getSuccessMessage();
        if (!StringUtils.isEmpty((String)message)) {
            this.successMessage = new LocalizableString(this.getSuccessMessageLocalizationKey(), message);
        }
        if (!StringUtils.isEmpty((String)(message = this.getCustomizerSource().getFailureMessage()))) {
            this.failureMessage = new LocalizableString(this.getFailureMessageLocalizationKey(), message);
        }
    }

    private String computeEnglishLabel() {
        String englishLabel = this.pageActionDefSource.getLabel();
        if (StringUtils.isEmpty((String)englishLabel)) {
            englishLabel = this.computeEnglishBeanActionLabel();
        }
        return englishLabel;
    }

    private String computeEnglishHelpLabel() {
        String englishLabel = this.getCustomizerSource().getHelpLabel();
        if (StringUtils.isEmpty((String)englishLabel)) {
            englishLabel = this.computeEnglishBeanActionLabel();
        }
        return englishLabel;
    }

    private String computeEnglishBeanActionLabel() {
        String englishLabel = this.getCustomizerSource().getLabel();
        if (StringUtils.isEmpty((String)englishLabel)) {
            englishLabel = StringUtils.camelCaseToUpperCaseWords((String)this.getCustomizerSource().getName());
        }
        return englishLabel;
    }

    private String getHelpSummaryHTMLLocalizationKey() {
        return this.getLocalizationKey("helpSummaryHTML");
    }

    private String getDetailedHelpHTMLLocalizationKey() {
        return this.getLocalizationKey("detailedHelpHTML");
    }

    private String getLabelLocalizationKey() {
        return this.getLocalizationKey("label");
    }

    private String getHelpLabelLocalizationKey() {
        return this.getLocalizationKey("helpLabel");
    }

    private String getSuccessMessageLocalizationKey() {
        return this.getLocalizationKey("successMessage");
    }

    private String getFailureMessageLocalizationKey() {
        return this.getLocalizationKey("failureMessage");
    }

    @Override
    String getLocalizationKey(String key) {
        return this.getPageDefImpl().getLocalizationKey("actions." + this.getActionPath().getDotSeparatedPath() + "." + key);
    }

    @Override
    public boolean isPageLevelAction() {
        return this.getCustomizerSource().getDefinition() != null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getPageDef()) + "action=<" + String.valueOf(this.getActionPath()) + ">";
    }
}

