/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import weblogic.console.schema.beaninfo.BeanActionDefSource;
import weblogic.console.schema.beaninfo.BeanPropertyDefSource;
import weblogic.console.schema.beaninfo.BeanTypeDefSource;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.DeleteBeanCustomizerDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.schema.BeanActionDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.BeanChildDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.BeanPropertyDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.BeanTypeDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.SubTypeDefSource;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanActionDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanChildDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanPropertyDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanRepoDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.DeleteBeanCustomizerDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PseudoBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.YamlBasedBeanTypeDefImpl;
import weblogic.remoteconsole.common.utils.WebLogicRoles;

public class NormalBeanTypeDefImpl
extends YamlBasedBeanTypeDefImpl {
    private static final Logger LOGGER = Logger.getLogger(NormalBeanTypeDefImpl.class.getName());
    private BeanTypeDefSource source;
    private BeanTypeDefCustomizerSource customizerSource;
    private BeanPropertyDefImpl keyPropertyDefImpl;
    private BeanPropertyDefImpl identityPropertyDefImpl;
    private boolean settable;
    private LocalizableString descriptionHTML;
    private DeleteBeanCustomizerDefImpl deleteCustomizerDefImpl;
    private List<BaseBeanTypeDefImpl> inheritedTypeDefImpls = new ArrayList<BaseBeanTypeDefImpl>();
    private Map<String, BaseBeanTypeDefImpl> subTypeDiscriminatorToSubTypeDefImplMap;

    public NormalBeanTypeDefImpl(BeanRepoDefImpl beanRepoDefImpl, BeanTypeDefSource source) {
        super(beanRepoDefImpl, source.getName());
        this.source = source;
        this.initializeCustomizerSource();
        this.initializeInstanceName(this.getCustomizerSource().getInstanceName());
        this.descriptionHTML = new LocalizableString(this.getLocalizationKey("descriptionHTML"), this.getSource().getDescriptionHTML());
        this.initializeInheritedTypeDefImpls();
        this.addContainedDefImpls();
        this.subTypeDiscriminatorToSubTypeDefImplMap = this.getCustomizerSource().getSubTypes().isEmpty() ? new HashMap() : null;
        this.findKeyAndIdentityPropertyDefImpls();
        this.computeSettable();
        this.initializeContainedDefsAndImpls();
    }

    @Override
    LocalizableString getDescriptionHTML() {
        return this.descriptionHTML;
    }

    @Override
    BeanPropertyDefImpl getKeyPropertyDefImpl() {
        return this.keyPropertyDefImpl;
    }

    @Override
    BeanPropertyDefImpl getIdentityPropertyDefImpl() {
        return this.identityPropertyDefImpl;
    }

    @Override
    public boolean isHomogeneous() {
        return this.getSubTypeDiscriminatorToSubTypeDefImplMap().isEmpty();
    }

    @Override
    BeanPropertyDefImpl getSubTypeDiscriminatorPropertyDefImpl() {
        if (this.isHomogeneous()) {
            return null;
        }
        return this.getHeterogeneousTypeSubTypeDiscriminatorPropertyDefImpl();
    }

    private BeanPropertyDefImpl getHeterogeneousTypeSubTypeDiscriminatorPropertyDefImpl() {
        Path propertyPath = new Path(this.getCustomizerSource().getSubTypeDiscriminatorProperty());
        return this.getPropertyDefImpl(propertyPath);
    }

    @Override
    public List<String> getSubTypeDiscriminatorLegalValues() {
        if (this.isHomogeneous()) {
            return null;
        }
        return new ArrayList<String>(this.getSubTypeDiscriminatorToSubTypeDefImplMap().keySet());
    }

    @Override
    BaseBeanTypeDefImpl getDefaultSubTypeDefImpl() {
        String dflt = this.getCustomizerSource().getDefaultSubType();
        if (!StringUtils.isEmpty((String)dflt)) {
            return this.getBeanRepoDefImpl().getTypeDefImpl(StringUtils.getLeafClassName((String)dflt));
        }
        return null;
    }

    @Override
    BaseBeanTypeDefImpl getSubTypeDefImpl(String subTypeDiscriminator) {
        if (this.isHomogeneous()) {
            return null;
        }
        if (this.getSubTypeDiscriminatorToSubTypeDefImplMap().containsKey(subTypeDiscriminator)) {
            return this.getSubTypeDiscriminatorToSubTypeDefImplMap().get(subTypeDiscriminator);
        }
        BaseBeanTypeDefImpl dflt = this.getDefaultSubTypeDefImpl();
        if (dflt != null) {
            return dflt;
        }
        throw new AssertionError((Object)("Invalid subtype discriminator: " + subTypeDiscriminator + " " + this.getTypeName() + " " + String.valueOf(this.getSubTypeDiscriminatorLegalValues())));
    }

    private void findKeyAndIdentityPropertyDefImpls() {
        for (BeanPropertyDefImpl propertyDefImpl : this.getPropertyNameToPropertyDefImplMap().values()) {
            if (!propertyDefImpl.getParentPath().isEmpty()) continue;
            if (propertyDefImpl.isKey()) {
                this.keyPropertyDefImpl = propertyDefImpl;
            } else if (this.keyPropertyDefImpl == null && "Name".equals(propertyDefImpl.getPropertyName())) {
                this.keyPropertyDefImpl = propertyDefImpl;
            }
            if (!propertyDefImpl.isIdentity()) continue;
            this.identityPropertyDefImpl = propertyDefImpl;
        }
        if (this.keyPropertyDefImpl != null && !this.keyPropertyDefImpl.isKey()) {
            this.keyPropertyDefImpl.setKey(true);
        }
    }

    private void computeSettable() {
        this.settable = !this.getBeanRepoDefImpl().isEditable() ? false : (!this.getBeanRepoDefImpl().isAccessAllowed(WebLogicRoles.ADMIN_ROLES) ? false : (this.getCustomizerSource().isSettableSpecifiedInYaml() ? this.getCustomizerSource().isSettable() : this.isType("SettableBean")));
    }

    @Override
    List<BaseBeanTypeDefImpl> getInheritedTypeDefImpls() {
        return this.inheritedTypeDefImpls;
    }

    void initializeInheritedTypeDefImpls() {
        for (String inheritedTypeName : this.getSource().getBaseTypes()) {
            this.inheritedTypeDefImpls.add(this.getBeanRepoDefImpl().getTypeDefImpl(StringUtils.getLeafClassName((String)inheritedTypeName)));
        }
    }

    @Override
    boolean isType(String desiredTypeName) {
        if (this.getTypeName().equals(desiredTypeName)) {
            return true;
        }
        for (BaseBeanTypeDefImpl inheritedTypeDefImpl : this.getInheritedTypeDefImpls()) {
            if (!inheritedTypeDefImpl.asYamlBasedBeanTypeDefImpl().isType(desiredTypeName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReferenceable() {
        return this.getCustomizerSource().isReferenceable();
    }

    @Override
    public boolean isOrdered() {
        return this.getCustomizerSource().isOrdered();
    }

    @Override
    public boolean isAllowSearch() {
        return this.getCustomizerSource().isAllowSearch();
    }

    @Override
    public boolean isSettable() {
        return this.settable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBeanCustomizerDef getDeleteCustomizerDef() {
        String deleteMethod = this.getCustomizerSource().getDeleteMethod();
        if (StringUtils.isEmpty((String)deleteMethod)) {
            return null;
        }
        if (this.deleteCustomizerDefImpl == null) {
            NormalBeanTypeDefImpl normalBeanTypeDefImpl = this;
            synchronized (normalBeanTypeDefImpl) {
                if (this.deleteCustomizerDefImpl == null) {
                    this.deleteCustomizerDefImpl = new DeleteBeanCustomizerDefImpl(this, deleteMethod);
                }
            }
        }
        return this.deleteCustomizerDefImpl;
    }

    @Override
    public String getCreateResourceMethod() {
        return this.getCustomizerSource().getCreateResourceMethod();
    }

    @Override
    public String getGetCollectionMethod() {
        return this.getCustomizerSource().getGetCollectionMethod();
    }

    @Override
    boolean isDisableMBeanJavadoc() {
        return this.getCustomizerSource().isDisableMBeanJavadoc();
    }

    private void initializeCustomizerSource() {
        this.customizerSource = this.getBeanRepoDefImpl().getYamlReader().getBeanTypeDefCustomizerSource(this);
        if (this.customizerSource == null) {
            this.customizerSource = new BeanTypeDefCustomizerSource();
        }
    }

    private void addContainedDefImpls() {
        ContainedDefsSourcesMerger merger = new ContainedDefsSourcesMerger();
        for (ContainedDefsSourcesMerger.PropertyDefSources propertyDefSources : merger.getPropertyDefsSources()) {
            this.addPropertyDefImpl(propertyDefSources);
        }
        for (ContainedDefsSourcesMerger.ChildDefSources childDefSources : merger.getChildDefsSources()) {
            this.addChildDefImpl(childDefSources);
        }
        for (ContainedDefsSourcesMerger.ActionDefSources actionDefSources : merger.getActionDefsSources()) {
            this.addActionDefImpl(actionDefSources);
        }
    }

    private void addPropertyDefImpl(ContainedDefsSourcesMerger.PropertyDefSources propertyDefSources) {
        BeanPropertyDefSource src = (BeanPropertyDefSource)propertyDefSources.getSource();
        if (!this.isSupported(src)) {
            LOGGER.finest("addPropertyDefImpl() skipping unsupported property " + this.getTypeName() + " " + src.getName());
            return;
        }
        if (src.isEncrypted() && src.getName().endsWith("Encrypted") && src.getType().equals("byte") && src.isArray()) {
            LOGGER.finest("addPropertyDefImpl() skipping encrypted " + this.getTypeName() + " " + src.getName());
            return;
        }
        BeanPropertyDefCustomizerSource customizerSrc = (BeanPropertyDefCustomizerSource)((Object)propertyDefSources.getCustomizerSource());
        customizerSrc.setName(this.source.getName());
        Path parentPath = propertyDefSources.getPath().getParent();
        if (!this.getBeanRepoDefImpl().supportsCapabilities(customizerSrc.getRequiredCapabilities())) {
            return;
        }
        BeanPropertyDefImpl propertyDefImpl = this.createBeanPropertyDefImpl(parentPath, src, customizerSrc);
        if (!propertyDefImpl.isSupportedType()) {
            LOGGER.finest("addPropertyDefImpl() skipping unsupported property type " + this.getTypeName() + " " + src.getName() + " " + src.getType());
            return;
        }
        this.addPropertyDefImpl(propertyDefImpl);
    }

    private void addChildDefImpl(ContainedDefsSourcesMerger.ChildDefSources childDefSources) {
        BeanPropertyDefSource src = (BeanPropertyDefSource)childDefSources.getSource();
        if (!this.isSupported(src)) {
            LOGGER.finest("addChildDefImpl() skipping unsupported child " + src.getName());
            return;
        }
        BeanChildDefCustomizerSource customizerSrc = (BeanChildDefCustomizerSource)((Object)childDefSources.getCustomizerSource());
        customizerSrc.setName(src.getName());
        Path parentPath = childDefSources.getPath().getParent();
        if (!this.getBeanRepoDefImpl().supportsCapabilities(customizerSrc.getRequiredCapabilities())) {
            return;
        }
        this.addChildDefImpl(this.createBeanChildDefImpl(parentPath, src, customizerSrc));
    }

    private void addActionDefImpl(ContainedDefsSourcesMerger.ActionDefSources actionDefSources) {
        Path parentPath = actionDefSources.getPath().getParent();
        BeanActionDefSource src = (BeanActionDefSource)actionDefSources.getSource();
        BeanActionDefCustomizerSource customizerSrc = (BeanActionDefCustomizerSource)((Object)actionDefSources.getCustomizerSource());
        customizerSrc.setName(src.getName());
        this.addActionDefImpl(this.createBeanActionDefImpl(parentPath, src, customizerSrc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, BaseBeanTypeDefImpl> getSubTypeDiscriminatorToSubTypeDefImplMap() {
        if (this.subTypeDiscriminatorToSubTypeDefImplMap == null) {
            NormalBeanTypeDefImpl normalBeanTypeDefImpl = this;
            synchronized (normalBeanTypeDefImpl) {
                if (this.subTypeDiscriminatorToSubTypeDefImplMap == null) {
                    this.subTypeDiscriminatorToSubTypeDefImplMap = this.initializeSubTypeDefImpls();
                }
            }
        }
        return this.subTypeDiscriminatorToSubTypeDefImplMap;
    }

    private Map<String, BaseBeanTypeDefImpl> initializeSubTypeDefImpls() {
        HashMap<String, BaseBeanTypeDefImpl> subTypesMap = new HashMap<String, BaseBeanTypeDefImpl>();
        for (SubTypeDefSource subTypeDefSource : this.getCustomizerSource().getSubTypes()) {
            if (!this.getBeanRepoDefImpl().supportsCapabilities(subTypeDefSource.getRequiredCapabilities())) continue;
            this.addImmediateSubType(subTypesMap, subTypeDefSource);
        }
        for (SubTypeDefSource subTypeDefSource : this.getCustomizerSource().getSubTypes()) {
            if (!this.getBeanRepoDefImpl().supportsCapabilities(subTypeDefSource.getRequiredCapabilities())) continue;
            this.addImmediateSubTypeSubTypes(subTypesMap, subTypeDefSource);
        }
        if (!subTypesMap.isEmpty() && this.getHeterogeneousTypeSubTypeDiscriminatorPropertyDefImpl() == null) {
            throw this.configurationError("subTypes defined but subTypeDisciminator not set or refers to a non-existing property");
        }
        return subTypesMap;
    }

    private void addImmediateSubType(Map<String, BaseBeanTypeDefImpl> subTypesMap, SubTypeDefSource subTypeDefSource) {
        String subTypeDiscriminator = subTypeDefSource.getValue();
        if (StringUtils.isEmpty((String)subTypeDiscriminator)) {
            subTypeDiscriminator = subTypeDefSource.getType();
        }
        String subTypeName = subTypeDefSource.getType();
        if (subTypesMap.containsKey(subTypeDiscriminator)) {
            throw this.configurationError("duplicate subType value: " + subTypeDiscriminator);
        }
        BaseBeanTypeDefImpl subTypeDefImpl = this.getBeanRepoDefImpl().getTypeDefImpl(StringUtils.getLeafClassName((String)subTypeName));
        if (subTypeDefImpl != null) {
            if (subTypesMap.containsValue(subTypeDefImpl)) {
                throw this.configurationError("duplicate subType type: " + subTypeName);
            }
            subTypesMap.put(subTypeDiscriminator, subTypeDefImpl);
        }
    }

    private void addImmediateSubTypeSubTypes(Map<String, BaseBeanTypeDefImpl> subTypesMap, SubTypeDefSource subTypeDefSource) {
        String subTypeDiscriminator = subTypeDefSource.getValue();
        BaseBeanTypeDefImpl subTypeDefImpl = subTypesMap.get(subTypeDiscriminator);
        if (subTypeDefImpl == null) {
            return;
        }
        if (subTypeDefImpl == this) {
            return;
        }
        if (subTypeDefImpl instanceof PseudoBeanTypeDefImpl) {
            return;
        }
        if (subTypeDefImpl.isHomogeneous()) {
            return;
        }
        for (String subSubTypeDiscriminator : subTypeDefImpl.getSubTypeDiscriminatorLegalValues()) {
            BaseBeanTypeDefImpl subSubTypeDefImpl = subTypeDefImpl.getSubTypeDefImpl(subSubTypeDiscriminator);
            if (subSubTypeDefImpl == null || !subTypesMap.containsKey(subSubTypeDiscriminator)) continue;
            BaseBeanTypeDefImpl oldSubSubTypeDefImpl = subTypesMap.get(subSubTypeDiscriminator);
            if (subSubTypeDefImpl != oldSubSubTypeDefImpl) {
                throw new AssertionError((Object)("Previously registered sub type mismatch: type=" + this.getTypeName() + " subtype discriminator=" + subTypeDiscriminator + " subtype=" + subTypeDefImpl.getTypeName() + " subsubtype discriminator=" + subSubTypeDiscriminator + " previous subsubtype=" + oldSubSubTypeDefImpl.getTypeName() + " subsubtype=" + subSubTypeDefImpl.getTypeName()));
            }
            subTypesMap.put(subSubTypeDiscriminator, subSubTypeDefImpl);
        }
    }

    private BeanTypeDefSource getSource() {
        return this.source;
    }

    @Override
    BeanTypeDefSource getTypeDefSource() {
        return this.getSource();
    }

    @Override
    boolean isEditable() {
        if (this.getCustomizerSource().isEditableSpecifiedInYaml()) {
            return this.getCustomizerSource().isEditable();
        }
        return this.getBeanRepoDefImpl().isEditable();
    }

    private BeanTypeDefCustomizerSource getCustomizerSource() {
        return this.customizerSource;
    }

    protected boolean isSupported(BeanPropertyDefSource source) {
        return source.isSupported();
    }

    private class ContainedDefsSourcesMerger {
        private Map<String, PropertyDefSources> propertyPathToPropertyDefSourcesMap = new HashMap<String, PropertyDefSources>();
        private Map<String, ChildDefSources> childPathToChildDefSourcesMap = new HashMap<String, ChildDefSources>();
        private Map<String, ActionDefSources> actionPathToActionDefSourcesMap = new HashMap<String, ActionDefSources>();

        private ContainedDefsSourcesMerger() {
            this.merge();
        }

        private void merge() {
            this.addLocalContainedDefsSources();
            this.addFoldableContainedDefsSources();
            this.addInheritedContainedDefsSources();
            this.customizeContainedDefsSources();
        }

        private void addLocalContainedDefsSources() {
            this.addLocalPropertyAndChildDefsSources(NormalBeanTypeDefImpl.this.getSource().getProperties());
            this.addLocalActionDefsSources(NormalBeanTypeDefImpl.this.getSource().getActions());
            this.addLocalActionDefsSources(this.getCustomActionSources());
        }

        private List<BeanActionDefSource> getCustomActionSources() {
            ArrayList<BeanActionDefSource> actionSources = new ArrayList<BeanActionDefSource>();
            for (BeanActionDefCustomizerSource actionCustomizerSource : NormalBeanTypeDefImpl.this.getCustomizerSource().getActions()) {
                BeanActionDefSource actionSource = actionCustomizerSource.getDefinition();
                if (actionSource == null) continue;
                actionSource.setName(actionCustomizerSource.getName());
                actionSources.add(actionSource);
            }
            return actionSources;
        }

        private void addLocalPropertyAndChildDefsSources(List<BeanPropertyDefSource> propertyDefSources) {
            for (BeanPropertyDefSource propertyDefSource : propertyDefSources) {
                Path path = new Path(propertyDefSource.getName());
                if (propertyDefSource.isChild()) {
                    this.addChildDefSources(path, propertyDefSource, new BeanChildDefCustomizerSource());
                    continue;
                }
                this.addPropertyDefSources(path, propertyDefSource, new BeanPropertyDefCustomizerSource());
            }
        }

        private void addLocalActionDefsSources(List<BeanActionDefSource> actionDefSources) {
            for (BeanActionDefSource actionDefSource : actionDefSources) {
                Path path = new Path(actionDefSource.getName());
                this.addActionDefSources(path, actionDefSource, new BeanActionDefCustomizerSource());
            }
        }

        private void addFoldableContainedDefsSources() {
            this.addFoldableContainedDefsSources(NormalBeanTypeDefImpl.this.getSource().getProperties());
        }

        private void addFoldableContainedDefsSources(List<BeanPropertyDefSource> propertyDefSources) {
            for (BeanPropertyDefSource propertyDefSource : propertyDefSources) {
                if (!propertyDefSource.isChild() || !NormalBeanTypeDefImpl.this.isSupported(propertyDefSource)) continue;
                boolean isCollection = propertyDefSource.isArray();
                boolean isCreatable = !propertyDefSource.getCreators().isEmpty();
                boolean isFoldable = !isCollection && !isCreatable;
                if (!isFoldable) continue;
                Path childPath = new Path(propertyDefSource.getName());
                String childTypeName = StringUtils.getLeafClassName((String)propertyDefSource.getType());
                YamlBasedBeanTypeDefImpl childTypeDefImpl = NormalBeanTypeDefImpl.this.getBeanRepoDefImpl().getTypeDefImpl(childTypeName).asYamlBasedBeanTypeDefImpl();
                if (!childTypeDefImpl.isHomogeneous()) continue;
                this.addOrMergeContainedDefSources(childPath, childTypeDefImpl);
            }
        }

        private void addInheritedContainedDefsSources() {
            for (String inheritedTypeName : NormalBeanTypeDefImpl.this.getSource().getBaseTypes()) {
                this.addOrMergeContainedDefSources(new Path(), NormalBeanTypeDefImpl.this.getBeanRepoDefImpl().getTypeDefImpl(StringUtils.getLeafClassName((String)inheritedTypeName)).asYamlBasedBeanTypeDefImpl());
            }
        }

        private void addOrMergeContainedDefSources(Path parentPath, YamlBasedBeanTypeDefImpl typeDefImpl) {
            for (BeanPropertyDefImpl propertyDefImpl : typeDefImpl.getPropertyNameToPropertyDefImplMap().values()) {
                this.addOrMergePropertyDefSources(parentPath, propertyDefImpl);
            }
            for (BeanChildDefImpl childDefImpl : typeDefImpl.getChildNameToChildDefImplMap().values()) {
                this.addOrMergeChildDefSources(parentPath, childDefImpl);
            }
            for (BeanActionDefImpl actionDefImpl : typeDefImpl.getActionNameToActionDefImplMap().values()) {
                this.addOrMergeActionDefSources(parentPath, actionDefImpl);
            }
        }

        private void addOrMergePropertyDefSources(Path parentPath, BeanPropertyDefImpl propertyDefImpl) {
            Path propertyPath = parentPath.childPath(propertyDefImpl.getPropertyPath());
            if (!this.hasPropertyDefSources(propertyPath)) {
                this.addPropertyDefSources(parentPath, propertyDefImpl, false);
            }
            this.getPropertyDefSources(propertyPath).merge(propertyDefImpl, parentPath);
        }

        private void addOrMergeChildDefSources(Path parentPath, BeanChildDefImpl childDefImpl) {
            Path childPath = parentPath.childPath(childDefImpl.getChildPath());
            if (!NormalBeanTypeDefImpl.this.hasChildDef(childPath)) {
                this.addChildDefSources(parentPath, childDefImpl, false);
            }
            this.getChildDefSources(childPath).merge(childDefImpl, parentPath);
        }

        private void addOrMergeActionDefSources(Path parentPath, BeanActionDefImpl actionDefImpl) {
            Path actionPath = parentPath.childPath(actionDefImpl.getActionPath());
            if (!NormalBeanTypeDefImpl.this.hasActionDef(actionPath)) {
                this.addActionDefSources(parentPath, actionDefImpl, false);
            }
            this.getActionDefSources(actionPath).merge(actionDefImpl, parentPath);
        }

        private void customizeContainedDefsSources() {
            this.customizePropertyDefsSources();
            this.customizeChildDefsSources();
            this.customizeActionDefsSources();
        }

        private void customizePropertyDefsSources() {
            for (BeanPropertyDefCustomizerSource propertyDefCustomizerSource : NormalBeanTypeDefImpl.this.getCustomizerSource().getProperties()) {
                Path propertyPath = new Path(propertyDefCustomizerSource.getName());
                if (!this.hasPropertyDefSources(propertyPath)) continue;
                this.getPropertyDefSources(propertyPath).merge(propertyDefCustomizerSource, new Path());
            }
        }

        private void customizeChildDefsSources() {
            for (BeanChildDefCustomizerSource childCustomizerSource : NormalBeanTypeDefImpl.this.getCustomizerSource().getChildren()) {
                Path childPath = new Path(childCustomizerSource.getName());
                if (!this.hasChildDefSources(childPath)) continue;
                this.getChildDefSources(childPath).merge(childCustomizerSource, new Path());
            }
        }

        private void customizeActionDefsSources() {
            for (BeanActionDefCustomizerSource actionCustomizerSource : NormalBeanTypeDefImpl.this.getCustomizerSource().getActions()) {
                Path actionPath = new Path(actionCustomizerSource.getName());
                if (!this.hasActionDefSources(actionPath)) continue;
                this.getActionDefSources(actionPath).merge(actionCustomizerSource, new Path());
            }
        }

        private Map<String, PropertyDefSources> getPropertyPathToPropertyDefSourcesMap() {
            return this.propertyPathToPropertyDefSourcesMap;
        }

        private Map<String, ChildDefSources> getChildPathToChildDefSourcesMap() {
            return this.childPathToChildDefSourcesMap;
        }

        private Map<String, ActionDefSources> getActionPathToActionDefSourcesMap() {
            return this.actionPathToActionDefSourcesMap;
        }

        private Collection<PropertyDefSources> getPropertyDefsSources() {
            return this.getPropertyPathToPropertyDefSourcesMap().values();
        }

        private Collection<ChildDefSources> getChildDefsSources() {
            return this.getChildPathToChildDefSourcesMap().values();
        }

        private Collection<ActionDefSources> getActionDefsSources() {
            return this.getActionPathToActionDefSourcesMap().values();
        }

        private boolean hasPropertyDefSources(Path propertyPath) {
            return this.getPropertyPathToPropertyDefSourcesMap().containsKey(this.getKey(propertyPath));
        }

        private boolean hasChildDefSources(Path childPath) {
            return this.getChildPathToChildDefSourcesMap().containsKey(this.getKey(childPath));
        }

        private boolean hasActionDefSources(Path actionPath) {
            return this.getActionPathToActionDefSourcesMap().containsKey(this.getKey(actionPath));
        }

        private PropertyDefSources getPropertyDefSources(Path propertyPath) {
            return this.getPropertyPathToPropertyDefSourcesMap().get(this.getKey(propertyPath));
        }

        private ChildDefSources getChildDefSources(Path childPath) {
            return this.getChildPathToChildDefSourcesMap().get(this.getKey(childPath));
        }

        private ActionDefSources getActionDefSources(Path actionPath) {
            return this.getActionPathToActionDefSourcesMap().get(this.getKey(actionPath));
        }

        private void addPropertyDefSources(Path parentPath, BeanPropertyDefImpl propertyDefImpl, boolean useCustomizations) {
            BeanPropertyDefCustomizerSource customizerSrc = useCustomizations ? propertyDefImpl.getCustomizerSource() : new BeanPropertyDefCustomizerSource();
            this.addPropertyDefSources(parentPath.childPath(propertyDefImpl.getPropertyPath()), propertyDefImpl.getSource(), customizerSrc);
        }

        private void addPropertyDefSources(Path propertyPath, BeanPropertyDefSource src, BeanPropertyDefCustomizerSource customizerSrc) {
            this.getPropertyPathToPropertyDefSourcesMap().put(this.getKey(propertyPath), new PropertyDefSources(propertyPath, src, customizerSrc));
        }

        private void addChildDefSources(Path parentPath, BeanChildDefImpl childDefImpl, boolean useCustomizations) {
            BeanChildDefCustomizerSource customizerSrc = useCustomizations ? childDefImpl.getCustomizerSource() : new BeanChildDefCustomizerSource();
            this.addChildDefSources(parentPath.childPath(childDefImpl.getChildPath()), childDefImpl.getSource(), customizerSrc);
        }

        private void addChildDefSources(Path childPath, BeanPropertyDefSource src, BeanChildDefCustomizerSource customizerSrc) {
            this.getChildPathToChildDefSourcesMap().put(this.getKey(childPath), new ChildDefSources(childPath, src, customizerSrc));
        }

        private void addActionDefSources(Path parentPath, BeanActionDefImpl actionDefImpl, boolean useCustomizations) {
            BeanActionDefCustomizerSource customizerSrc = useCustomizations ? actionDefImpl.getCustomizerSource() : new BeanActionDefCustomizerSource();
            this.addActionDefSources(parentPath.childPath(actionDefImpl.getActionPath()), actionDefImpl.getSource(), customizerSrc);
        }

        private void addActionDefSources(Path actionPath, BeanActionDefSource src, BeanActionDefCustomizerSource customizerSrc) {
            this.getActionPathToActionDefSourcesMap().put(this.getKey(actionPath), new ActionDefSources(actionPath, src, customizerSrc));
        }

        private String getKey(Path path) {
            return path.getDotSeparatedPath();
        }

        private class PropertyDefSources
        extends DefSources<BeanPropertyDefSource, BeanPropertyDefCustomizerSource> {
            private void merge(BeanPropertyDefImpl propertyDefImpl, Path propertyDefImplContainedBeanPath) {
                this.merge(propertyDefImpl.getCustomizerSource(), propertyDefImplContainedBeanPath);
            }

            private void merge(BeanPropertyDefCustomizerSource from, Path fromContainedBeanPath) {
                ((BeanPropertyDefCustomizerSource)((Object)this.getCustomizerSource())).merge(from, fromContainedBeanPath);
            }

            private PropertyDefSources(Path path, BeanPropertyDefSource source, BeanPropertyDefCustomizerSource customizerSource) {
                super(path, source, customizerSource);
            }
        }

        private class ChildDefSources
        extends DefSources<BeanPropertyDefSource, BeanChildDefCustomizerSource> {
            private void merge(BeanChildDefImpl childDefImpl, Path childDefImplContainedBeanPath) {
                this.merge(childDefImpl.getCustomizerSource(), childDefImplContainedBeanPath);
            }

            private void merge(BeanChildDefCustomizerSource from, Path fromContainedBeanPath) {
                ((BeanChildDefCustomizerSource)((Object)this.getCustomizerSource())).merge(from, fromContainedBeanPath);
            }

            private ChildDefSources(Path path, BeanPropertyDefSource source, BeanChildDefCustomizerSource customizerSource) {
                super(path, source, customizerSource);
            }
        }

        private class ActionDefSources
        extends DefSources<BeanActionDefSource, BeanActionDefCustomizerSource> {
            private void merge(BeanActionDefImpl actionDefImpl, Path actionDefImplContainedBeanPath) {
                this.merge(actionDefImpl.getCustomizerSource(), actionDefImplContainedBeanPath);
            }

            private void merge(BeanActionDefCustomizerSource from, Path fromContainedBeanPath) {
                ((BeanActionDefCustomizerSource)((Object)this.getCustomizerSource())).merge(from, fromContainedBeanPath);
            }

            private ActionDefSources(Path path, BeanActionDefSource source, BeanActionDefCustomizerSource customizerSource) {
                super(path, source, customizerSource);
            }
        }

        private class DefSources<S, C> {
            private Path path;
            private S source;
            private C customizerSource;

            Path getPath() {
                return this.path;
            }

            S getSource() {
                return this.source;
            }

            C getCustomizerSource() {
                return this.customizerSource;
            }

            private DefSources(Path path, S source, C customizerSource) {
                this.path = path;
                this.source = source;
                this.customizerSource = customizerSource;
            }
        }
    }
}

