/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildNavTreeNodeDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.NavTreeDef;
import weblogic.remoteconsole.common.repodef.NavTreeNodeDef;
import weblogic.remoteconsole.common.repodef.PageRepoDef;
import weblogic.remoteconsole.common.repodef.schema.NavTreeDefSource;
import weblogic.remoteconsole.common.repodef.schema.NavTreeNodeDefSource;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanChildNavTreeNodeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.GroupNavTreeNodeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.NavTreeNodeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PageRepoDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.RoleUtils;

class NavTreeDefImpl
implements NavTreeDef {
    private PageRepoDefImpl pageRepoDefImpl;
    private BaseBeanTypeDefImpl typeDefImpl;
    private NavTreeDefSource source;
    private List<NavTreeNodeDefImpl> contentDefImpls = new ArrayList<NavTreeNodeDefImpl>();
    private List<NavTreeNodeDef> contentDefs;
    private Map<String, BeanChildNavTreeNodeDefImpl> childPathToNodeDefImplMap = new HashMap<String, BeanChildNavTreeNodeDefImpl>();
    private Map<String, NavTreeNodeDefImpl> navTreePathToNodeDefImplMap = new HashMap<String, NavTreeNodeDefImpl>();

    NavTreeDefImpl(PageRepoDefImpl pageRepoDefImpl, NavTreeDefSource source, BaseBeanTypeDefImpl typeDefImpl) {
        this.pageRepoDefImpl = pageRepoDefImpl;
        this.source = source;
        this.typeDefImpl = typeDefImpl;
        this.createNodeDefImpls();
    }

    PageRepoDefImpl getPageRepoDefImpl() {
        return this.pageRepoDefImpl;
    }

    @Override
    public PageRepoDef getPageRepoDef() {
        return this.getPageRepoDefImpl();
    }

    BaseBeanTypeDefImpl getTypeDefImpl() {
        return this.typeDefImpl;
    }

    @Override
    public BeanTypeDef getTypeDef() {
        return this.getTypeDefImpl();
    }

    private Map<String, BeanChildNavTreeNodeDefImpl> getChildPathToNodeDefImplMap() {
        return this.childPathToNodeDefImplMap;
    }

    private Map<String, NavTreeNodeDefImpl> getNavTreePathToNodeDefImplMap() {
        return this.navTreePathToNodeDefImplMap;
    }

    private NavTreeDefSource getSource() {
        return this.source;
    }

    List<NavTreeNodeDefImpl> getContentDefImpls() {
        return this.contentDefImpls;
    }

    @Override
    public List<NavTreeNodeDef> getContentDefs() {
        return this.contentDefs;
    }

    BeanChildNavTreeNodeDefImpl findNodeDefImplByChildPath(Path relativeChildPath) {
        return this.getChildPathToNodeDefImplMap().get(relativeChildPath.getDotSeparatedPath());
    }

    @Override
    public BeanChildNavTreeNodeDef findNodeByChildPath(Path relativeChildPath) {
        return this.findNodeDefImplByChildPath(relativeChildPath);
    }

    NavTreeNodeDefImpl findNodeDefImplByNavTreePath(Path relativeNavTreePath) {
        return this.getNavTreePathToNodeDefImplMap().get(relativeNavTreePath.getDotSeparatedPath());
    }

    @Override
    public NavTreeNodeDef findNodeByNavTreePath(Path relativeNavTreePath) {
        return this.findNodeDefImplByNavTreePath(relativeNavTreePath);
    }

    private void createNodeDefImpls() {
        GroupNavTreeNodeDefImpl groupNodeDefImpl = null;
        this.contentDefImpls = this.createNavTreeNodeDefImpls(this.getSource().getContents(), groupNodeDefImpl);
        this.contentDefs = Collections.unmodifiableList(this.getContentDefImpls());
    }

    List<NavTreeNodeDefImpl> createNavTreeNodeDefImpls(List<NavTreeNodeDefSource> sources, GroupNavTreeNodeDefImpl groupNodeDefImpl) {
        if (sources.isEmpty()) {
            throw new AssertionError((Object)("No nav tree nodes for " + String.valueOf(this.getTypeDefImpl())));
        }
        ArrayList<NavTreeNodeDefImpl> nodeDefImpls = new ArrayList<NavTreeNodeDefImpl>();
        for (NavTreeNodeDefSource source : sources) {
            NavTreeNodeDefImpl nodeDefImpl = this.createNavTreeNodeDefImpl(source, groupNodeDefImpl);
            if (nodeDefImpl == null) continue;
            nodeDefImpls.add(nodeDefImpl);
            if (nodeDefImpl.isChildNodeDef()) {
                BeanChildNavTreeNodeDefImpl childNodeDefImpl = nodeDefImpl.asChildNodeDefImpl();
                this.getChildPathToNodeDefImplMap().put(childNodeDefImpl.getChildNodePath().getDotSeparatedPath(), childNodeDefImpl);
            }
            this.getNavTreePathToNodeDefImplMap().put(this.getNavTreePath(nodeDefImpl).getDotSeparatedPath(), nodeDefImpl);
        }
        return nodeDefImpls;
    }

    private Path getNavTreePath(NavTreeNodeDefImpl nodeDefImpl) {
        Path navTreePath = new Path(nodeDefImpl.getNodeName());
        for (GroupNavTreeNodeDefImpl groupNodeDefImpl = nodeDefImpl.getGroupNodeDefImpl(); groupNodeDefImpl != null; groupNodeDefImpl = groupNodeDefImpl.getGroupNodeDefImpl()) {
            navTreePath = new Path(groupNodeDefImpl.getNodeName()).childPath(navTreePath);
        }
        return navTreePath;
    }

    private NavTreeNodeDefImpl createNavTreeNodeDefImpl(NavTreeNodeDefSource source, GroupNavTreeNodeDefImpl groupNodeDefImpl) {
        if (!this.getPageRepoDefImpl().getBeanRepoDefImpl().isAccessAllowed(RoleUtils.computeNavTreeNodeRoles(source))) {
            return null;
        }
        NavTreeNodeDefSource.Type type = source.getType();
        if (NavTreeNodeDefSource.Type.child == type) {
            return BeanChildNavTreeNodeDefImpl.newNode(this, source, groupNodeDefImpl);
        }
        if (NavTreeNodeDefSource.Type.group == type) {
            return new GroupNavTreeNodeDefImpl(this, source, groupNodeDefImpl);
        }
        throw new AssertionError((Object)("Not a group or child nav tree node: " + String.valueOf((Object)type) + " " + String.valueOf(this.getTypeDef())));
    }
}

