/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.LinkDef;
import weblogic.remoteconsole.common.repodef.LinksDef;
import weblogic.remoteconsole.common.repodef.PageRepoDef;
import weblogic.remoteconsole.common.repodef.schema.LinkDefSource;
import weblogic.remoteconsole.common.repodef.schema.LinksDefSource;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.LinkDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PageRepoDefImpl;

class LinksDefImpl
implements LinksDef {
    private PageRepoDefImpl pageRepoDefImpl;
    private BaseBeanTypeDefImpl typeDefImpl;
    private LinksDefSource source;
    private List<LinkDefImpl> instanceLinkDefImpls = new ArrayList<LinkDefImpl>();
    private List<LinkDef> instanceLinkDefs;
    private List<LinkDefImpl> collectionLinkDefImpls = new ArrayList<LinkDefImpl>();
    private List<LinkDef> collectionLinkDefs;

    LinksDefImpl(PageRepoDefImpl pageRepoDefImpl, LinksDefSource source, BaseBeanTypeDefImpl typeDefImpl) {
        this.pageRepoDefImpl = pageRepoDefImpl;
        this.source = source;
        this.typeDefImpl = typeDefImpl;
        this.createLinkDefImpls();
    }

    PageRepoDefImpl getPageRepoDefImpl() {
        return this.pageRepoDefImpl;
    }

    @Override
    public PageRepoDef getPageRepoDef() {
        return this.getPageRepoDefImpl();
    }

    BaseBeanTypeDefImpl getTypeDefImpl() {
        return this.typeDefImpl;
    }

    @Override
    public BeanTypeDef getTypeDef() {
        return this.getTypeDefImpl();
    }

    List<LinkDefImpl> getInstanceLinkDefImpls() {
        return this.instanceLinkDefImpls;
    }

    @Override
    public List<LinkDef> getInstanceLinkDefs() {
        return this.instanceLinkDefs;
    }

    List<LinkDefImpl> getCollectionLinkDefImpls() {
        return this.collectionLinkDefImpls;
    }

    @Override
    public List<LinkDef> getCollectionLinkDefs() {
        return this.collectionLinkDefs;
    }

    private void createLinkDefImpls() {
        if (this.source != null) {
            for (LinkDefSource linkDefSource : this.source.getInstanceLinks()) {
                if (!this.pageRepoDefImpl.getBeanRepoDefImpl().supportsCapabilities(linkDefSource.getRequiredCapabilities())) continue;
                this.getInstanceLinkDefImpls().add(new LinkDefImpl(this, linkDefSource, false));
            }
            for (LinkDefSource linkDefSource : this.source.getCollectionLinks()) {
                if (!this.pageRepoDefImpl.getBeanRepoDefImpl().supportsCapabilities(linkDefSource.getRequiredCapabilities())) continue;
                this.getCollectionLinkDefImpls().add(new LinkDefImpl(this, linkDefSource, true));
            }
        } else {
            this.copyInheritedLinks(this.getTypeDefImpl());
        }
        this.instanceLinkDefs = Collections.unmodifiableList(this.getInstanceLinkDefImpls());
        this.collectionLinkDefs = Collections.unmodifiableList(this.getCollectionLinkDefImpls());
    }

    private void copyInheritedLinks(BaseBeanTypeDefImpl typeDefImpl) {
        for (BaseBeanTypeDefImpl inheritedTypeDefImpl : typeDefImpl.getInheritedTypeDefImpls()) {
            LinksDefImpl inheritedLinksDefImpl = this.pageRepoDefImpl.getLinksDefImpl(inheritedTypeDefImpl);
            if (inheritedLinksDefImpl != null) {
                for (LinkDefImpl inheritedLinkDefImpl : inheritedLinksDefImpl.getInstanceLinkDefImpls()) {
                    this.getInstanceLinkDefImpls().add(new LinkDefImpl(this, inheritedLinkDefImpl));
                }
                for (LinkDefImpl inheritedLinkDefImpl : inheritedLinksDefImpl.getCollectionLinkDefImpls()) {
                    this.getCollectionLinkDefImpls().add(new LinkDefImpl(this, inheritedLinkDefImpl));
                }
                continue;
            }
            this.copyInheritedLinks(inheritedTypeDefImpl);
        }
    }
}

