/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.LinkDef;
import weblogic.remoteconsole.common.repodef.LinksDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.schema.LinkDefSource;
import weblogic.remoteconsole.common.repodef.yaml.LinksDefImpl;

class LinkDefImpl
implements LinkDef {
    private LinksDefImpl linksDefImpl;
    private LinkDefSource source;
    private boolean isCollectionLink;
    private LocalizableString notFoundMessage;
    private LocalizableString label;

    LinkDefImpl(LinksDefImpl linksDefImpl, LinkDefImpl toClone) {
        this(linksDefImpl, toClone.getSource(), toClone.isCollectionLink);
    }

    LinkDefImpl(LinksDefImpl linksDefImpl, LinkDefSource source, boolean isCollectionLink) {
        this.linksDefImpl = linksDefImpl;
        this.source = source;
        this.isCollectionLink = isCollectionLink;
        String englishNotFoundMessage = source.getNotFoundMessage();
        if (StringUtils.notEmpty((String)englishNotFoundMessage)) {
            this.notFoundMessage = new LocalizableString(this.getLocalizationKey("notfound." + englishNotFoundMessage), englishNotFoundMessage);
        }
        String englishLabel = source.getLabel();
        this.label = new LocalizableString(this.getLocalizationKey("label." + englishLabel), englishLabel);
    }

    private LinksDefImpl getLinksDefImpl() {
        return this.linksDefImpl;
    }

    @Override
    public LinksDef getLinkDefs() {
        return this.getLinksDefImpl();
    }

    LinkDefSource getSource() {
        return this.source;
    }

    private boolean isCollectionLink() {
        return this.isCollectionLink;
    }

    @Override
    public String getRoot() {
        return this.getSource().getRoot();
    }

    @Override
    public String getResourceData() {
        return this.getSource().getResourceData();
    }

    @Override
    public LocalizableString getNotFoundMessage() {
        return this.notFoundMessage;
    }

    @Override
    public LocalizableString getLabel() {
        return this.label;
    }

    private String getLocalizationKey(String key) {
        StringBuilder sb = new StringBuilder();
        sb.append("link.").append(key);
        if (this.isCollectionLink()) {
            sb.append(".collection");
        } else {
            sb.append(".instance");
        }
        return this.getLinksDefImpl().getTypeDefImpl().getLocalizationKey(sb.toString());
    }
}

