/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import weblogic.remoteconsole.common.repodef.HelpTopicDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.schema.HelpTopicDefSource;
import weblogic.remoteconsole.common.repodef.yaml.PageDefImpl;
import weblogic.remoteconsole.common.utils.WebLogicVersion;

class HelpTopicDefImpl
implements HelpTopicDef {
    private PageDefImpl pageDefImpl;
    HelpTopicDefSource source;
    private LocalizableString label;
    int index;
    private String href;

    HelpTopicDefImpl(PageDefImpl pageDefImpl, HelpTopicDefSource source, int index) {
        this.pageDefImpl = pageDefImpl;
        this.source = source;
        this.index = index;
        this.label = new LocalizableString(this.getLocalizationKey("label"), this.getSource().getLabel());
        this.href = this.calculateHelpTopicHref();
    }

    PageDefImpl getPageDefImpl() {
        return this.pageDefImpl;
    }

    @Override
    public PageDef getPageDef() {
        return this.getPageDefImpl();
    }

    private HelpTopicDefSource getSource() {
        return this.source;
    }

    @Override
    public LocalizableString getLabel() {
        return this.label;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    private String calculateHelpTopicHref() {
        HelpTopicDefSource.Type type = this.getSource().getType();
        String relativeHref = this.getSource().getHref();
        WebLogicVersion version = this.getPageDefImpl().getPageRepoDefImpl().getBeanRepoDefImpl().getMBeansVersion().getWebLogicVersion();
        if (HelpTopicDefSource.Type.edocs.equals((Object)type)) {
            return version.getEdocsHelpTopicUrl(relativeHref);
        }
        if (HelpTopicDefSource.Type.CoherenceEdocs.equals((Object)type)) {
            return version.getCoherenceEdocsHelpTopicUrl(relativeHref);
        }
        if (HelpTopicDefSource.Type.generic.equals((Object)type)) {
            return version.getGenericHelpTopicUrl(relativeHref);
        }
        throw new AssertionError((Object)("Unsupported help topic: type=" + String.valueOf((Object)type) + " href=" + relativeHref));
    }

    private String getLocalizationKey(String key) {
        return this.getPageDefImpl().getLocalizationKey("helpTopic") + "." + this.index + "." + key;
    }
}

