/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import weblogic.console.utils.StringUtils;

public class HelpHTMLUtils {
    private static final String PARA_BEGIN = "<p>";
    private static final String PARA_END = "</p>";

    private HelpHTMLUtils() {
    }

    public static String getEnglishHelpSummaryHTML(String harvestedHelp, String pdyHelp, String pdySummary, String pdyDetails) {
        HelpHTMLUtils.validateHelpHTMLProperties(pdyHelp, pdySummary, pdyDetails);
        if (StringUtils.notEmpty((String)pdyHelp)) {
            return pdyHelp;
        }
        if (StringUtils.notEmpty((String)pdySummary)) {
            return pdySummary;
        }
        return HelpHTMLUtils.getSummary(harvestedHelp);
    }

    public static String getEnglishDetailedHelpHTML(String harvestedHelp, String pdyHelp, String pdySummary, String pdyDetails) {
        HelpHTMLUtils.validateHelpHTMLProperties(pdyHelp, pdySummary, pdyDetails);
        if (StringUtils.notEmpty((String)pdyHelp)) {
            return pdyHelp;
        }
        if (StringUtils.notEmpty((String)pdySummary)) {
            if (StringUtils.notEmpty((String)pdyDetails)) {
                return pdySummary + pdyDetails;
            }
            return HelpHTMLUtils.replaceSummary(harvestedHelp, pdySummary);
        }
        if (StringUtils.isEmpty((String)pdyDetails)) {
            return harvestedHelp;
        }
        throw new AssertionError((Object)("Specified helpDetailsHTML but not helpSummaryHTML: '" + pdySummary + "'"));
    }

    private static void validateHelpHTMLProperties(String pdyHelp, String pdySummary, String pdyDetails) {
        if (StringUtils.notEmpty((String)pdyHelp)) {
            if (StringUtils.notEmpty((String)pdySummary)) {
                throw new AssertionError((Object)("Specified helpHTML and helpSummaryHTML: '" + pdyHelp + "', '" + pdySummary + "'"));
            }
            if (StringUtils.notEmpty((String)pdyDetails)) {
                throw new AssertionError((Object)("Specified helpHTML and helpDetailsHTML: '" + pdyHelp + "', '" + pdyDetails + "'"));
            }
        }
    }

    private static String replaceSummary(String harvestedHelp, String pdySummary) {
        String harvestedSummary = HelpHTMLUtils.getSummary(harvestedHelp);
        pdySummary = HelpHTMLUtils.getFirstParagraph(pdySummary);
        int idx = harvestedHelp.indexOf(harvestedSummary);
        String harvestedBeforeSummary = harvestedHelp.substring(0, idx);
        String harvestedAfterSummary = harvestedHelp.substring(idx + harvestedSummary.length());
        return harvestedBeforeSummary + pdySummary + harvestedAfterSummary;
    }

    private static String getSummary(String html) {
        if (html == null) {
            return null;
        }
        return HelpHTMLUtils.getFirstSentenceInParagraph(HelpHTMLUtils.getFirstParagraph(html.trim()));
    }

    private static String getFirstSentenceInParagraph(String paragraph) {
        int i = 0;
        while (i < paragraph.length()) {
            int idx = paragraph.indexOf(46, i);
            if (idx != -1) {
                i = idx + 1;
                if (i < paragraph.length()) {
                    char next = paragraph.charAt(i);
                    if (!Character.isWhitespace(next)) continue;
                    return paragraph.substring(0, i);
                }
                i = paragraph.length();
                continue;
            }
            i = paragraph.length();
        }
        return paragraph;
    }

    private static String getFirstParagraph(String trimmedHTML) {
        if (trimmedHTML.startsWith(PARA_BEGIN)) {
            int idx = trimmedHTML.indexOf(PARA_END);
            if (idx != -1) {
                return trimmedHTML.substring(PARA_BEGIN.length(), idx);
            }
            return trimmedHTML.substring(PARA_BEGIN.length());
        }
        int idx = trimmedHTML.indexOf(PARA_BEGIN);
        if (idx != -1) {
            return trimmedHTML.substring(0, idx);
        }
        return trimmedHTML;
    }
}

