/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.yaml.PagePropertyDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PagePropertyLegalValueDefImpl;

class HealthStateLegalValueDefImpl
extends PagePropertyLegalValueDefImpl {
    private LocalizableString label = this.findLabel();

    public HealthStateLegalValueDefImpl(PagePropertyDefImpl pagePropertyDefImpl, String value) {
        super(pagePropertyDefImpl, value);
    }

    private LocalizableString findLabel() {
        String val = this.getValueAsString();
        if ("ok".equals(val)) {
            return LocalizedConstants.HEALTH_STATE_OK;
        }
        if ("warn".equals(val)) {
            return LocalizedConstants.HEALTH_STATE_WARN;
        }
        if ("critical".equals(val)) {
            return LocalizedConstants.HEALTH_STATE_CRITICAL;
        }
        if ("failed".equals(val)) {
            return LocalizedConstants.HEALTH_STATE_FAILED;
        }
        if ("overloaded".equals(val)) {
            return LocalizedConstants.HEALTH_STATE_OVERLOADED;
        }
        if ("unknown".equals(val)) {
            return LocalizedConstants.HEALTH_STATE_UNKNOWN;
        }
        throw new AssertionError((Object)("Unknown health state: " + val));
    }

    @Override
    public LocalizableString getLabel() {
        return this.label;
    }

    @Override
    boolean isOmit() {
        return false;
    }

    public String toString() {
        return "HealthStateLegalValueDefImpl<" + this.getValueAsString() + "," + String.valueOf(this.getLabel()) + ">";
    }
}

