/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.Collections;
import java.util.List;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.GroupNavTreeNodeDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.NavTreeNodeDef;
import weblogic.remoteconsole.common.repodef.schema.NavTreeNodeDefSource;
import weblogic.remoteconsole.common.repodef.yaml.NavTreeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.NavTreeNodeDefImpl;

class GroupNavTreeNodeDefImpl
extends NavTreeNodeDefImpl
implements GroupNavTreeNodeDef {
    private List<NavTreeNodeDefImpl> contentDefImpls;
    private List<NavTreeNodeDef> contentDefs;
    private LocalizableString label;

    GroupNavTreeNodeDefImpl(NavTreeDefImpl navTreeDefImpl, NavTreeNodeDefSource source, GroupNavTreeNodeDefImpl groupNodeDefImpl) {
        super(navTreeDefImpl, source, groupNodeDefImpl);
        if (StringUtils.isEmpty((String)source.getLabel())) {
            throw new AssertionError((Object)("Group nav tree node does not specify label: " + String.valueOf(navTreeDefImpl.getTypeDef())));
        }
        if (StringUtils.notEmpty((String)source.getChild())) {
            throw new AssertionError((Object)("Group nav tree node specifies child: " + source.getChild() + " " + String.valueOf(navTreeDefImpl.getTypeDef())));
        }
        this.label = new LocalizableString(this.getLocalizationKey("label"), this.getNodeName());
        this.contentDefImpls = this.getNavTreeDefImpl().createNavTreeNodeDefImpls(source.getContents(), this);
        this.contentDefs = Collections.unmodifiableList(this.getContentDefImpls());
    }

    List<NavTreeNodeDefImpl> getContentDefImpls() {
        return this.contentDefImpls;
    }

    @Override
    public List<NavTreeNodeDef> getContentDefs() {
        return this.contentDefs;
    }

    @Override
    public LocalizableString getLabel() {
        return this.label;
    }

    @Override
    public String getNodeName() {
        return this.getSource().getLabel();
    }
}

