/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.Collections;
import java.util.List;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.FormDef;
import weblogic.remoteconsole.common.repodef.FormSectionDef;
import weblogic.remoteconsole.common.repodef.FormSectionUsedIfDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.schema.FormSectionDefSource;
import weblogic.remoteconsole.common.repodef.schema.UsedIfDefSource;
import weblogic.remoteconsole.common.repodef.yaml.FormDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.FormSectionUsedIfDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PagePropertyDefImpl;

public class FormSectionDefImpl
implements FormSectionDef {
    private FormDefImpl formDefImpl;
    private FormSectionDefSource source;
    private LocalizableString title;
    private LocalizableString introductionHTML;
    private List<PagePropertyDefImpl> propertyDefImpls;
    private List<PagePropertyDef> propertyDefs;
    private List<FormSectionDefImpl> sectionDefImpls;
    private List<FormSectionDef> sectionDefs;
    private FormSectionUsedIfDefImpl usedIfDefImpl;

    FormSectionDefImpl(FormDefImpl formDefImpl, FormSectionDefSource source) {
        this.formDefImpl = formDefImpl;
        this.source = source;
        String englishTitle = source.getTitle();
        String name = source.getName();
        if (StringUtils.isEmpty((String)name)) {
            name = englishTitle;
        }
        this.title = new LocalizableString(this.getLocalizationKey(name, "title"), englishTitle);
        this.introductionHTML = new LocalizableString(this.getLocalizationKey(name, "introductionHTML"), source.getIntroductionHTML());
        this.propertyDefImpls = this.getFormDefImpl().createPropertyDefImpls(source.getProperties());
        this.sectionDefImpls = this.getFormDefImpl().createSectionDefImpls(source.getSections());
        this.propertyDefs = Collections.unmodifiableList(this.getPropertyDefImpls());
        this.sectionDefs = Collections.unmodifiableList(this.getSectionDefImpls());
    }

    void createUsedIfDefImpl() {
        UsedIfDefSource usedIfSource = this.source.getUsedIf();
        if (usedIfSource != null) {
            this.usedIfDefImpl = new FormSectionUsedIfDefImpl(this, usedIfSource);
        }
    }

    FormDefImpl getFormDefImpl() {
        return this.formDefImpl;
    }

    @Override
    public FormDef getFormDef() {
        return this.getFormDefImpl();
    }

    @Override
    public LocalizableString getTitle() {
        return this.title;
    }

    @Override
    public LocalizableString getIntroductionHTML() {
        return this.introductionHTML;
    }

    FormSectionUsedIfDefImpl getUsedIfDefImpl() {
        return this.usedIfDefImpl;
    }

    @Override
    public FormSectionUsedIfDef getUsedIfDef() {
        return this.getUsedIfDefImpl();
    }

    List<PagePropertyDefImpl> getPropertyDefImpls() {
        return this.propertyDefImpls;
    }

    @Override
    public List<PagePropertyDef> getPropertyDefs() {
        return this.propertyDefs;
    }

    List<FormSectionDefImpl> getSectionDefImpls() {
        return this.sectionDefImpls;
    }

    @Override
    public List<FormSectionDef> getSectionDefs() {
        return this.sectionDefs;
    }

    private String getLocalizationKey(String name, String category) {
        return "sections." + name + "." + category;
    }

    public String toString() {
        return String.valueOf(this.getFormDefImpl()) + " FormSectionDefImpl<" + String.valueOf(this.getTitle()) + ">";
    }
}

