/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import weblogic.remoteconsole.common.repodef.FormDef;
import weblogic.remoteconsole.common.repodef.FormSectionDef;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.schema.FormDefSource;
import weblogic.remoteconsole.common.repodef.schema.FormSectionDefSource;
import weblogic.remoteconsole.common.repodef.yaml.FormSectionDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PageDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PagePropertyDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PageRepoDefImpl;

public abstract class FormDefImpl
extends PageDefImpl
implements FormDef {
    private List<PagePropertyDefImpl> propertyDefImpls;
    private List<PagePropertyDef> propertyDefs;
    private List<FormSectionDefImpl> allSectionDefImpls = new ArrayList<FormSectionDefImpl>();
    private List<FormSectionDef> allSectionDefs;
    private List<FormSectionDefImpl> sectionDefImpls;
    private List<FormSectionDef> sectionDefs;

    protected FormDefImpl(PageRepoDefImpl pageRepoDefImpl, PagePath pagePath, FormDefSource source, String pageKey) {
        super(pageRepoDefImpl, pagePath, source, pageKey);
        this.propertyDefImpls = this.createPropertyDefImpls(source.getProperties());
        this.sectionDefImpls = this.createSectionDefImpls(source.getSections());
        this.propertyDefs = Collections.unmodifiableList(this.getPropertyDefImpls());
        this.sectionDefs = Collections.unmodifiableList(this.getSectionDefImpls());
    }

    List<FormSectionDefImpl> getAllSectionDefImpls() {
        return this.allSectionDefImpls;
    }

    @Override
    public List<FormSectionDef> getAllSectionDefs() {
        return this.allSectionDefs;
    }

    List<PagePropertyDefImpl> getPropertyDefImpls() {
        return this.propertyDefImpls;
    }

    @Override
    public List<PagePropertyDef> getPropertyDefs() {
        return this.propertyDefs;
    }

    List<FormSectionDefImpl> getSectionDefImpls() {
        return this.sectionDefImpls;
    }

    @Override
    public List<FormSectionDef> getSectionDefs() {
        return this.sectionDefs;
    }

    @Override
    protected void createUsedIfDefImpls() {
        super.createUsedIfDefImpls();
        for (FormSectionDefImpl sectionDefImpl : this.allSectionDefImpls) {
            sectionDefImpl.createUsedIfDefImpl();
        }
    }

    protected List<FormSectionDefImpl> createSectionDefImpls(List<FormSectionDefSource> sectionSources) {
        ArrayList<FormSectionDefImpl> rtn = new ArrayList<FormSectionDefImpl>();
        for (FormSectionDefSource sectionSource : sectionSources) {
            rtn.add(new FormSectionDefImpl(this, sectionSource));
        }
        this.allSectionDefImpls.addAll(rtn);
        this.allSectionDefs = Collections.unmodifiableList(this.allSectionDefImpls);
        return rtn;
    }
}

