/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import weblogic.console.schema.beaninfo.BeanValueDefSource;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.BeanValueDef;
import weblogic.remoteconsole.common.repodef.schema.BeanValueDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanTypeDefImpl;
import weblogic.remoteconsole.server.repo.ArrayValue;
import weblogic.remoteconsole.server.repo.BooleanValue;
import weblogic.remoteconsole.server.repo.DoubleValue;
import weblogic.remoteconsole.server.repo.IntValue;
import weblogic.remoteconsole.server.repo.LongValue;
import weblogic.remoteconsole.server.repo.NullReference;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.UnknownValue;
import weblogic.remoteconsole.server.repo.Value;

class BeanValueDefImpl
implements BeanValueDef {
    private static final Logger LOGGER = Logger.getLogger(BeanValueDefImpl.class.getName());
    BaseBeanTypeDefImpl typeDefImpl;
    private BeanValueDefSource source;
    private BeanValueDefCustomizerSource customizerSource;
    private static Map<String, BeanValueDef.ValueKind> javaTypeToValueKind = new HashMap<String, BeanValueDef.ValueKind>();

    BeanValueDefImpl(BaseBeanTypeDefImpl typeDefImpl, BeanValueDefSource source, BeanValueDefCustomizerSource customizerSource) {
        this.typeDefImpl = typeDefImpl;
        this.source = source;
        this.customizerSource = customizerSource;
    }

    boolean isSupportedType() {
        return this.getValueKindOrNull() != null;
    }

    @Override
    public BeanValueDef.ValueKind getValueKind() {
        BeanValueDef.ValueKind kind = this.getValueKindOrNull();
        if (kind != null) {
            return kind;
        }
        throw this.configurationError("unsupported value type: " + this.getJavaType());
    }

    BeanValueDef.ValueKind getValueKindOrNull() {
        if (this.source.isReference()) {
            return BeanValueDef.ValueKind.REFERENCE;
        }
        if (this.isDateAsLong()) {
            return BeanValueDef.ValueKind.DATE;
        }
        String javaType = this.getJavaType();
        BeanValueDef.ValueKind kind = javaTypeToValueKind.get(javaType);
        if (BeanValueDef.ValueKind.STRING == kind && this.source.isSecret()) {
            return BeanValueDef.ValueKind.SECRET;
        }
        return kind;
    }

    @Override
    public boolean isArray() {
        return this.source.isArray();
    }

    @Override
    public boolean isOrdered() {
        if (!this.isArray()) {
            return false;
        }
        return this.customizerSource.isOrdered();
    }

    @Override
    public boolean isMultiLineString() {
        if (this.customizerSource.isMultiLineString()) {
            BeanValueDef.ValueKind kind = javaTypeToValueKind.get(this.getJavaType());
            if (BeanValueDef.ValueKind.STRING == kind && !this.isArray()) {
                return true;
            }
            throw this.configurationError("specified multiLineString on a property that is not a string");
        }
        return false;
    }

    @Override
    public boolean isDynamicEnum() {
        if (this.customizerSource.isDynamicEnum()) {
            BeanValueDef.ValueKind kind = javaTypeToValueKind.get(this.getJavaType());
            if (BeanValueDef.ValueKind.STRING == kind && !this.isArray()) {
                return true;
            }
            throw this.configurationError("specified dynamicEnum on a property that is not a string");
        }
        return false;
    }

    @Override
    public BeanTypeDef getReferenceTypeDef() {
        if (this.isReference()) {
            return this.typeDefImpl.getBeanRepoDef().getTypeDef(StringUtils.getLeafClassName((String)this.getJavaType()));
        }
        return null;
    }

    @Override
    public boolean isReferenceAsReferences() {
        if (this.customizerSource.isReferenceAsReferences()) {
            if (this.isReference() && this.isArray()) {
                return true;
            }
            throw this.configurationError("specified referenceAsReferences on a property that is an array of references");
        }
        return false;
    }

    @Override
    public boolean isDateAsLong() {
        if (this.customizerSource.isDateAsLong()) {
            BeanValueDef.ValueKind kind = javaTypeToValueKind.get(this.getJavaType());
            if (BeanValueDef.ValueKind.LONG == kind && !this.isArray()) {
                return true;
            }
            throw this.configurationError("specified dateAsLong on a property that is not a long");
        }
        return false;
    }

    protected Value getDefaultValueForType() {
        if (this.isReferenceAsReferences()) {
            return NullReference.INSTANCE;
        }
        if (this.isArray()) {
            return new ArrayValue(new ArrayList<Value>());
        }
        if (this.isDateAsLong()) {
            return UnknownValue.INSTANCE;
        }
        if (this.isString()) {
            return new StringValue(null);
        }
        if (this.isBoolean()) {
            return new BooleanValue(false);
        }
        if (this.isInt()) {
            return new IntValue(0);
        }
        if (this.isLong()) {
            return new LongValue(0L);
        }
        if (this.isDouble()) {
            return new DoubleValue(0.0);
        }
        if (this.isReference()) {
            return NullReference.INSTANCE;
        }
        return UnknownValue.INSTANCE;
    }

    private String getJavaType() {
        return this.source.getType();
    }

    protected Error configurationError(String problem) {
        String msg = "Configuration Error: " + String.valueOf(this) + " : " + problem;
        LOGGER.severe(msg);
        return new AssertionError((Object)msg);
    }

    static {
        javaTypeToValueKind.put("java.lang.String", BeanValueDef.ValueKind.STRING);
        javaTypeToValueKind.put("int", BeanValueDef.ValueKind.INT);
        javaTypeToValueKind.put("java.lang.Integer", BeanValueDef.ValueKind.INT);
        javaTypeToValueKind.put("long", BeanValueDef.ValueKind.LONG);
        javaTypeToValueKind.put("java.lang.Long", BeanValueDef.ValueKind.LONG);
        javaTypeToValueKind.put("double", BeanValueDef.ValueKind.DOUBLE);
        javaTypeToValueKind.put("java.lang.Double", BeanValueDef.ValueKind.DOUBLE);
        javaTypeToValueKind.put("boolean", BeanValueDef.ValueKind.BOOLEAN);
        javaTypeToValueKind.put("java.lang.Boolean", BeanValueDef.ValueKind.BOOLEAN);
        javaTypeToValueKind.put("java.util.Date", BeanValueDef.ValueKind.DATE);
        javaTypeToValueKind.put("java.util.Properties", BeanValueDef.ValueKind.PROPERTIES);
        javaTypeToValueKind.put("java.lang.Throwable", BeanValueDef.ValueKind.THROWABLE);
        javaTypeToValueKind.put("java.lang.Exception", BeanValueDef.ValueKind.THROWABLE);
        javaTypeToValueKind.put("java.lang.RuntimeException", BeanValueDef.ValueKind.THROWABLE);
        javaTypeToValueKind.put("java.io.InputStream", BeanValueDef.ValueKind.FILE_CONTENTS);
        javaTypeToValueKind.put("weblogic.health.HealthState", BeanValueDef.ValueKind.HEALTH_STATE);
        javaTypeToValueKind.put("EntitleNetExpression", BeanValueDef.ValueKind.ENTITLE_NET_EXPRESSION);
        javaTypeToValueKind.put("void", BeanValueDef.ValueKind.VOID);
    }
}

