/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import weblogic.console.schema.beaninfo.BeanTypeDefSource;
import weblogic.remoteconsole.common.repodef.BeanRepoDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.schema.PseudoBeanTypeDefSource;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.NormalBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.PseudoBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.RootBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.UsageTracker;
import weblogic.remoteconsole.common.repodef.yaml.YamlReader;
import weblogic.remoteconsole.common.utils.WebLogicMBeansVersion;

public abstract class BeanRepoDefImpl
implements BeanRepoDef {
    private BaseBeanTypeDefImpl rootTypeDefImpl;
    private WebLogicMBeansVersion mbeansVersion;
    private static final Logger LOGGER = Logger.getLogger(BeanRepoDefImpl.class.getName());
    private static boolean REPORT_MISSING = Boolean.parseBoolean(System.getenv("ReportMissing"));
    private Map<String, Optional<BaseBeanTypeDefImpl>> typeNameToTypeDefImplMap = new ConcurrentHashMap<String, Optional<BaseBeanTypeDefImpl>>();

    protected BeanRepoDefImpl(WebLogicMBeansVersion mbeansVersion) {
        this.mbeansVersion = mbeansVersion;
    }

    protected abstract boolean isEditable();

    protected abstract String[] getRootChildNames();

    protected void createRootTypeDefImpl() {
        this.rootTypeDefImpl = new RootBeanTypeDefImpl(this, this.getRootChildNames());
        this.getTypeNameToTypeDefImplMap().put(this.getRootTypeDefImpl().getTypeName(), Optional.ofNullable(this.getRootTypeDefImpl()));
    }

    private Map<String, Optional<BaseBeanTypeDefImpl>> getTypeNameToTypeDefImplMap() {
        return this.typeNameToTypeDefImplMap;
    }

    BaseBeanTypeDefImpl getRootTypeDefImpl() {
        return this.rootTypeDefImpl;
    }

    @Override
    public BeanTypeDef getRootTypeDef() {
        return this.getRootTypeDefImpl();
    }

    @Override
    public BeanTypeDef getTypeDef(String typeName) {
        return this.getTypeDefImpl(typeName);
    }

    BaseBeanTypeDefImpl getTypeDefImpl(String typeName) {
        String usageId = "type " + typeName;
        Optional<BaseBeanTypeDefImpl> opt = this.getTypeNameToTypeDefImplMap().get(typeName);
        if (opt == null) {
            opt = Optional.ofNullable(this.createTypeDefImpl(typeName));
            this.getTypeNameToTypeDefImplMap().put(typeName, opt);
        }
        if (opt.isPresent()) {
            UsageTracker.used(usageId);
            return opt.get();
        }
        UsageTracker.notFound(usageId);
        return null;
    }

    private BaseBeanTypeDefImpl createTypeDefImpl(String typeName) {
        PseudoBeanTypeDefSource pseudoTypeDefSource = this.getYamlReader().getPseudoBeanTypeDefSource(this, typeName);
        if (pseudoTypeDefSource != null) {
            return this.createPseudoTypeDefImpl(pseudoTypeDefSource);
        }
        BeanTypeDefSource typeDefSource = this.getYamlReader().getBeanTypeDefSource(this, typeName);
        if (typeDefSource != null) {
            return this.createNormalTypeDefImpl(typeDefSource);
        }
        return null;
    }

    private NormalBeanTypeDefImpl createNormalTypeDefImpl(BeanTypeDefSource typeDefSource) {
        LOGGER.finest("createNormalType " + typeDefSource.getName());
        return this.createNormalBeanTypeDefImpl(typeDefSource);
    }

    private PseudoBeanTypeDefImpl createPseudoTypeDefImpl(PseudoBeanTypeDefSource pseudoBeanTypeDefSource) {
        LOGGER.finest("createPseudoTypeDef " + pseudoBeanTypeDefSource.getName() + " " + pseudoBeanTypeDefSource.getBaseType());
        return this.createPseudoBeanTypeDefImpl(pseudoBeanTypeDefSource);
    }

    protected NormalBeanTypeDefImpl createNormalBeanTypeDefImpl(BeanTypeDefSource typeDefSource) {
        return new NormalBeanTypeDefImpl(this, typeDefSource);
    }

    protected PseudoBeanTypeDefImpl createPseudoBeanTypeDefImpl(PseudoBeanTypeDefSource pseudoTypeDefSource) {
        return new PseudoBeanTypeDefImpl(this, pseudoTypeDefSource);
    }

    @Override
    public boolean isAccessAllowed(Set<String> rolesAllowed) {
        return this.mbeansVersion.isAccessAllowed(rolesAllowed);
    }

    @Override
    public boolean supportsCapabilities(List<String> capabilities) {
        if (this.mbeansVersion.getCapabilities().contains("All")) {
            return true;
        }
        for (String capability : capabilities) {
            if (this.mbeansVersion.getCapabilities().contains(capability)) continue;
            return false;
        }
        return true;
    }

    protected abstract YamlReader getYamlReader();

    protected WebLogicMBeansVersion getMBeansVersion() {
        return this.mbeansVersion;
    }

    String getLocalizationKey(String key) {
        return key;
    }
}

