/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.Set;
import weblogic.console.schema.beaninfo.BeanPropertyDefSource;
import weblogic.console.schema.beaninfo.BeanTypeDefSource;
import weblogic.console.schema.beaninfo.BeanValueDefSource;
import weblogic.console.schema.beaninfo.DefaultValueDefSource;
import weblogic.console.schema.beaninfo.ValueDefSource;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.GetPropertyOptionsCustomizerDef;
import weblogic.remoteconsole.common.repodef.GetPropertyValueCustomizerDef;
import weblogic.remoteconsole.common.repodef.schema.BeanPropertyDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanValueDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.GetPropertyOptionsCustomizerDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.GetPropertyValueCustomizerDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.RoleUtils;
import weblogic.remoteconsole.common.repodef.yaml.ValueUtils;
import weblogic.remoteconsole.server.repo.NullReference;
import weblogic.remoteconsole.server.repo.UnknownValue;
import weblogic.remoteconsole.server.repo.Value;

public class BeanPropertyDefImpl
extends BeanValueDefImpl
implements BeanPropertyDef {
    private BaseBeanTypeDefImpl typeDefImpl;
    private Path parentPath;
    private BeanPropertyDefSource source;
    private BeanPropertyDefCustomizerSource customizerSource;
    private GetPropertyOptionsCustomizerDefImpl getOptionsCustomizerDefImpl;
    private GetPropertyValueCustomizerDefImpl getValueCustomizerDefImpl;
    private boolean initializedRoles = false;
    private Set<String> getRoles;
    private Set<String> setRoles;

    public BeanPropertyDefImpl(BaseBeanTypeDefImpl typeDefImpl, Path parentPath, BeanPropertyDefSource source, BeanPropertyDefCustomizerSource customizerSource) {
        super(typeDefImpl, (BeanValueDefSource)source, customizerSource);
        this.typeDefImpl = typeDefImpl;
        this.parentPath = parentPath.clone();
        this.source = source;
        this.customizerSource = customizerSource;
    }

    protected BeanPropertyDefImpl(BeanPropertyDefImpl toClone, BeanPropertyDefCustomizerSource customizerSource) {
        this(toClone.getTypeDefImpl(), toClone.getParentPath(), toClone.getSource(), customizerSource);
    }

    public BeanPropertyDefImpl clone(BeanPropertyDefCustomizerSource customizerSource) {
        return new BeanPropertyDefImpl(this, customizerSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRoles() {
        if (!this.initializedRoles) {
            BeanPropertyDefImpl beanPropertyDefImpl = this;
            synchronized (beanPropertyDefImpl) {
                if (!this.initializedRoles) {
                    BaseBeanTypeDefImpl immediateType = this.getParentPath().isEmpty() ? this.getTypeDefImpl() : this.getTypeDefImpl().getChildDefImpl(this.getParentPath()).getChildTypeDefImpl();
                    BeanTypeDefSource typeSource = immediateType.asYamlBasedBeanTypeDefImpl().getTypeDefSource();
                    BeanPropertyDefSource propertySource = this.getSource();
                    this.getRoles = RoleUtils.computeGetRoles(typeSource, propertySource);
                    this.setRoles = RoleUtils.computeSetRoles(typeSource, propertySource);
                    this.initializedRoles = true;
                }
            }
        }
    }

    BaseBeanTypeDefImpl getTypeDefImpl() {
        return this.typeDefImpl;
    }

    @Override
    public BeanTypeDef getTypeDef() {
        return this.getTypeDefImpl();
    }

    @Override
    public String getPropertyName() {
        return this.getSource().getName();
    }

    @Override
    public String getFormFieldName() {
        String formName = this.getCustomizerSource().getFormName();
        if (StringUtils.isEmpty((String)formName)) {
            return this.getPropertyPath().getUnderscoreSeparatedPath();
        }
        return new Path(formName).getUnderscoreSeparatedPath();
    }

    @Override
    public String getOnlinePropertyName() {
        String onlineName = this.getCustomizerSource().getOnlineName();
        if (StringUtils.isEmpty((String)onlineName)) {
            return StringUtils.getRestName((String)this.getPropertyName());
        }
        return onlineName;
    }

    @Override
    public String getOfflinePropertyName() {
        Object offlineName = this.getCustomizerSource().getOfflineName();
        if (StringUtils.isEmpty((String)offlineName)) {
            offlineName = this.getSource().isEncrypted() ? this.getPropertyName() + "Encrypted" : (this.isArray() ? StringUtils.getSingular((String)this.getPropertyName()) : this.getPropertyName());
        }
        return offlineName;
    }

    @Override
    public Path getParentPath() {
        return this.parentPath;
    }

    void setKey(boolean val) {
        this.getSource().setKey(val);
    }

    @Override
    public boolean isKey() {
        return this.getSource().isKey();
    }

    @Override
    public boolean isCreateWritable() {
        if (!this.getTypeDefImpl().isEditable()) {
            return false;
        }
        if (!this.getTypeDefImpl().getBeanRepoDefImpl().isAccessAllowed(this.getSetRoles())) {
            return false;
        }
        BeanPropertyDefCustomizerSource.Writable writable = this.getCustomizerSource().getWritable();
        if (BeanPropertyDefCustomizerSource.Writable.always == writable || BeanPropertyDefCustomizerSource.Writable.createOnly == writable) {
            return true;
        }
        if (BeanPropertyDefCustomizerSource.Writable.never == writable) {
            return false;
        }
        return this.getSource().isWritable();
    }

    @Override
    public boolean isUpdateWritable() {
        if (!this.getTypeDefImpl().isEditable()) {
            return false;
        }
        if (!this.getTypeDefImpl().getBeanRepoDefImpl().isAccessAllowed(this.getSetRoles())) {
            return false;
        }
        BeanPropertyDefCustomizerSource.Writable writable = this.getCustomizerSource().getWritable();
        if (BeanPropertyDefCustomizerSource.Writable.always == writable) {
            return true;
        }
        if (BeanPropertyDefCustomizerSource.Writable.never == writable || BeanPropertyDefCustomizerSource.Writable.createOnly == writable) {
            return false;
        }
        return this.getSource().isWritable();
    }

    @Override
    public boolean isRequired() {
        if (this.getCustomizerSource().isRequired() || this.getCustomizerSource().isRequiredSpecifiedInYaml()) {
            return this.getCustomizerSource().isRequired();
        }
        BeanPropertyDef keyPropertyDef = this.getTypeDef().getKeyPropertyDef();
        return keyPropertyDef != null && this.getPropertyPath().equals((Object)keyPropertyDef.getPropertyPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPropertyValueCustomizerDef getGetValueCustomizerDef() {
        if (StringUtils.isEmpty((String)this.getCustomizerSource().getGetMethod())) {
            return null;
        }
        if (this.getValueCustomizerDefImpl == null) {
            BeanPropertyDefImpl beanPropertyDefImpl = this;
            synchronized (beanPropertyDefImpl) {
                if (this.getValueCustomizerDefImpl == null) {
                    this.getValueCustomizerDefImpl = new GetPropertyValueCustomizerDefImpl(this);
                }
            }
        }
        return this.getValueCustomizerDefImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPropertyOptionsCustomizerDef getGetOptionsCustomizerDef() {
        if (StringUtils.isEmpty((String)this.getCustomizerSource().getOptionsMethod())) {
            return null;
        }
        if (this.getOptionsCustomizerDefImpl == null) {
            BeanPropertyDefImpl beanPropertyDefImpl = this;
            synchronized (beanPropertyDefImpl) {
                if (this.getOptionsCustomizerDefImpl == null) {
                    this.getOptionsCustomizerDefImpl = new GetPropertyOptionsCustomizerDefImpl(this);
                }
            }
        }
        return this.getOptionsCustomizerDefImpl;
    }

    @Override
    public boolean isRestartNeeded() {
        return this.getSource().isRestartNeeded();
    }

    @Override
    public boolean isSupportsModelTokens() {
        return false;
    }

    @Override
    public boolean isSupportsUnresolvedReferences() {
        return false;
    }

    @Override
    public Value getSecureDefaultValue() {
        ValueDefSource valSource;
        DefaultValueDefSource dfltSource = this.getSource().getDefaultValue();
        if (dfltSource != null && !dfltSource.isDerivedDefault() && (valSource = dfltSource.getSecureModeValue()) != null) {
            return this.fixDefaultValue(ValueUtils.createValue(valSource.getValue()));
        }
        return UnknownValue.INSTANCE;
    }

    @Override
    public Value getProductionDefaultValue() {
        ValueDefSource valSource;
        DefaultValueDefSource dfltSource = this.getSource().getDefaultValue();
        if (dfltSource != null && !dfltSource.isDerivedDefault() && (valSource = dfltSource.getProductionModeValue()) != null) {
            return this.fixDefaultValue(ValueUtils.createValue(valSource.getValue()));
        }
        return UnknownValue.INSTANCE;
    }

    @Override
    public Value getStandardDefaultValue() {
        DefaultValueDefSource dfltSource = this.getSource().getDefaultValue();
        if (dfltSource == null || dfltSource.isDerivedDefault()) {
            return UnknownValue.INSTANCE;
        }
        ValueDefSource valSource = dfltSource.getValue();
        if (valSource != null) {
            return this.fixDefaultValue(ValueUtils.createValue(valSource.getValue()));
        }
        return this.getDefaultValueForType();
    }

    private Value fixDefaultValue(Value defaultValue) {
        if (this.isReferenceAsReferences()) {
            return NullReference.INSTANCE;
        }
        if (this.isDateAsLong()) {
            return UnknownValue.INSTANCE;
        }
        if (defaultValue == null) {
            return UnknownValue.INSTANCE;
        }
        return defaultValue;
    }

    @Override
    public Set<String> getGetRoles() {
        this.initializeRoles();
        return this.getRoles;
    }

    @Override
    public Set<String> getSetRoles() {
        this.initializeRoles();
        return this.setRoles;
    }

    public BeanPropertyDefSource getSource() {
        return this.source;
    }

    protected BeanPropertyDefCustomizerSource getCustomizerSource() {
        return this.customizerSource;
    }

    String getLocalizationKey(String key) {
        return this.getTypeDefImpl().getLocalizationKey("properties." + this.getPropertyPath().getDotSeparatedPath() + "." + key);
    }

    public String toString() {
        return String.valueOf(this.getTypeDef()) + ", property=" + String.valueOf(this.getPropertyPath());
    }
}

