/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.List;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanChildNavTreeNodeDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.schema.NavTreeNodeDefSource;
import weblogic.remoteconsole.common.repodef.yaml.GroupNavTreeNodeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.NavTreeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.NavTreeNodeDefImpl;

class BeanChildNavTreeNodeDefImpl
extends NavTreeNodeDefImpl
implements BeanChildNavTreeNodeDef {
    private List<BeanChildDef> childDefs = new ArrayList<BeanChildDef>();
    private String nodeName;
    private LocalizableString label;
    private boolean exists = true;

    static BeanChildNavTreeNodeDefImpl newNode(NavTreeDefImpl navTreeDefImpl, NavTreeNodeDefSource source, GroupNavTreeNodeDefImpl groupNodeDefImpl) {
        BeanChildNavTreeNodeDefImpl node = new BeanChildNavTreeNodeDefImpl(navTreeDefImpl, source, groupNodeDefImpl);
        if (!node.exists) {
            return null;
        }
        return node;
    }

    BeanChildNavTreeNodeDefImpl(NavTreeDefImpl navTreeDefImpl, NavTreeNodeDefSource source, GroupNavTreeNodeDefImpl groupNodeDefImpl) {
        super(navTreeDefImpl, source, groupNodeDefImpl);
        BeanTypeDef typeDef = this.getNavTreeDef().getTypeDef();
        Path childPath = new Path(source.getChild());
        for (String childName : childPath.getComponents()) {
            BeanChildDef childDef = typeDef.getChildDef(new Path(childName));
            if (childDef == null) {
                this.exists = false;
                return;
            }
            typeDef = childDef.getChildTypeDef();
            this.getChildDefs().add(childDef);
        }
        if (this.getChildDefs().isEmpty()) {
            throw new AssertionError((Object)("Empty childPath " + String.valueOf(childPath) + " for " + String.valueOf(navTreeDefImpl.getTypeDef())));
        }
        if (!source.getContents().isEmpty()) {
            throw new AssertionError((Object)("Source has contents: " + String.valueOf(childPath) + " for " + String.valueOf(navTreeDefImpl.getTypeDef())));
        }
        if (StringUtils.isEmpty((String)this.getSource().getLabel())) {
            BeanChildDef childDef = this.getLastChildDef();
            this.nodeName = childDef.getChildName();
            this.label = childDef.getLabel();
        } else {
            this.nodeName = this.getSource().getLabel();
            this.label = new LocalizableString(this.getLocalizationKey("label"), this.getNodeName());
        }
    }

    @Override
    public List<BeanChildDef> getChildDefs() {
        return this.childDefs;
    }

    @Override
    public boolean isForceNotExpandable() {
        return this.getSource().isForceNotExpandable();
    }

    @Override
    public LocalizableString getLabel() {
        return this.label;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }
}

