/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.Set;
import java.util.logging.Logger;
import weblogic.console.schema.beaninfo.BeanPropertyDefSource;
import weblogic.console.schema.beaninfo.BeanTypeDefSource;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.schema.BeanChildDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanChildDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.RoleUtils;

public class BeanChildDefImpl
extends BaseBeanChildDefImpl {
    private Path parentPath;
    private BeanPropertyDefSource source;
    private BeanChildDefCustomizerSource customizerSource;
    private LocalizableString label;
    private LocalizableString singularLabel;
    private boolean initializedRoles = false;
    private Set<String> getRoles;
    private Set<String> setRoles;
    private Set<String> createRoles;
    private Set<String> deleteRoles;
    private static final Logger LOGGER = Logger.getLogger(BeanChildDefImpl.class.getName());

    public BeanChildDefImpl(BaseBeanTypeDefImpl typeDefImpl, Path parentPath, BeanPropertyDefSource source, BeanChildDefCustomizerSource customizerSource) {
        super(typeDefImpl);
        this.source = source;
        this.parentPath = parentPath.clone();
        this.customizerSource = customizerSource;
        this.initializeLabel();
        this.initializeSingularLabel();
        LOGGER.finest("BeanChildDefImpl constructor " + this.getTypeDef().getTypeName() + " " + String.valueOf(this.getChildPath()));
    }

    private void initializeLabel() {
        String englishLabel = this.getCustomizerSource().getLabel();
        if (StringUtils.isEmpty((String)englishLabel)) {
            englishLabel = StringUtils.camelCaseToUpperCaseWords((String)this.getChildName());
        }
        this.label = this.getCustomizerSource().isUseUnlocalizedNameAsLabel() ? new LocalizableString(englishLabel) : new LocalizableString(this.getLocalizationKey("label"), englishLabel);
    }

    private void initializeSingularLabel() {
        if (!this.isCollection()) {
            this.singularLabel = this.label;
        } else {
            String englishSingularLabel = this.getCustomizerSource().getSingularLabel();
            if (StringUtils.isEmpty((String)englishSingularLabel)) {
                englishSingularLabel = StringUtils.getSingular((String)this.label.getEnglishText(new Object[0]));
            }
            this.singularLabel = this.getCustomizerSource().isUseUnlocalizedNameAsLabel() ? new LocalizableString(englishSingularLabel) : new LocalizableString(this.getLocalizationKey("singularLabel"), englishSingularLabel);
        }
    }

    void mergeCustomizations(BeanChildDefImpl from) {
        LOGGER.finest("mergeCustomizations " + this.getTypeDef().getTypeName() + " " + String.valueOf(this.getParentPath()) + " " + this.getChildName() + " " + from.getTypeDef().getTypeName() + " " + String.valueOf(from.getParentPath()) + " " + from.getChildName());
        this.mergeCustomizations(from.getCustomizerSource());
    }

    void mergeCustomizations(BeanChildDefCustomizerSource customizerSource) {
        this.getCustomizerSource().merge(customizerSource, new Path());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRoles() {
        if (!this.initializedRoles) {
            BeanChildDefImpl beanChildDefImpl = this;
            synchronized (beanChildDefImpl) {
                if (!this.initializedRoles) {
                    BeanTypeDefSource typeSource = this.getChildTypeDefImpl().asYamlBasedBeanTypeDefImpl().getTypeDefSource();
                    BeanPropertyDefSource propertySource = this.getSource();
                    this.getRoles = RoleUtils.computeGetRoles(typeSource, propertySource);
                    this.setRoles = RoleUtils.computeSetRoles(typeSource, propertySource);
                    this.createRoles = RoleUtils.computeCreateRoles(typeSource, propertySource);
                    this.deleteRoles = RoleUtils.computeDeleteRoles(typeSource, propertySource);
                    this.initializedRoles = true;
                }
            }
        }
    }

    @Override
    public String getChildName() {
        return this.getSource().getName();
    }

    @Override
    public String getOnlineChildName() {
        String onlineName = this.getCustomizerSource().getOnlineName();
        if (StringUtils.isEmpty((String)onlineName)) {
            return StringUtils.getRestName((String)this.getChildName());
        }
        return onlineName;
    }

    @Override
    public String getOfflineChildName() {
        String offlineName = this.getCustomizerSource().getOfflineName();
        if (StringUtils.isEmpty((String)offlineName)) {
            offlineName = this.isCollection() ? StringUtils.getSingular((String)this.getChildName()) : this.getChildName();
        }
        return offlineName;
    }

    @Override
    BaseBeanTypeDefImpl getChildTypeDefImpl() {
        return this.getTypeDefImpl().getBeanRepoDefImpl().getTypeDefImpl(StringUtils.getLeafClassName((String)this.getSource().getType()));
    }

    @Override
    public Path getParentPath() {
        return this.parentPath;
    }

    @Override
    public boolean isCollection() {
        return this.getSource().isArray();
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isCreatable() {
        if (!this.getTypeDefImpl().getBeanRepoDefImpl().isAccessAllowed(this.getCreateRoles())) {
            return false;
        }
        if (this.getCustomizerSource().isCreatableSpecifiedInYaml()) {
            return this.getCustomizerSource().isCreatable();
        }
        if (!this.isEditable()) {
            return false;
        }
        return this.getSource().isCreatable();
    }

    @Override
    public boolean isDeletable() {
        if (!this.getTypeDefImpl().getBeanRepoDefImpl().isAccessAllowed(this.getDeleteRoles())) {
            return false;
        }
        if (this.getCustomizerSource().isDeletableSpecifiedInYaml()) {
            return this.getCustomizerSource().isDeletable();
        }
        return this.isCreatable();
    }

    @Override
    public boolean isAsyncCreate() {
        return this.getCustomizerSource().isAsyncCreate();
    }

    @Override
    public boolean isAsyncDelete() {
        return this.getCustomizerSource().isAsyncDelete();
    }

    @Override
    public boolean isOptional() {
        if (this.isCollection()) {
            return false;
        }
        if (this.getSource().isCreatable()) {
            return true;
        }
        return this.getCustomizerSource().isNonCreatableOptionalSingleton();
    }

    @Override
    public boolean isEditable() {
        return this.getChildTypeDefImpl().isEditable();
    }

    @Override
    public LocalizableString getLabel() {
        return this.label;
    }

    @Override
    public LocalizableString getSingularLabel() {
        return this.singularLabel;
    }

    @Override
    public boolean isRestartNeeded() {
        return this.getSource().isRestartNeeded();
    }

    @Override
    public boolean isCollapsedInWDT() {
        return this.getCustomizerSource().isCollapsedInWDT();
    }

    @Override
    public Set<String> getGetRoles() {
        this.initializeRoles();
        return this.getRoles;
    }

    @Override
    public Set<String> getSetRoles() {
        this.initializeRoles();
        return this.setRoles;
    }

    @Override
    public Set<String> getCreateRoles() {
        this.initializeRoles();
        return this.createRoles;
    }

    @Override
    public Set<String> getDeleteRoles() {
        this.initializeRoles();
        return this.deleteRoles;
    }

    BeanPropertyDefSource getSource() {
        return this.source;
    }

    BeanChildDefCustomizerSource getCustomizerSource() {
        return this.customizerSource;
    }
}

