/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import weblogic.console.schema.beaninfo.BeanActionDefSource;
import weblogic.console.schema.beaninfo.BeanActionParamDefSource;
import weblogic.console.schema.beaninfo.BeanTypeDefSource;
import weblogic.console.schema.beaninfo.BeanValueDefSource;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanActionDef;
import weblogic.remoteconsole.common.repodef.BeanActionParamDef;
import weblogic.remoteconsole.common.repodef.BeanRepoDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.schema.BeanActionDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.BeanActionParamDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanTypeDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanActionParamDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanValueDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.RoleUtils;

public class BeanActionDefImpl
extends BeanValueDefImpl
implements BeanActionDef {
    private BaseBeanTypeDefImpl typeDefImpl;
    private Path parentPath;
    private BeanActionDefSource source;
    private BeanActionDefCustomizerSource customizerSource;
    private List<BeanActionParamDefImpl> paramDefImpls = new ArrayList<BeanActionParamDefImpl>();
    private List<BeanActionParamDef> paramDefs;
    private boolean initializedRoles = false;
    private Set<String> invokeRoles;

    BeanActionDefImpl(BaseBeanTypeDefImpl typeDefImpl, Path parentPath, BeanActionDefSource source, BeanActionDefCustomizerSource customizerSource) {
        super(typeDefImpl, (BeanValueDefSource)source, customizerSource);
        this.typeDefImpl = typeDefImpl;
        this.parentPath = parentPath.clone();
        this.source = source;
        this.customizerSource = customizerSource;
        this.initializeParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRoles() {
        if (!this.initializedRoles) {
            BeanActionDefImpl beanActionDefImpl = this;
            synchronized (beanActionDefImpl) {
                if (!this.initializedRoles) {
                    BaseBeanTypeDefImpl immediateType = this.getParentPath().isEmpty() ? this.getTypeDefImpl() : this.getTypeDefImpl().getChildDefImpl(this.getParentPath()).getChildTypeDefImpl();
                    BeanTypeDefSource typeSource = immediateType.asYamlBasedBeanTypeDefImpl().getTypeDefSource();
                    BeanActionDefSource actionSource = this.getSource();
                    this.invokeRoles = RoleUtils.computeInvokeRoles(typeSource, actionSource);
                    this.initializedRoles = true;
                }
            }
        }
    }

    private void initializeParams() {
        for (BeanActionParamDefSource paramSource : this.source.getParameters()) {
            this.paramDefImpls.add(new BeanActionParamDefImpl(this, paramSource, this.getParamCustomizer(paramSource)));
        }
        this.paramDefs = Collections.unmodifiableList(this.paramDefImpls);
    }

    private BeanActionParamDefCustomizerSource getParamCustomizer(BeanActionParamDefSource paramSource) {
        for (BeanActionParamDefCustomizerSource customizer : this.customizerSource.getParameters()) {
            if (!paramSource.getName().equals(customizer.getName())) continue;
            return customizer;
        }
        return new BeanActionParamDefCustomizerSource();
    }

    BaseBeanTypeDefImpl getTypeDefImpl() {
        return this.typeDefImpl;
    }

    @Override
    public BeanTypeDef getTypeDef() {
        return this.getTypeDefImpl();
    }

    @Override
    public String getActionName() {
        return this.getSource().getName();
    }

    @Override
    public String getRemoteActionName() {
        String remoteName = this.source.getRemoteName();
        if (StringUtils.isEmpty((String)remoteName)) {
            return this.getActionName();
        }
        return remoteName;
    }

    @Override
    public Path getParentPath() {
        return this.parentPath;
    }

    List<BeanActionParamDefImpl> getParamDefImpls() {
        return this.paramDefImpls;
    }

    public BeanActionParamDefImpl getParamDefImpl(String paramName) {
        return (BeanActionParamDefImpl)this.getParamDef(paramName);
    }

    @Override
    public List<BeanActionParamDef> getParamDefs() {
        return this.paramDefs;
    }

    @Override
    public boolean isAsynchronous() {
        if (!this.isReference()) {
            return false;
        }
        if (this.isArray()) {
            return false;
        }
        BeanRepoDef repoDef = this.getTypeDef().getBeanRepoDef();
        BeanTypeDef refTypeDef = this.getReferenceTypeDef();
        if (refTypeDef.isTypeDef(repoDef.getTypeDef("TaskRuntimeMBean"))) {
            return true;
        }
        return refTypeDef.isTypeDef(repoDef.getTypeDef("DeploymentProgressObjectMBean"));
    }

    @Override
    public Set<String> getInvokeRoles() {
        this.initializeRoles();
        return this.invokeRoles;
    }

    @Override
    public String getImpact() {
        return this.source.getImpact().toString();
    }

    BeanActionDefSource getSource() {
        return this.source;
    }

    BeanActionDefCustomizerSource getCustomizerSource() {
        return this.customizerSource;
    }

    String getLocalizationKey(String key) {
        return this.getTypeDefImpl().getLocalizationKey("actions." + this.getActionPath().getDotSeparatedPath() + "." + key);
    }

    BeanActionParamDefImpl getActionParamDefImpl(String paramName) {
        for (BeanActionParamDefImpl paramDefImpl : this.paramDefImpls) {
            if (!paramDefImpl.getParamName().equals(paramName)) continue;
            return paramDefImpl;
        }
        throw new AssertionError((Object)("Can't find param " + String.valueOf(this) + " " + paramName));
    }

    public String toString() {
        return String.valueOf(this.getTypeDef()) + ", action=" + String.valueOf(this.getActionPath());
    }
}

