/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.yaml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanActionDef;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanRepoDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.yaml.BaseBeanChildDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanActionDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanPropertyDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.BeanRepoDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.UsageTracker;
import weblogic.remoteconsole.common.repodef.yaml.YamlBasedBeanTypeDefImpl;

public abstract class BaseBeanTypeDefImpl
implements BeanTypeDef {
    private static final Logger LOGGER = Logger.getLogger(BaseBeanTypeDefImpl.class.getName());
    private String typeName;
    private BeanRepoDefImpl beanRepoDefImpl;
    private List<BeanPropertyDefImpl> propertyDefImpls;
    private List<BeanPropertyDef> propertyDefs;
    private List<BaseBeanChildDefImpl> childDefImpls;
    private List<BeanChildDef> childDefs;
    private List<BeanActionDefImpl> actionDefImpls;
    private List<BeanActionDef> actionDefs;
    private boolean initializedSubTypeDefs = false;
    private List<BaseBeanTypeDefImpl> subTypeDefImpls;
    private List<BeanTypeDef> subTypeDefs;

    BaseBeanTypeDefImpl(BeanRepoDefImpl beanRepoDefImpl, String typeName) {
        this.beanRepoDefImpl = beanRepoDefImpl;
        this.typeName = typeName;
    }

    BeanRepoDefImpl getBeanRepoDefImpl() {
        return this.beanRepoDefImpl;
    }

    @Override
    public BeanRepoDef getBeanRepoDef() {
        return this.getBeanRepoDefImpl();
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    abstract LocalizableString getDescriptionHTML();

    protected String getTypeNameLabelKey() {
        return this.getLocalizationKey("type.label");
    }

    protected String getInstanceNameLabelKey() {
        return this.getLocalizationKey("instance.label");
    }

    protected String getDescriptionHTMLKey() {
        return this.getLocalizationKey("descriptionHTML");
    }

    @Override
    public boolean hasPropertyDef(Path propertyPath, boolean searchSubTypes) {
        BeanPropertyDefImpl propertyDefImpl = this.findPropertyDefImpl(propertyPath, searchSubTypes);
        return propertyDefImpl != null && this.getBeanRepoDefImpl().isAccessAllowed(propertyDefImpl.getGetRoles());
    }

    @Override
    public BeanPropertyDef getPropertyDef(Path propertyPath, boolean searchSubTypes) {
        return this.getPropertyDefImpl(propertyPath, searchSubTypes);
    }

    BeanPropertyDefImpl getPropertyDefImpl(Path propertyPath) {
        return this.getPropertyDefImpl(propertyPath, false);
    }

    BeanPropertyDefImpl getPropertyDefImpl(Path propertyPath, boolean searchSubTypes) {
        String usageId = "property " + this.getTypeName() + " " + String.valueOf(propertyPath);
        BeanPropertyDefImpl propertyDefImpl = this.findPropertyDefImpl(propertyPath, searchSubTypes);
        if (propertyDefImpl != null && this.getBeanRepoDefImpl().isAccessAllowed(propertyDefImpl.getGetRoles())) {
            UsageTracker.used(usageId);
            return propertyDefImpl;
        }
        UsageTracker.notFound(usageId);
        return null;
    }

    private BeanPropertyDefImpl findPropertyDefImpl(Path propertyPath, boolean searchSubTypes) {
        return this.findPropertyDefImpl(new HashSet<String>(), propertyPath, searchSubTypes);
    }

    private BeanPropertyDefImpl findPropertyDefImpl(Set<String> searchedTypes, Path propertyPath, boolean searchSubTypes) {
        BeanPropertyDefImpl propertyDefImpl = this.findPropertyDefImpl(propertyPath);
        if (propertyDefImpl != null) {
            return propertyDefImpl;
        }
        if (!searchSubTypes || this.isHomogeneous()) {
            return null;
        }
        for (BaseBeanTypeDefImpl subTypeDefImpl : this.getSubTypeDefImpls()) {
            String subTypeName = subTypeDefImpl.getTypeName();
            if (subTypeName.equals(this.getTypeName()) || searchedTypes.contains(subTypeName)) continue;
            searchedTypes.add(subTypeName);
            BeanPropertyDefImpl subTypePropertyDefImpl = subTypeDefImpl.findPropertyDefImpl(searchedTypes, propertyPath, true);
            if (subTypePropertyDefImpl == null) continue;
            return subTypePropertyDefImpl;
        }
        return null;
    }

    abstract BeanPropertyDefImpl findPropertyDefImpl(Path var1);

    List<BeanPropertyDefImpl> getPropertyDefImpls() {
        return this.propertyDefImpls;
    }

    @Override
    public List<BeanPropertyDef> getPropertyDefs() {
        return this.propertyDefs;
    }

    @Override
    public BeanPropertyDef getPropertyDefFromOfflineName(String offlinePropertyName) {
        for (BeanPropertyDef propDef : this.getPropertyDefs()) {
            if (!propDef.getParentPath().isEmpty() || !propDef.getOfflinePropertyName().equals(offlinePropertyName)) continue;
            return propDef;
        }
        return null;
    }

    @Override
    public boolean hasChildDef(Path childPath, boolean searchSubTypes) {
        BaseBeanChildDefImpl childDefImpl = this.findChildDefImpl(childPath, searchSubTypes);
        return childDefImpl != null && this.getBeanRepoDefImpl().isAccessAllowed(childDefImpl.getGetRoles());
    }

    @Override
    public BeanChildDef getChildDef(Path childPath, boolean searchSubTypes) {
        return this.getChildDefImpl(childPath, searchSubTypes);
    }

    BaseBeanChildDefImpl getChildDefImpl(Path childPath) {
        return this.getChildDefImpl(childPath, false);
    }

    BaseBeanChildDefImpl getChildDefImpl(Path childPath, boolean searchSubTypes) {
        String usageId = "child " + this.getTypeName() + " " + String.valueOf(childPath);
        BaseBeanChildDefImpl childDefImpl = this.findChildDefImpl(childPath, searchSubTypes);
        if (childDefImpl != null && this.getBeanRepoDefImpl().isAccessAllowed(childDefImpl.getGetRoles())) {
            UsageTracker.used(usageId);
            return childDefImpl;
        }
        UsageTracker.notFound(usageId);
        return null;
    }

    private BaseBeanChildDefImpl findChildDefImpl(Path childPath, boolean searchSubTypes) {
        return this.findChildDefImpl(new HashSet<String>(), childPath, searchSubTypes);
    }

    private BaseBeanChildDefImpl findChildDefImpl(Set<String> searchedTypes, Path childPath, boolean searchSubTypes) {
        BaseBeanChildDefImpl childDefImpl = this.findChildDefImpl(childPath);
        if (childDefImpl != null) {
            return childDefImpl;
        }
        if (!searchSubTypes || this.isHomogeneous()) {
            return null;
        }
        for (BaseBeanTypeDefImpl subTypeDefImpl : this.getSubTypeDefImpls()) {
            String subTypeName = subTypeDefImpl.getTypeName();
            if (subTypeName.equals(this.getTypeName()) || searchedTypes.contains(subTypeName)) continue;
            searchedTypes.add(subTypeName);
            BaseBeanChildDefImpl subTypeChildDefImpl = subTypeDefImpl.findChildDefImpl(searchedTypes, childPath, searchSubTypes);
            if (subTypeChildDefImpl == null) continue;
            return subTypeChildDefImpl;
        }
        return null;
    }

    abstract BaseBeanChildDefImpl findChildDefImpl(Path var1);

    List<BaseBeanChildDefImpl> getChildDefImpls() {
        return this.childDefImpls;
    }

    @Override
    public List<BeanChildDef> getChildDefs() {
        return this.childDefs;
    }

    @Override
    public BeanChildDef getChildDefFromOfflineName(String offlineChildName) {
        for (BeanChildDef childDef : this.getChildDefs()) {
            if (!childDef.getParentPath().isEmpty() || !childDef.getOfflineChildName().equals(offlineChildName)) continue;
            return childDef;
        }
        return null;
    }

    @Override
    public boolean hasActionDef(Path actionPath, boolean searchSubTypes) {
        BeanActionDefImpl actionDefImpl = this.findActionDefImpl(actionPath, searchSubTypes);
        return actionDefImpl != null && this.getBeanRepoDefImpl().isAccessAllowed(actionDefImpl.getInvokeRoles());
    }

    @Override
    public BeanActionDef getActionDef(Path actionPath, boolean searchSubTypes) {
        return this.getActionDefImpl(actionPath, searchSubTypes);
    }

    BeanActionDefImpl getActionDefImpl(Path actionPath) {
        return this.getActionDefImpl(actionPath, false);
    }

    BeanActionDefImpl getActionDefImpl(Path actionPath, boolean searchSubTypes) {
        String usageId = "action " + this.getTypeName() + " " + String.valueOf(actionPath);
        BeanActionDefImpl actionDefImpl = this.findActionDefImpl(actionPath, searchSubTypes);
        if (actionDefImpl != null && this.getBeanRepoDefImpl().isAccessAllowed(actionDefImpl.getInvokeRoles())) {
            UsageTracker.used(usageId);
            return actionDefImpl;
        }
        UsageTracker.notFound(usageId);
        return null;
    }

    private BeanActionDefImpl findActionDefImpl(Path actionPath, boolean searchSubTypes) {
        return this.findActionDefImpl(new HashSet<String>(), actionPath, searchSubTypes);
    }

    private BeanActionDefImpl findActionDefImpl(Set<String> searchedTypes, Path actionPath, boolean searchSubTypes) {
        BeanActionDefImpl actionDefImpl = this.findActionDefImpl(actionPath);
        if (actionDefImpl != null) {
            return actionDefImpl;
        }
        if (!searchSubTypes || this.isHomogeneous()) {
            return null;
        }
        for (BaseBeanTypeDefImpl subTypeDefImpl : this.getSubTypeDefImpls()) {
            String subTypeName = subTypeDefImpl.getTypeName();
            if (subTypeName.equals(this.getTypeName()) || searchedTypes.contains(subTypeName)) continue;
            searchedTypes.add(subTypeName);
            BeanActionDefImpl subTypeActionDefImpl = subTypeDefImpl.findActionDefImpl(searchedTypes, actionPath, true);
            if (subTypeActionDefImpl == null) continue;
            return subTypeActionDefImpl;
        }
        return null;
    }

    abstract BeanActionDefImpl findActionDefImpl(Path var1);

    List<BeanActionDefImpl> getActionDefImpls() {
        return this.actionDefImpls;
    }

    @Override
    public List<BeanActionDef> getActionDefs() {
        return this.actionDefs;
    }

    protected void initializeContainedDefsAndImpls(Collection<BeanPropertyDefImpl> propertyDefImplsColl, Collection<BaseBeanChildDefImpl> childDefImplsColl, Collection<BeanActionDefImpl> actionDefImplsColl) {
        this.propertyDefImpls = Collections.unmodifiableList(new ArrayList<BeanPropertyDefImpl>(propertyDefImplsColl));
        this.propertyDefs = Collections.unmodifiableList(this.propertyDefImpls);
        this.childDefImpls = Collections.unmodifiableList(new ArrayList<BaseBeanChildDefImpl>(childDefImplsColl));
        this.childDefs = Collections.unmodifiableList(this.childDefImpls);
        this.actionDefImpls = Collections.unmodifiableList(new ArrayList<BeanActionDefImpl>(actionDefImplsColl));
        this.actionDefs = Collections.unmodifiableList(this.actionDefImpls);
    }

    abstract BeanPropertyDefImpl getKeyPropertyDefImpl();

    abstract BeanPropertyDefImpl getIdentityPropertyDefImpl();

    @Override
    public BeanPropertyDef getKeyPropertyDef() {
        return this.getKeyPropertyDefImpl();
    }

    @Override
    public BeanPropertyDef getIdentityPropertyDef() {
        return this.getIdentityPropertyDefImpl();
    }

    abstract List<BaseBeanTypeDefImpl> getInheritedTypeDefImpls();

    abstract BaseBeanTypeDefImpl getDefaultSubTypeDefImpl();

    abstract BaseBeanTypeDefImpl getSubTypeDefImpl(String var1);

    @Override
    public BeanTypeDef getSubTypeDef(String subTypeDiscriminator) {
        return this.getSubTypeDefImpl(subTypeDiscriminator);
    }

    abstract BeanPropertyDefImpl getSubTypeDiscriminatorPropertyDefImpl();

    private List<BaseBeanTypeDefImpl> getSubTypeDefImpls() {
        this.initializeSubTypeDefs();
        return this.subTypeDefImpls;
    }

    @Override
    public List<BeanTypeDef> getSubTypeDefs() {
        this.initializeSubTypeDefs();
        return this.subTypeDefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSubTypeDefs() {
        if (this.initializedSubTypeDefs) {
            return;
        }
        BaseBeanTypeDefImpl baseBeanTypeDefImpl = this;
        synchronized (baseBeanTypeDefImpl) {
            if (this.initializedSubTypeDefs) {
                return;
            }
            ArrayList<BaseBeanTypeDefImpl> newSubTypeDefImpls = new ArrayList<BaseBeanTypeDefImpl>();
            ArrayList<BeanTypeDef> newSubTypeDefs = new ArrayList<BeanTypeDef>();
            for (String disc : this.getSubTypeDiscriminatorLegalValues()) {
                BaseBeanTypeDefImpl subTypeDefImpl = this.getSubTypeDefImpl(disc);
                newSubTypeDefImpls.add(subTypeDefImpl);
                newSubTypeDefs.add(subTypeDefImpl);
            }
            BaseBeanTypeDefImpl dflt = this.getDefaultSubTypeDefImpl();
            if (dflt != null) {
                newSubTypeDefImpls.add(dflt);
                newSubTypeDefs.add(dflt);
            }
            this.subTypeDefImpls = newSubTypeDefImpls;
            this.subTypeDefs = newSubTypeDefs;
            this.initializedSubTypeDefs = true;
        }
    }

    @Override
    public BeanPropertyDef getSubTypeDiscriminatorPropertyDef() {
        return this.getSubTypeDiscriminatorPropertyDefImpl();
    }

    String getLocalizationKey(String key) {
        return this.getBeanRepoDefImpl().getLocalizationKey(this.getTypeName() + "." + key);
    }

    YamlBasedBeanTypeDefImpl asYamlBasedBeanTypeDefImpl() {
        return (YamlBasedBeanTypeDefImpl)YamlBasedBeanTypeDefImpl.class.cast(this);
    }

    abstract boolean isDisableMBeanJavadoc();

    abstract boolean isEditable();

    public String toString() {
        return "type=" + this.getTypeName();
    }
}

