/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.weblogic;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.ws.rs.core.Response;
import weblogic.console.schema.YamlSource;
import weblogic.console.schema.beaninfo.BeanTypeDefSource;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.YamlUtils;
import weblogic.remoteconsole.common.repodef.BeanRepoDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.CreateFormPagePath;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.SlicePagePath;
import weblogic.remoteconsole.common.repodef.TablePagePath;
import weblogic.remoteconsole.common.repodef.schema.BeanTypeDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.CreateFormDefSource;
import weblogic.remoteconsole.common.repodef.schema.LinksDefSource;
import weblogic.remoteconsole.common.repodef.schema.NavTreeDefSource;
import weblogic.remoteconsole.common.repodef.schema.PseudoBeanTypeDefSource;
import weblogic.remoteconsole.common.repodef.schema.SliceFormDefSource;
import weblogic.remoteconsole.common.repodef.schema.SliceTableDefSource;
import weblogic.remoteconsole.common.repodef.schema.SlicesDefSource;
import weblogic.remoteconsole.common.repodef.schema.TableDefSource;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicBeanTypeYamlReader;
import weblogic.remoteconsole.common.repodef.yaml.SlicesDefImpl;
import weblogic.remoteconsole.common.repodef.yaml.YamlDirectoryReader;
import weblogic.remoteconsole.common.repodef.yaml.YamlReader;
import weblogic.remoteconsole.common.utils.RemoteConsoleExtension;
import weblogic.remoteconsole.common.utils.WebLogicMBeansVersion;
import weblogic.remoteconsole.server.connection.Connection;
import weblogic.remoteconsole.server.utils.WebLogicRestClient;
import weblogic.remoteconsole.server.utils.WebLogicRestRequest;

class WebLogicYamlReader
extends YamlReader {
    private List<YamlDirectoryReader> typeCustomizationYamlDirectoryReaders = new ArrayList<YamlDirectoryReader>();
    private List<YamlDirectoryReader> typeYamlDirectoryReaders = new ArrayList<YamlDirectoryReader>();
    private static final Logger LOGGER = Logger.getLogger(WebLogicYamlReader.class.getName());

    WebLogicYamlReader(WebLogicMBeansVersion mbeansVersion) {
        String harvestedDir = "harvestedWeblogicBeanTypes/" + mbeansVersion.getWebLogicVersion().getDomainVersion();
        this.typeYamlDirectoryReaders.add(new YamlClasspathDirectoryReader(harvestedDir, false));
        YamlClasspathDirectoryReader builtinHandCodedYamlDirectoryReader = new YamlClasspathDirectoryReader("", false);
        this.typeCustomizationYamlDirectoryReaders.add(builtinHandCodedYamlDirectoryReader);
        this.typeYamlDirectoryReaders.add(builtinHandCodedYamlDirectoryReader);
        List<YamlDirectoryReader> extensionDirectoryReaders = this.getExtensionDirectoryReaders();
        this.typeCustomizationYamlDirectoryReaders.addAll(extensionDirectoryReaders);
        this.typeYamlDirectoryReaders.addAll(extensionDirectoryReaders);
        List<RemoteConsoleExtension> extensions = mbeansVersion.getExtensions();
        if (extensions != null) {
            for (RemoteConsoleExtension extension : extensions) {
                JarFile jarFile = extension.getJarFile();
                if (jarFile == null) continue;
                YamlJarFileDirectoryReader reader = new YamlJarFileDirectoryReader(jarFile, true);
                this.typeCustomizationYamlDirectoryReaders.add(reader);
                this.typeYamlDirectoryReaders.add(reader);
            }
        }
        if (mbeansVersion.isOnline() && mbeansVersion.getCapabilities().contains("BeanTypeDescriptions")) {
            this.typeYamlDirectoryReaders.add(new OnlineHarvestingYamlDirectoryReader(mbeansVersion.asOnline().getConnection()));
        }
    }

    private List<YamlDirectoryReader> getExtensionDirectoryReaders() {
        ArrayList<YamlDirectoryReader> readers = new ArrayList<YamlDirectoryReader>();
        String extensionDirs = System.getProperty("console.extensionDirectories");
        if (!StringUtils.isEmpty((String)extensionDirs)) {
            for (String extensionDir : extensionDirs.split(",")) {
                if ("true".equals(System.getenv("debugYaml"))) {
                    LOGGER.info("Extension directory " + extensionDir);
                }
                LOGGER.fine("Extension directory " + extensionDir);
                readers.add(new YamlFileDirectoryReader(extensionDir, true));
            }
        }
        return readers;
    }

    @Override
    protected List<YamlDirectoryReader> getTypeYamlDirectoryReaders() {
        return this.typeYamlDirectoryReaders;
    }

    @Override
    protected List<YamlDirectoryReader> getTypeCustomizationYamlDirectoryReaders() {
        return this.typeCustomizationYamlDirectoryReaders;
    }

    @Override
    public BeanTypeDefSource getBeanTypeDefSource(BeanRepoDef repoDef, String type) {
        return this.getTypeYamlReader(type).getBeanTypeDefSource(repoDef, type);
    }

    BeanTypeDefSource getDefaultBeanTypeDefSource(BeanRepoDef repoDef, String type) {
        return super.getBeanTypeDefSource(repoDef, type);
    }

    @Override
    public PseudoBeanTypeDefSource getPseudoBeanTypeDefSource(BeanRepoDef repoDef, String type) {
        return this.getTypeYamlReader(type).getPseudoBeanTypeDefSource(repoDef, type);
    }

    PseudoBeanTypeDefSource getDefaultPseudoBeanTypeDefSource(BeanRepoDef repoDef, String type) {
        return super.getPseudoBeanTypeDefSource(repoDef, type);
    }

    @Override
    public BeanTypeDefCustomizerSource getBeanTypeDefCustomizerSource(BeanTypeDef typeDef) {
        return this.getTypeYamlReader(typeDef).getBeanTypeDefCustomizerSource(typeDef);
    }

    BeanTypeDefCustomizerSource getDefaultBeanTypeDefCustomizerSource(BeanTypeDef typeDef) {
        return super.getBeanTypeDefCustomizerSource(typeDef);
    }

    @Override
    public SliceFormDefSource getSliceFormDefSource(SlicePagePath pagePath, SlicesDefImpl slicesDefImpl) {
        return this.getTypeYamlReader(pagePath).getSliceFormDefSource(pagePath, slicesDefImpl);
    }

    SliceFormDefSource getDefaultSliceFormDefSource(SlicePagePath pagePath, SlicesDefImpl slicesDefImpl) {
        return super.getSliceFormDefSource(pagePath, slicesDefImpl);
    }

    @Override
    public SliceTableDefSource getSliceTableDefSource(SlicePagePath pagePath, SlicesDefImpl slicesDefImpl) {
        return this.getTypeYamlReader(pagePath).getSliceTableDefSource(pagePath, slicesDefImpl);
    }

    SliceTableDefSource getDefaultSliceTableDefSource(SlicePagePath pagePath, SlicesDefImpl slicesDefImpl) {
        return super.getSliceTableDefSource(pagePath, slicesDefImpl);
    }

    @Override
    public CreateFormDefSource getCreateFormDefSource(CreateFormPagePath pagePath) {
        return this.getTypeYamlReader(pagePath).getCreateFormDefSource(pagePath);
    }

    CreateFormDefSource getDefaultCreateFormDefSource(CreateFormPagePath pagePath) {
        return super.getCreateFormDefSource(pagePath);
    }

    @Override
    public TableDefSource getTableDefSource(TablePagePath pagePath) {
        return this.getTypeYamlReader(pagePath).getTableDefSource(pagePath);
    }

    TableDefSource getDefaultTableDefSource(TablePagePath pagePath) {
        return super.getTableDefSource(pagePath);
    }

    @Override
    public SlicesDefSource getSlicesDefSource(BeanTypeDef typeDef) {
        return this.getTypeYamlReader(typeDef).getSlicesDefSource(typeDef);
    }

    SlicesDefSource getDefaultSlicesDefSource(BeanTypeDef typeDef) {
        return super.getSlicesDefSource(typeDef);
    }

    @Override
    public NavTreeDefSource getNavTreeDefSource(String type) {
        return this.getTypeYamlReader(type).getNavTreeDefSource(type);
    }

    NavTreeDefSource getDefaultNavTreeDefSource(String type) {
        return super.getNavTreeDefSource(type);
    }

    @Override
    public LinksDefSource getLinksDefSource(BeanTypeDef typeDef) {
        return this.getTypeYamlReader(typeDef).getLinksDefSource(typeDef);
    }

    LinksDefSource getDefaultLinksDefSource(BeanTypeDef typeDef) {
        return super.getLinksDefSource(typeDef);
    }

    private WebLogicBeanTypeYamlReader getTypeYamlReader(PagePath pagePath) {
        return this.getTypeYamlReader(pagePath.getPagesPath().getTypeDef());
    }

    private WebLogicBeanTypeYamlReader getTypeYamlReader(BeanTypeDef typeDef) {
        return this.getTypeYamlReader(typeDef.getTypeName());
    }

    private WebLogicBeanTypeYamlReader getTypeYamlReader(String type) {
        return WebLogicBeanTypeYamlReader.getTypeYamlReader(this, type);
    }

    private static class YamlClasspathDirectoryReader
    extends YamlDirectoryReaderImpl {
        private YamlClasspathDirectoryReader(String directory, boolean extension) {
            super(directory, extension);
        }

        @Override
        public <T extends YamlSource> T readYamlInternal(String yamlPath, Class<T> type, boolean mustExist) {
            return (T)((YamlSource)YamlUtils.readResource(yamlPath, type, mustExist));
        }
    }

    private static class YamlJarFileDirectoryReader
    implements YamlDirectoryReader {
        private JarFile jarFile;
        boolean extension;

        private YamlJarFileDirectoryReader(JarFile jarFile, boolean extension) {
            this.jarFile = jarFile;
            this.extension = true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <T extends YamlSource> T readYaml(String relativeYamlPath, Class<T> type, boolean mustExist) {
            ZipEntry entry = this.jarFile.getEntry(relativeYamlPath);
            if (entry == null) return null;
            try (InputStream is = this.jarFile.getInputStream(entry);){
                YamlSource rtn = (YamlSource)YamlUtils.read(is, relativeYamlPath, type, mustExist);
                if (rtn != null && this.extension) {
                    rtn.validateExtension(relativeYamlPath);
                }
                YamlSource yamlSource = rtn;
                return (T)yamlSource;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Unexpected remote console extension exception " + relativeYamlPath, e);
            }
            return null;
        }
    }

    private static class OnlineHarvestingYamlDirectoryReader
    implements YamlDirectoryReader {
        private Connection connection;

        private OnlineHarvestingYamlDirectoryReader(Connection connection) {
            this.connection = connection;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <T extends YamlSource> T readYaml(String relativeYamlPath, Class<T> type, boolean mustExist) {
            if (!type.equals(BeanTypeDefSource.class)) {
                return null;
            }
            String typeName = relativeYamlPath.substring(0, relativeYamlPath.indexOf(".yaml"));
            String relativeRestPath = "serverConfig/consoleBackend/beanTypeDescriptions/" + typeName;
            WebLogicRestRequest request = WebLogicRestRequest.builder().connection(this.connection).path(relativeRestPath).build();
            try (Response response = WebLogicRestClient.get(request, "application/yaml");){
                int status = response.getStatus();
                if (Response.Status.OK.getStatusCode() == status) {
                    try (InputStream is = (InputStream)response.readEntity(InputStream.class);){
                        YamlSource yamlSource = (YamlSource)YamlUtils.read(is, relativeYamlPath, type, true);
                        return (T)yamlSource;
                    }
                }
                if (Response.Status.NOT_FOUND.getStatusCode() == status) {
                    T t = null;
                    return t;
                }
                LOGGER.warning("Unexpected WebLogic Rest status code " + status + " " + relativeRestPath);
                return null;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unexpected WebLogic Rest exception " + relativeRestPath, e);
            }
            return null;
        }
    }

    private static class YamlFileDirectoryReader
    extends YamlDirectoryReaderImpl {
        private YamlFileDirectoryReader(String directory, boolean extension) {
            super(directory, extension);
        }

        @Override
        protected <T extends YamlSource> T readYamlInternal(String yamlPath, Class<T> type, boolean mustExist) {
            return (T)((YamlSource)YamlUtils.readFile(yamlPath, type, mustExist));
        }
    }

    private static abstract class YamlDirectoryReaderImpl
    implements YamlDirectoryReader {
        private String directory;
        private boolean extension;

        protected YamlDirectoryReaderImpl(String directory, boolean extension) {
            this.directory = directory;
            this.extension = extension;
        }

        @Override
        public <T extends YamlSource> T readYaml(String relativeYamlPath, Class<T> type, boolean mustExist) {
            T rtn = this.readYamlInternal(YamlReader.getYamlPath(this.directory, relativeYamlPath), type, mustExist);
            if (rtn != null && this.extension) {
                rtn.validateExtension(relativeYamlPath);
            }
            return rtn;
        }

        protected abstract <T extends YamlSource> T readYamlInternal(String var1, Class<T> var2, boolean var3);
    }
}

