/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.weblogic;

import java.util.ArrayList;
import java.util.List;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.CreateFormPagePath;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.PagesPath;
import weblogic.remoteconsole.common.repodef.SlicePagePath;
import weblogic.remoteconsole.common.repodef.TablePagePath;
import weblogic.remoteconsole.server.repo.BeanTreePath;

public abstract class FabricatedRuntimeMBeanNameHandler {
    private String prefix;
    private static final String RUNTIME_MBEAN = "RuntimeMBean";

    protected FabricatedRuntimeMBeanNameHandler(String prefix) {
        this.prefix = prefix;
    }

    public abstract BeanTreePath getUnfabricatedBeanTreePath(BeanTreePath var1);

    public boolean isFabricatedBeanTreePath(BeanTreePath beanTreePath) {
        return this.isFabricatedTypeDef(beanTreePath.getTypeDef());
    }

    public List<String> getFabricatedJavaTypes(List<String> types) {
        ArrayList<String> rtn = new ArrayList<String>();
        for (String type : types) {
            rtn.add(this.getFabricatedJavaType(type));
        }
        return rtn;
    }

    public String getFabricatedJavaType(String javaType) {
        if (FabricatedRuntimeMBeanNameHandler.isFabricatableJavaType(javaType)) {
            String leafClassName = StringUtils.getLeafClassName((String)javaType);
            return javaType.replaceAll(leafClassName, this.getFabricatedType(leafClassName));
        }
        return javaType;
    }

    public static boolean isFabricatableJavaType(String javaType) {
        return FabricatedRuntimeMBeanNameHandler.isFabricatableType(StringUtils.getLeafClassName((String)javaType));
    }

    public SlicePagePath getUnfabricatedSlicePagePath(SlicePagePath pagePath) {
        return PagePath.newSlicePagePath(this.getUnfabricatedPagesPath(pagePath), pagePath.getSlicePath());
    }

    public CreateFormPagePath getUnfabricatedCreateFormPagePath(CreateFormPagePath pagePath) {
        return PagePath.newCreateFormPagePath(this.getUnfabricatedPagesPath(pagePath));
    }

    public TablePagePath getUnfabricatedTablePagePath(TablePagePath pagePath) {
        return PagePath.newTablePagePath(this.getUnfabricatedPagesPath(pagePath));
    }

    public PagesPath getUnfabricatedPagesPath(PagePath pagePath) {
        return pagePath.getPagesPath().getPageRepoDef().newPagesPath(this.getUnfabricatedTypeDef(pagePath.getPagesPath().getTypeDef()));
    }

    public boolean isFabricatedPagePath(PagePath pagePath) {
        return this.isFabricatedTypeDef(pagePath.getPagesPath().getTypeDef());
    }

    public BeanTypeDef getUnfabricatedTypeDef(BeanTypeDef typeDef) {
        return typeDef.getBeanRepoDef().getTypeDef(this.getUnfabricatedType(typeDef.getTypeName()));
    }

    public boolean isFabricatedTypeDef(BeanTypeDef typeDef) {
        return this.isFabricatedType(typeDef.getTypeName());
    }

    public static boolean isFabricatableTypeDef(BeanTypeDef typeDef) {
        return FabricatedRuntimeMBeanNameHandler.isFabricatableType(typeDef.getTypeName());
    }

    public String getUnfabricatedType(String type) {
        return this.getUnfabricatedName(type);
    }

    public String getFabricatedType(String type) {
        if (!FabricatedRuntimeMBeanNameHandler.isFabricatableType(type)) {
            throw new AssertionError((Object)("Not an fabricatable type: " + type));
        }
        return this.getFabricatedName(type);
    }

    public boolean isFabricatedType(String type) {
        if (!this.isFabricatedName(type)) {
            return false;
        }
        if (!FabricatedRuntimeMBeanNameHandler.isFabricatableType(this.getUnfabricatedName(type))) {
            throw new AssertionError((Object)("Unfabricated type: " + type));
        }
        return true;
    }

    public static boolean isFabricatableType(String type) {
        String leafType = StringUtils.getLeafClassName((String)type);
        return leafType.endsWith(RUNTIME_MBEAN) || "AggregateProgressMBean".equals(leafType) || "ProgressMBean".equals(leafType) || "SAFStatisticsCommonMBean".equals(leafType);
    }

    public boolean isFabricatedName(String name) {
        return name.startsWith(this.prefix);
    }

    public String getUnfabricatedName(String name) {
        if (!this.isFabricatedName(name)) {
            throw new AssertionError((Object)("Not a fabricated name: " + name));
        }
        return name.substring(this.prefix.length());
    }

    public String getFabricatedName(String name) {
        if (this.isFabricatedName(name)) {
            throw new AssertionError((Object)("Already a fabricated name: " + name));
        }
        return this.prefix + name;
    }
}

