/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.weblogic;

import java.util.List;
import weblogic.console.schema.beaninfo.BeanPropertyDefSource;
import weblogic.console.schema.beaninfo.BeanTypeDefSource;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanRepoDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.schema.BeanChildDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.BeanTypeDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.weblogic.AggregatedRuntimeMBeanNameHandler;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicBeanTypeYamlReader;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicYamlReader;

class DomainRuntimeMBeanYamlReader
extends WebLogicBeanTypeYamlReader {
    private static final AggregatedRuntimeMBeanNameHandler AGGREGATED_NAME_HANDLER = AggregatedRuntimeMBeanNameHandler.INSTANCE;
    private static final String SERVER_RUNTIME_MBEAN = "ServerRuntimeMBean";
    private static final String DASHBOARDS = "Dashboards";

    DomainRuntimeMBeanYamlReader(WebLogicYamlReader yamlReader) {
        super(yamlReader);
    }

    @Override
    BeanTypeDefSource getBeanTypeDefSource(BeanRepoDef repoDef, String type) {
        BeanTypeDefSource source = super.getBeanTypeDefSource(repoDef, type);
        BeanTypeDefSource serverRuntimeSource = this.getYamlReader().getBeanTypeDefSource(repoDef, SERVER_RUNTIME_MBEAN);
        BeanTypeDef serverRuntimeTypeDef = repoDef.getTypeDef(SERVER_RUNTIME_MBEAN);
        this.aggregateChildren(source, serverRuntimeSource.getProperties());
        return source;
    }

    private void aggregateChildren(BeanTypeDefSource source, List<BeanPropertyDefSource> propertyDefs) {
        for (BeanPropertyDefSource propertyDef : propertyDefs) {
            String propertyType = propertyDef.getType();
            if (!AggregatedRuntimeMBeanNameHandler.isFabricatableType(propertyType)) continue;
            propertyDef.setType(AGGREGATED_NAME_HANDLER.getFabricatedJavaType(propertyType));
            propertyDef.setName(AGGREGATED_NAME_HANDLER.getFabricatedName(propertyDef.getName()));
            source.addProperty(propertyDef);
        }
    }

    @Override
    BeanTypeDefCustomizerSource getBeanTypeDefCustomizerSource(BeanTypeDef typeDef) {
        BeanTypeDefCustomizerSource domainRuntimeCustomizerSource = super.getBeanTypeDefCustomizerSource(typeDef);
        BeanChildDefCustomizerSource childCustomizer = new BeanChildDefCustomizerSource();
        childCustomizer.setName(DASHBOARDS);
        childCustomizer.setDeletable(true);
        childCustomizer.setLabel(DASHBOARDS);
        domainRuntimeCustomizerSource.addChild(childCustomizer);
        BeanTypeDefSource serverRuntimeSource = this.getYamlReader().getBeanTypeDefSource(typeDef.getBeanRepoDef(), SERVER_RUNTIME_MBEAN);
        BeanTypeDef serverRuntimeTypeDef = typeDef.getBeanRepoDef().getTypeDef(SERVER_RUNTIME_MBEAN);
        BeanTypeDefCustomizerSource serverRuntimeCustomizerSource = this.getYamlReader().getBeanTypeDefCustomizerSource(serverRuntimeTypeDef);
        this.aggregateProperties(domainRuntimeCustomizerSource, serverRuntimeCustomizerSource, serverRuntimeSource.getProperties());
        return domainRuntimeCustomizerSource;
    }

    private void aggregateProperties(BeanTypeDefCustomizerSource domainRuntimeCustomizerSource, BeanTypeDefCustomizerSource serverRuntimeCustomizerSource, List<BeanPropertyDefSource> propertyDefs) {
        for (BeanPropertyDefSource propertyDef : propertyDefs) {
            if (!propertyDef.isChild()) continue;
            if (!AggregatedRuntimeMBeanNameHandler.isFabricatableJavaType(propertyDef.getType())) continue;
            String unaggName = propertyDef.getName();
            BeanChildDefCustomizerSource childCustomizer = this.findOrCreateChildCustomizer(unaggName, serverRuntimeCustomizerSource.getChildren());
            childCustomizer.setName(AGGREGATED_NAME_HANDLER.getFabricatedName(unaggName));
            if (StringUtils.isEmpty((String)childCustomizer.getLabel())) {
                childCustomizer.setLabel(StringUtils.camelCaseToUpperCaseWords((String)unaggName));
            }
            if (!StringUtils.isEmpty((String)childCustomizer.getOnlineName())) {
                String unaggOnlineName = childCustomizer.getOnlineName();
                String aggOnlineName = StringUtils.getRestName((String)AGGREGATED_NAME_HANDLER.getFabricatedName(unaggOnlineName));
                childCustomizer.setOnlineName(aggOnlineName);
            }
            domainRuntimeCustomizerSource.addChild(childCustomizer);
        }
    }

    private BeanChildDefCustomizerSource findOrCreateChildCustomizer(String childName, List<BeanChildDefCustomizerSource> unaggChildCustomizers) {
        for (BeanChildDefCustomizerSource cc : unaggChildCustomizers) {
            if (!cc.getName().equals(childName)) continue;
            return cc;
        }
        BeanChildDefCustomizerSource rtn = new BeanChildDefCustomizerSource();
        rtn.setName(childName);
        return rtn;
    }
}

