/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.weblogic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import weblogic.console.schema.beaninfo.BeanActionDefSource;
import weblogic.console.schema.beaninfo.BeanPropertyDefSource;
import weblogic.console.schema.beaninfo.BeanTypeDefSource;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanActionDef;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanRepoDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.CreateFormPagePath;
import weblogic.remoteconsole.common.repodef.SlicePagePath;
import weblogic.remoteconsole.common.repodef.TablePagePath;
import weblogic.remoteconsole.common.repodef.schema.BeanActionDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.BeanPropertyDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.BeanTypeDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.CreateFormDefSource;
import weblogic.remoteconsole.common.repodef.schema.LinksDefSource;
import weblogic.remoteconsole.common.repodef.schema.MBeanAttributeDefSource;
import weblogic.remoteconsole.common.repodef.schema.MBeanOperationDefSource;
import weblogic.remoteconsole.common.repodef.schema.NavTreeDefSource;
import weblogic.remoteconsole.common.repodef.schema.PseudoBeanTypeDefSource;
import weblogic.remoteconsole.common.repodef.schema.SliceFormDefSource;
import weblogic.remoteconsole.common.repodef.schema.SliceTableDefSource;
import weblogic.remoteconsole.common.repodef.schema.SlicesDefSource;
import weblogic.remoteconsole.common.repodef.schema.SubTypeDefSource;
import weblogic.remoteconsole.common.repodef.schema.TableDefSource;
import weblogic.remoteconsole.common.repodef.weblogic.FabricatedRuntimeMBeanNameHandler;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicBeanTypeYamlReader;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicYamlReader;
import weblogic.remoteconsole.common.repodef.yaml.SlicesDefImpl;

abstract class DelegatedRuntimeMBeanYamlReader
extends WebLogicBeanTypeYamlReader {
    private FabricatedRuntimeMBeanNameHandler nameHandler;

    DelegatedRuntimeMBeanYamlReader(WebLogicYamlReader yamlReader, FabricatedRuntimeMBeanNameHandler nameHandler) {
        super(yamlReader);
        this.nameHandler = nameHandler;
    }

    @Override
    BeanTypeDefSource getBeanTypeDefSource(BeanRepoDef repoDef, String type) {
        BeanTypeDef undelTypeDef;
        BeanTypeDefSource source = this.getYamlReader().getBeanTypeDefSource(repoDef, this.nameHandler.getUnfabricatedType(type));
        if (source == null) {
            // empty if block
        }
        if ((undelTypeDef = repoDef.getTypeDef(this.nameHandler.getUnfabricatedType(type))) == null) {
            return null;
        }
        source.setName(this.nameHandler.getFabricatedJavaType(source.getName()));
        source.setBaseTypes(this.nameHandler.getFabricatedJavaTypes(source.getBaseTypes()));
        source.setDerivedTypes(this.nameHandler.getFabricatedJavaTypes(source.getDerivedTypes()));
        source.setActions(this.delegateActionDefs(undelTypeDef, source.getActions()));
        source.setProperties(this.delegatePropertyDefs(undelTypeDef, source.getProperties()));
        return source;
    }

    @Override
    PseudoBeanTypeDefSource getPseudoBeanTypeDefSource(BeanRepoDef repoDef, String type) {
        PseudoBeanTypeDefSource source = this.getYamlReader().getPseudoBeanTypeDefSource(repoDef, this.nameHandler.getUnfabricatedType(type));
        if (source == null) {
            return null;
        }
        String name = source.getName();
        if (FabricatedRuntimeMBeanNameHandler.isFabricatableType(name)) {
            source.setName(this.nameHandler.getFabricatedJavaType(name));
        }
        String baseType = source.getBaseType();
        if (FabricatedRuntimeMBeanNameHandler.isFabricatableType(baseType)) {
            source.setBaseType(this.nameHandler.getFabricatedJavaType(baseType));
        }
        return source;
    }

    @Override
    public BeanTypeDefCustomizerSource getBeanTypeDefCustomizerSource(BeanTypeDef typeDef) {
        ArrayList<BeanPropertyDefCustomizerSource> undelPropertyCustomizers = new ArrayList();
        ArrayList<BeanActionDefCustomizerSource> undelActionCustomizers = new ArrayList();
        BeanTypeDef undelTypeDef = this.nameHandler.getUnfabricatedTypeDef(typeDef);
        BeanTypeDefCustomizerSource source = this.getYamlReader().getBeanTypeDefCustomizerSource(undelTypeDef);
        if (source == null) {
            source = new BeanTypeDefCustomizerSource();
        } else {
            undelPropertyCustomizers = source.getProperties();
            undelActionCustomizers = source.getActions();
            source.setProperties(new ArrayList<BeanPropertyDefCustomizerSource>());
            source.setActions(new ArrayList<BeanActionDefCustomizerSource>());
        }
        source.setInstanceName(undelTypeDef.getInstanceName());
        this.delegateProperties(undelTypeDef, undelPropertyCustomizers, source);
        this.delegateActions(undelTypeDef, undelActionCustomizers, source);
        this.delegateSubTypes(source);
        return source;
    }

    private void delegateProperties(BeanTypeDef undelTypeDef, List<BeanPropertyDefCustomizerSource> undelPropertyCustomizers, BeanTypeDefCustomizerSource source) {
        for (BeanPropertyDef undelPropertyDef : undelTypeDef.getPropertyDefs()) {
            this.delegateProperty(undelPropertyDef, undelPropertyCustomizers, source);
        }
    }

    private void delegateProperty(BeanPropertyDef undelPropertyDef, List<BeanPropertyDefCustomizerSource> undelPropertyCustomizers, BeanTypeDefCustomizerSource source) {
        BeanPropertyDefCustomizerSource propertyCustomizer = this.findOrCreatePropertyCustomizer(undelPropertyDef, undelPropertyCustomizers);
        this.fixMBeanAttributeJavadocLink(undelPropertyDef, propertyCustomizer);
        source.addProperty(propertyCustomizer);
    }

    private void fixMBeanAttributeJavadocLink(BeanPropertyDef undelPropertyDef, BeanPropertyDefCustomizerSource propertyCustomizer) {
        Path parentPath = undelPropertyDef.getParentPath();
        if (!parentPath.isEmpty()) {
            boolean searchSubTypes = true;
            BeanChildDef childDef = undelPropertyDef.getTypeDef().getChildDef(parentPath, searchSubTypes);
            if (childDef != null) {
                undelPropertyDef = childDef.getChildTypeDef().getPropertyDef(new Path(undelPropertyDef.getPropertyName()), searchSubTypes);
            } else {
                return;
            }
        }
        BeanTypeDef undelTypeDef = undelPropertyDef.getTypeDef();
        if (!FabricatedRuntimeMBeanNameHandler.isFabricatableTypeDef(undelTypeDef)) {
            return;
        }
        MBeanAttributeDefSource mbeanAttr = new MBeanAttributeDefSource();
        mbeanAttr.setType(undelTypeDef.getTypeName());
        mbeanAttr.setAttribute(undelPropertyDef.getPropertyName());
        propertyCustomizer.setMbeanAttribute(mbeanAttr);
    }

    private BeanPropertyDefCustomizerSource findOrCreatePropertyCustomizer(BeanPropertyDef undelPropertyDef, List<BeanPropertyDefCustomizerSource> undelPropertyCustomizers) {
        String propertyName = undelPropertyDef.getPropertyPath().getDotSeparatedPath();
        for (BeanPropertyDefCustomizerSource pc : undelPropertyCustomizers) {
            if (!pc.getName().equals(propertyName)) continue;
            return pc;
        }
        BeanPropertyDefCustomizerSource rtn = new BeanPropertyDefCustomizerSource();
        rtn.setName(propertyName);
        return rtn;
    }

    private void delegateActions(BeanTypeDef undelTypeDef, List<BeanActionDefCustomizerSource> undelActionCustomizers, BeanTypeDefCustomizerSource source) {
        Set<String> localActionNames = this.getLocalActionNames(undelTypeDef, undelActionCustomizers);
        for (BeanActionDef undelActionDef : undelTypeDef.getActionDefs()) {
            if (!localActionNames.contains(undelActionDef.getActionPath().toString())) continue;
            this.delegateAction(undelActionDef, undelActionCustomizers, source);
        }
    }

    private Set<String> getLocalActionNames(BeanTypeDef undelTypeDef, List<BeanActionDefCustomizerSource> undelActionCustomizers) {
        HashSet<String> rtn = new HashSet<String>();
        BeanTypeDefSource source = this.getYamlReader().getBeanTypeDefSource(undelTypeDef.getBeanRepoDef(), undelTypeDef.getTypeName());
        if (source != null) {
            for (BeanActionDefSource actionSource : source.getActions()) {
                rtn.add(actionSource.getName());
            }
        }
        for (BeanActionDefCustomizerSource actionSource : undelActionCustomizers) {
            rtn.add(actionSource.getName());
        }
        return rtn;
    }

    private void delegateAction(BeanActionDef undelActionDef, List<BeanActionDefCustomizerSource> undelActionCustomizers, BeanTypeDefCustomizerSource source) {
        BeanActionDefCustomizerSource actionCustomizer = this.findOrCreateActionCustomizer(undelActionDef, undelActionCustomizers);
        this.fixMBeanOperationJavadocLink(undelActionDef, actionCustomizer);
        source.addAction(actionCustomizer);
    }

    private void fixMBeanOperationJavadocLink(BeanActionDef undelActionDef, BeanActionDefCustomizerSource actionCustomizer) {
        Path parentPath = undelActionDef.getParentPath();
        if (!parentPath.isEmpty()) {
            boolean searchSubTypes = true;
            BeanChildDef childDef = undelActionDef.getTypeDef().getChildDef(parentPath, searchSubTypes);
            if (childDef != null) {
                undelActionDef = childDef.getChildTypeDef().getActionDef(new Path(undelActionDef.getActionName()), searchSubTypes);
            } else {
                return;
            }
        }
        BeanTypeDef undelTypeDef = undelActionDef.getTypeDef();
        if (!FabricatedRuntimeMBeanNameHandler.isFabricatableTypeDef(undelTypeDef)) {
            return;
        }
        MBeanOperationDefSource undelMbeanOp = actionCustomizer.getMbeanOperation();
        if (StringUtils.isEmpty((String)undelMbeanOp.getType())) {
            MBeanOperationDefSource delMbeanOp = new MBeanOperationDefSource();
            delMbeanOp.setType(undelTypeDef.getTypeName());
            delMbeanOp.setOperation(undelMbeanOp.getOperation());
            actionCustomizer.setMbeanOperation(delMbeanOp);
        }
    }

    private BeanActionDefCustomizerSource findOrCreateActionCustomizer(BeanActionDef undelActionDef, List<BeanActionDefCustomizerSource> undelActionCustomizers) {
        String actionName = undelActionDef.getActionPath().getDotSeparatedPath();
        for (BeanActionDefCustomizerSource ac : undelActionCustomizers) {
            if (!ac.getName().equals(actionName)) continue;
            return ac;
        }
        BeanActionDefCustomizerSource rtn = new BeanActionDefCustomizerSource();
        rtn.setName(actionName);
        return rtn;
    }

    private void delegateSubTypes(BeanTypeDefCustomizerSource source) {
        for (SubTypeDefSource subType : source.getSubTypes()) {
            String type = subType.getType();
            if (!FabricatedRuntimeMBeanNameHandler.isFabricatableType(type)) continue;
            subType.setType(this.nameHandler.getFabricatedJavaType(type));
            String value = subType.getValue();
            if (StringUtils.isEmpty((String)value)) {
                value = type;
            }
            subType.setValue(value);
        }
        String defaultSubType = source.getDefaultSubType();
        if (!StringUtils.isEmpty((String)defaultSubType)) {
            source.setDefaultSubType(this.nameHandler.getFabricatedJavaType(defaultSubType));
        }
    }

    @Override
    SliceFormDefSource getSliceFormDefSource(SlicePagePath pagePath, SlicesDefImpl slicesDefImpl) {
        return this.getYamlReader().getSliceFormDefSource(this.nameHandler.getUnfabricatedSlicePagePath(pagePath), slicesDefImpl);
    }

    @Override
    SliceTableDefSource getSliceTableDefSource(SlicePagePath pagePath, SlicesDefImpl slicesDefImpl) {
        return this.getYamlReader().getSliceTableDefSource(this.nameHandler.getUnfabricatedSlicePagePath(pagePath), slicesDefImpl);
    }

    @Override
    CreateFormDefSource getCreateFormDefSource(CreateFormPagePath pagePath) {
        return this.getYamlReader().getCreateFormDefSource(this.nameHandler.getUnfabricatedCreateFormPagePath(pagePath));
    }

    @Override
    TableDefSource getTableDefSource(TablePagePath pagePath) {
        return this.getYamlReader().getTableDefSource(this.nameHandler.getUnfabricatedTablePagePath(pagePath));
    }

    @Override
    SlicesDefSource getSlicesDefSource(BeanTypeDef typeDef) {
        return this.getYamlReader().getSlicesDefSource(this.nameHandler.getUnfabricatedTypeDef(typeDef));
    }

    @Override
    NavTreeDefSource getNavTreeDefSource(String type) {
        return this.getYamlReader().getNavTreeDefSource(this.nameHandler.getUnfabricatedType(type));
    }

    @Override
    LinksDefSource getLinksDefSource(BeanTypeDef typeDef) {
        return this.getYamlReader().getLinksDefSource(this.nameHandler.getUnfabricatedTypeDef(typeDef));
    }

    private List<BeanPropertyDefSource> delegatePropertyDefs(BeanTypeDef undelTypeDef, List<BeanPropertyDefSource> propertyDefs) {
        ArrayList<BeanPropertyDefSource> rtn = new ArrayList<BeanPropertyDefSource>();
        for (BeanPropertyDefSource propertyDef : propertyDefs) {
            if (propertyDef.isChild()) {
                if (!undelTypeDef.hasChildDef(new Path(propertyDef.getName()), true)) continue;
                if (FabricatedRuntimeMBeanNameHandler.isFabricatableJavaType(propertyDef.getType())) {
                    propertyDef.setType(this.nameHandler.getFabricatedJavaType(propertyDef.getType()));
                }
                rtn.add(propertyDef);
                continue;
            }
            if (!undelTypeDef.hasPropertyDef(new Path(propertyDef.getName()), true)) continue;
            rtn.add(propertyDef);
        }
        return rtn;
    }

    private List<BeanActionDefSource> delegateActionDefs(BeanTypeDef undelTypeDef, List<BeanActionDefSource> actionDefs) {
        ArrayList<BeanActionDefSource> rtn = new ArrayList<BeanActionDefSource>();
        for (BeanActionDefSource actionDef : actionDefs) {
            if (!undelTypeDef.hasActionDef(new Path(actionDef.getName()), true)) continue;
            rtn.add(actionDef);
        }
        return rtn;
    }
}

