/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.weblogic;

import java.util.List;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.PagesPath;
import weblogic.remoteconsole.common.repodef.SlicePagePath;
import weblogic.remoteconsole.common.repodef.schema.BeanPropertyDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.NavTreeDefSource;
import weblogic.remoteconsole.common.repodef.schema.NavTreeNodeDefSource;
import weblogic.remoteconsole.common.repodef.schema.SliceFormDefSource;
import weblogic.remoteconsole.common.repodef.schema.SliceTableDefSource;
import weblogic.remoteconsole.common.repodef.schema.SlicesDefSource;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicBeanTypeYamlReader;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicYamlReader;
import weblogic.remoteconsole.common.repodef.yaml.SlicesDefImpl;

abstract class CombinedServerRuntimeMBeanYamlReader
extends WebLogicBeanTypeYamlReader {
    CombinedServerRuntimeMBeanYamlReader(WebLogicYamlReader yamlReader) {
        super(yamlReader);
    }

    protected abstract String getDelegatedType();

    protected abstract String getDelegatedProperty();

    @Override
    SliceFormDefSource getSliceFormDefSource(SlicePagePath pagePath, SlicesDefImpl slicesDefImpl) {
        SliceFormDefSource source = this.getYamlReader().getSliceFormDefSource(this.getDelegatedSlicePagePath(pagePath), slicesDefImpl);
        if (source == null) {
            return null;
        }
        for (BeanPropertyDefCustomizerSource property : source.getProperties()) {
            this.delegateProperty(property);
        }
        for (BeanPropertyDefCustomizerSource property : source.getAdvancedProperties()) {
            this.delegateProperty(property);
        }
        return source;
    }

    @Override
    SliceTableDefSource getSliceTableDefSource(SlicePagePath pagePath, SlicesDefImpl slicesDefImpl) {
        return this.getYamlReader().getSliceTableDefSource(this.getDelegatedSlicePagePath(pagePath), slicesDefImpl);
    }

    private void delegateProperty(BeanPropertyDefCustomizerSource property) {
        property.setName(this.getDelegatedProperty() + "." + property.getName());
    }

    @Override
    SlicesDefSource getSlicesDefSource(BeanTypeDef typeDef) {
        return this.getYamlReader().getSlicesDefSource(this.getDelegatedTypeDef(typeDef));
    }

    @Override
    NavTreeDefSource getNavTreeDefSource(String type) {
        NavTreeDefSource source = this.getYamlReader().getNavTreeDefSource(this.getDelegatedType());
        if (source == null) {
            return null;
        }
        this.delegateNavTreeNodes(source.getContents());
        return source;
    }

    protected void delegateNavTreeNodes(List<NavTreeNodeDefSource> nodes) {
        for (NavTreeNodeDefSource node : nodes) {
            if (node.getType() == NavTreeNodeDefSource.Type.child) {
                node.setChild(this.getDelegatedProperty() + "." + node.getChild());
            }
            this.delegateNavTreeNodes(node.getContents());
        }
    }

    public SlicePagePath getDelegatedSlicePagePath(SlicePagePath pagePath) {
        return PagePath.newSlicePagePath(this.getDelegatedPagesPath(pagePath), pagePath.getSlicePath());
    }

    public PagesPath getDelegatedPagesPath(PagePath pagePath) {
        return pagePath.getPagesPath().getPageRepoDef().newPagesPath(this.getDelegatedTypeDef(pagePath.getPagesPath().getTypeDef()));
    }

    private BeanTypeDef getDelegatedTypeDef(BeanTypeDef typeDef) {
        return typeDef.getBeanRepoDef().getTypeDef(this.getDelegatedType());
    }
}

