/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.weblogic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import weblogic.console.schema.beaninfo.BeanActionDefSource;
import weblogic.console.schema.beaninfo.BeanPropertyDefSource;
import weblogic.console.schema.beaninfo.BeanTypeDefSource;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanActionDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanRepoDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.CreateFormPagePath;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.SlicePagePath;
import weblogic.remoteconsole.common.repodef.TablePagePath;
import weblogic.remoteconsole.common.repodef.schema.BeanActionDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.BeanPropertyDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.BeanTypeDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.CreateFormDefSource;
import weblogic.remoteconsole.common.repodef.schema.LinksDefSource;
import weblogic.remoteconsole.common.repodef.schema.MBeanAttributeDefSource;
import weblogic.remoteconsole.common.repodef.schema.MBeanOperationDefSource;
import weblogic.remoteconsole.common.repodef.schema.NavTreeDefSource;
import weblogic.remoteconsole.common.repodef.schema.PseudoBeanTypeDefSource;
import weblogic.remoteconsole.common.repodef.schema.SliceFormDefSource;
import weblogic.remoteconsole.common.repodef.schema.SliceTableDefSource;
import weblogic.remoteconsole.common.repodef.schema.SlicesDefSource;
import weblogic.remoteconsole.common.repodef.schema.SubTypeDefSource;
import weblogic.remoteconsole.common.repodef.schema.TableDefSource;
import weblogic.remoteconsole.common.repodef.weblogic.AggregatedRuntimeMBeanNameHandler;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicBeanTypeYamlReader;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicYamlReader;
import weblogic.remoteconsole.common.repodef.yaml.SlicesDefImpl;

class AggregatedRuntimeMBeanYamlReader
extends WebLogicBeanTypeYamlReader {
    private static final AggregatedRuntimeMBeanNameHandler NAME_HANDLER = AggregatedRuntimeMBeanNameHandler.INSTANCE;

    AggregatedRuntimeMBeanYamlReader(WebLogicYamlReader yamlReader) {
        super(yamlReader);
    }

    @Override
    BeanTypeDefSource getBeanTypeDefSource(BeanRepoDef repoDef, String type) {
        BeanTypeDefSource source = this.getYamlReader().getBeanTypeDefSource(repoDef, NAME_HANDLER.getUnfabricatedType(type));
        if (source == null) {
            return null;
        }
        BeanTypeDef unaggTypeDef = repoDef.getTypeDef(NAME_HANDLER.getUnfabricatedType(type));
        if (unaggTypeDef == null) {
            return null;
        }
        BeanPropertyDefSource server = new BeanPropertyDefSource();
        server.setName("Server");
        server.setType("weblogic.management.runtime.ServerRuntimeMBean");
        server.setRelationship("reference");
        source.setName(NAME_HANDLER.getFabricatedJavaType(source.getName()));
        source.setBaseTypes(NAME_HANDLER.getFabricatedJavaTypes(source.getBaseTypes()));
        source.setDerivedTypes(NAME_HANDLER.getFabricatedJavaTypes(source.getDerivedTypes()));
        source.setProperties(this.aggregatePropertyDefs(unaggTypeDef, source.getProperties()));
        source.addProperty(server);
        return source;
    }

    @Override
    PseudoBeanTypeDefSource getPseudoBeanTypeDefSource(BeanRepoDef repoDef, String type) {
        PseudoBeanTypeDefSource source = this.getYamlReader().getPseudoBeanTypeDefSource(repoDef, NAME_HANDLER.getUnfabricatedType(type));
        if (source == null) {
            return null;
        }
        String name = source.getName();
        if (AggregatedRuntimeMBeanNameHandler.isFabricatableType(name)) {
            source.setName(NAME_HANDLER.getFabricatedJavaType(name));
        }
        String baseType = source.getBaseType();
        if (AggregatedRuntimeMBeanNameHandler.isFabricatableType(baseType)) {
            source.setBaseType(NAME_HANDLER.getFabricatedJavaType(baseType));
        }
        return source;
    }

    @Override
    public BeanTypeDefCustomizerSource getBeanTypeDefCustomizerSource(BeanTypeDef typeDef) {
        ArrayList<BeanPropertyDefCustomizerSource> unaggPropertyCustomizers = new ArrayList();
        ArrayList<BeanActionDefCustomizerSource> unaggActionCustomizers = new ArrayList();
        BeanTypeDef unaggTypeDef = NAME_HANDLER.getUnfabricatedTypeDef(typeDef);
        BeanTypeDefCustomizerSource source = this.getYamlReader().getBeanTypeDefCustomizerSource(unaggTypeDef);
        if (source == null) {
            source = new BeanTypeDefCustomizerSource();
        } else {
            unaggPropertyCustomizers = source.getProperties();
            unaggActionCustomizers = source.getActions();
            source.setProperties(new ArrayList<BeanPropertyDefCustomizerSource>());
            source.setActions(new ArrayList<BeanActionDefCustomizerSource>());
        }
        source.setInstanceName(unaggTypeDef.getInstanceName());
        source.setCreateResourceMethod("weblogic.remoteconsole.customizers.AggregatedMBeanCustomizer.createResource");
        this.aggregateProperties(unaggTypeDef, unaggPropertyCustomizers, source);
        this.aggregateActions(unaggTypeDef, unaggActionCustomizers, source);
        this.aggregateSubTypes(unaggTypeDef, source);
        return source;
    }

    private void aggregateProperties(BeanTypeDef unaggTypeDef, List<BeanPropertyDefCustomizerSource> unaggPropertyCustomizers, BeanTypeDefCustomizerSource source) {
        for (BeanPropertyDef unaggPropertyDef : unaggTypeDef.getPropertyDefs()) {
            this.aggregateProperty(unaggPropertyDef, unaggPropertyCustomizers, source);
        }
        BeanPropertyDefCustomizerSource server = new BeanPropertyDefCustomizerSource();
        server.setName("Server");
        MBeanAttributeDefSource mbeanAttr = new MBeanAttributeDefSource();
        mbeanAttr.setType("ServerRuntimeMBean");
        mbeanAttr.setAttribute("Name");
        server.setMbeanAttribute(mbeanAttr);
        source.addProperty(server);
    }

    private void aggregateProperty(BeanPropertyDef unaggPropertyDef, List<BeanPropertyDefCustomizerSource> unaggPropertyCustomizers, BeanTypeDefCustomizerSource source) {
        BeanPropertyDefCustomizerSource propertyCustomizer = this.findOrCreatePropertyCustomizer(unaggPropertyDef, unaggPropertyCustomizers);
        this.fixMBeanAttributeJavadocLink(unaggPropertyDef, propertyCustomizer);
        source.addProperty(propertyCustomizer);
    }

    private void fixMBeanAttributeJavadocLink(BeanPropertyDef unaggPropertyDef, BeanPropertyDefCustomizerSource propertyCustomizer) {
        Path parentPath = unaggPropertyDef.getParentPath();
        if (!parentPath.isEmpty()) {
            boolean searchSubTypes = true;
            unaggPropertyDef = unaggPropertyDef.getTypeDef().getChildDef(parentPath, searchSubTypes).getChildTypeDef().getPropertyDef(new Path(unaggPropertyDef.getPropertyName()), searchSubTypes);
        }
        BeanTypeDef unaggTypeDef = unaggPropertyDef.getTypeDef();
        if (!AggregatedRuntimeMBeanNameHandler.isFabricatableTypeDef(unaggTypeDef)) {
            return;
        }
        MBeanAttributeDefSource mbeanAttr = new MBeanAttributeDefSource();
        mbeanAttr.setType(unaggTypeDef.getTypeName());
        mbeanAttr.setAttribute(unaggPropertyDef.getPropertyName());
        propertyCustomizer.setMbeanAttribute(mbeanAttr);
    }

    private BeanPropertyDefCustomizerSource findOrCreatePropertyCustomizer(BeanPropertyDef unaggPropertyDef, List<BeanPropertyDefCustomizerSource> unaggPropertyCustomizers) {
        String propertyName = unaggPropertyDef.getPropertyPath().getDotSeparatedPath();
        for (BeanPropertyDefCustomizerSource pc : unaggPropertyCustomizers) {
            if (!pc.getName().equals(propertyName)) continue;
            return pc;
        }
        BeanPropertyDefCustomizerSource rtn = new BeanPropertyDefCustomizerSource();
        rtn.setName(propertyName);
        return rtn;
    }

    private void aggregateActions(BeanTypeDef unaggTypeDef, List<BeanActionDefCustomizerSource> unaggActionCustomizers, BeanTypeDefCustomizerSource source) {
        Set<String> localActionNames = this.getLocalActionNames(unaggTypeDef, unaggActionCustomizers);
        for (BeanActionDef unaggActionDef : unaggTypeDef.getActionDefs()) {
            if (!localActionNames.contains(unaggActionDef.getActionPath().toString())) continue;
            this.aggregateAction(unaggActionDef, unaggActionCustomizers, source);
        }
    }

    private Set<String> getLocalActionNames(BeanTypeDef unaggTypeDef, List<BeanActionDefCustomizerSource> unaggActionCustomizers) {
        HashSet<String> rtn = new HashSet<String>();
        BeanTypeDefSource source = this.getYamlReader().getBeanTypeDefSource(unaggTypeDef.getBeanRepoDef(), unaggTypeDef.getTypeName());
        if (source != null) {
            for (BeanActionDefSource actionSource : source.getActions()) {
                rtn.add(actionSource.getName());
            }
        }
        for (BeanActionDefCustomizerSource actionSource : unaggActionCustomizers) {
            rtn.add(actionSource.getName());
        }
        return rtn;
    }

    private void aggregateAction(BeanActionDef unaggActionDef, List<BeanActionDefCustomizerSource> unaggActionCustomizers, BeanTypeDefCustomizerSource source) {
        BeanActionDefCustomizerSource actionCustomizer = this.findActionCustomizer(unaggActionDef, unaggActionCustomizers);
        if (actionCustomizer != null) {
            this.fixMBeanOperationJavadocLink(unaggActionDef, actionCustomizer);
        } else {
            actionCustomizer = new BeanActionDefCustomizerSource();
            actionCustomizer.setName(unaggActionDef.getActionName());
        }
        source.addAction(actionCustomizer);
    }

    private void fixMBeanOperationJavadocLink(BeanActionDef unaggActionDef, BeanActionDefCustomizerSource actionCustomizer) {
        Path parentPath = unaggActionDef.getParentPath();
        if (!parentPath.isEmpty()) {
            boolean searchSubTypes = true;
            unaggActionDef = unaggActionDef.getTypeDef().getChildDef(parentPath, searchSubTypes).getChildTypeDef().getActionDef(new Path(unaggActionDef.getActionName()), searchSubTypes);
        }
        BeanTypeDef unaggTypeDef = unaggActionDef.getTypeDef();
        if (!AggregatedRuntimeMBeanNameHandler.isFabricatableTypeDef(unaggTypeDef)) {
            return;
        }
        MBeanOperationDefSource unaggMbeanOp = actionCustomizer.getMbeanOperation();
        if (StringUtils.isEmpty((String)unaggMbeanOp.getType())) {
            MBeanOperationDefSource aggMbeanOp = new MBeanOperationDefSource();
            aggMbeanOp.setType(unaggTypeDef.getTypeName());
            aggMbeanOp.setOperation(unaggMbeanOp.getOperation());
            actionCustomizer.setMbeanOperation(aggMbeanOp);
        }
    }

    private BeanActionDefCustomizerSource findActionCustomizer(BeanActionDef unaggActionDef, List<BeanActionDefCustomizerSource> unaggActionCustomizers) {
        String actionName = unaggActionDef.getActionPath().getDotSeparatedPath();
        for (BeanActionDefCustomizerSource ac : unaggActionCustomizers) {
            if (!ac.getName().equals(actionName)) continue;
            return ac;
        }
        return null;
    }

    private void aggregateSubTypes(BeanTypeDef unaggTypeDef, BeanTypeDefCustomizerSource source) {
        if (source.getSubTypes().isEmpty()) {
            return;
        }
        String baseTypeValue = unaggTypeDef.getInstanceName();
        boolean foundBaseType = false;
        for (SubTypeDefSource subType : source.getSubTypes()) {
            if (baseTypeValue.equals(subType.getValue())) {
                foundBaseType = true;
            }
            String type = subType.getType();
            if (!AggregatedRuntimeMBeanNameHandler.isFabricatableType(type)) continue;
            subType.setType(NAME_HANDLER.getFabricatedJavaType(type));
        }
        String defaultSubType = source.getDefaultSubType();
        if (!StringUtils.isEmpty((String)defaultSubType)) {
            if (AggregatedRuntimeMBeanNameHandler.isFabricatableType(defaultSubType)) {
                source.setDefaultSubType(NAME_HANDLER.getFabricatedJavaType(defaultSubType));
            }
        }
        if (!foundBaseType) {
            SubTypeDefSource baseSubType = new SubTypeDefSource();
            baseSubType.setType(NAME_HANDLER.getFabricatedJavaType(unaggTypeDef.getTypeName()));
            baseSubType.setValue(baseTypeValue);
            source.addSubType(baseSubType);
        }
    }

    @Override
    SliceFormDefSource getSliceFormDefSource(SlicePagePath pagePath, SlicesDefImpl slicesDefImpl) {
        return null;
    }

    @Override
    SliceTableDefSource getSliceTableDefSource(SlicePagePath pagePath, SlicesDefImpl slicesDefImpl) {
        SlicePagePath unaggPagePath = NAME_HANDLER.getUnfabricatedSlicePagePath(pagePath);
        SliceFormDefSource unaggSource = this.getYamlReader().getSliceFormDefSource(unaggPagePath, slicesDefImpl);
        if (unaggSource == null) {
            return null;
        }
        SliceTableDefSource source = new SliceTableDefSource();
        source.setIntroductionHTML(unaggSource.getIntroductionHTML());
        source.setHelpTopics(unaggSource.getHelpTopics());
        BeanPropertyDefCustomizerSource serverColumn = new BeanPropertyDefCustomizerSource();
        serverColumn.setName("Server");
        source.addDisplayedColumn(serverColumn);
        for (BeanPropertyDefCustomizerSource column : unaggSource.getProperties()) {
            source.addDisplayedColumn(column);
        }
        for (BeanPropertyDefCustomizerSource column : unaggSource.getAdvancedProperties()) {
            source.addHiddenColumn(column);
        }
        source.setGetTableRowsMethod("weblogic.remoteconsole.customizers.AggregatedMBeanCustomizer.getSliceTableRows");
        source.setSupportsNavigation(true);
        TablePagePath unaggTablePath = PagePath.newTablePagePath(unaggPagePath.getPagesPath());
        TableDefSource unaggTableSource = this.getYamlReader().getTableDefSource(unaggTablePath);
        if (unaggTableSource != null) {
            source.setActions(unaggTableSource.getActions());
        }
        return source;
    }

    @Override
    CreateFormDefSource getCreateFormDefSource(CreateFormPagePath pagePath) {
        if (this.getYamlReader().getCreateFormDefSource(NAME_HANDLER.getUnfabricatedCreateFormPagePath(pagePath)) != null) {
            throw new AssertionError((Object)("Aggregated types do not support create forms: " + String.valueOf(pagePath)));
        }
        return null;
    }

    @Override
    TableDefSource getTableDefSource(TablePagePath pagePath) {
        TableDefSource unaggSource = this.getYamlReader().getTableDefSource(NAME_HANDLER.getUnfabricatedTablePagePath(pagePath));
        if (unaggSource == null) {
            return null;
        }
        TableDefSource source = new TableDefSource();
        source.setIntroductionHTML(unaggSource.getIntroductionHTML());
        source.setHelpTopics(unaggSource.getHelpTopics());
        BeanPropertyDefCustomizerSource column = new BeanPropertyDefCustomizerSource();
        column.setName("Name");
        source.addDisplayedColumn(column);
        if (pagePath.getPagesPath().getTypeDef().isHeterogeneous()) {
            column = new BeanPropertyDefCustomizerSource();
            column.setName("Type");
            source.addDisplayedColumn(column);
        }
        return source;
    }

    @Override
    SlicesDefSource getSlicesDefSource(BeanTypeDef typeDef) {
        SlicesDefSource rtn = this.getYamlReader().getDefaultSlicesDefSource(typeDef);
        if (rtn == null) {
            rtn = this.getYamlReader().getSlicesDefSource(NAME_HANDLER.getUnfabricatedTypeDef(typeDef));
        }
        return rtn;
    }

    @Override
    NavTreeDefSource getNavTreeDefSource(String type) {
        return this.getYamlReader().getNavTreeDefSource(NAME_HANDLER.getUnfabricatedType(type));
    }

    @Override
    LinksDefSource getLinksDefSource(BeanTypeDef typeDef) {
        return this.getYamlReader().getLinksDefSource(NAME_HANDLER.getUnfabricatedTypeDef(typeDef));
    }

    private List<BeanPropertyDefSource> aggregatePropertyDefs(BeanTypeDef unaggTypeDef, List<BeanPropertyDefSource> propertyDefs) {
        ArrayList<BeanPropertyDefSource> rtn = new ArrayList<BeanPropertyDefSource>();
        for (BeanPropertyDefSource propertyDef : propertyDefs) {
            if (propertyDef.isChild()) {
                if (!unaggTypeDef.hasChildDef(new Path(propertyDef.getName()), true)) continue;
                if (AggregatedRuntimeMBeanNameHandler.isFabricatableJavaType(propertyDef.getType())) {
                    propertyDef.setType(NAME_HANDLER.getFabricatedJavaType(propertyDef.getType()));
                }
                rtn.add(propertyDef);
                continue;
            }
            if (!unaggTypeDef.hasPropertyDef(new Path(propertyDef.getName()), true)) continue;
            rtn.add(propertyDef);
        }
        return rtn;
    }
}

