/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.weblogic;

import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.weblogic.FabricatedRuntimeMBeanNameHandler;
import weblogic.remoteconsole.server.repo.BeanTreePath;

public class AggregatedRuntimeMBeanNameHandler
extends FabricatedRuntimeMBeanNameHandler {
    public static final AggregatedRuntimeMBeanNameHandler INSTANCE = new AggregatedRuntimeMBeanNameHandler();

    private AggregatedRuntimeMBeanNameHandler() {
        super("Aggregated");
    }

    public boolean isAggregatedBeanTreePath(BeanTreePath btp) {
        Path path = btp.getPath();
        return path.length() > 1 && INSTANCE.isFabricatedName((String)path.getComponents().get(1));
    }

    public BeanTreePath getUnaggregatedBeanTreePath(BeanTreePath btp) {
        Path path = btp.getPath();
        if (path.length() < 2 || !this.isFabricatedName((String)path.getComponents().get(1))) {
            return btp;
        }
        String aggChild = (String)path.getComponents().get(1);
        Path restOfAggPath = path.subPath(2, path.length());
        String unaggChild = this.getUnfabricatedName(aggChild);
        Path serverRelativeUnaggPath = new Path(unaggChild).childPath(restOfAggPath);
        return BeanTreePath.create(btp.getBeanRepo(), new Path("DomainRuntime.CombinedServerRuntimes")).childPath(new Path("ServerRuntime")).childPath(serverRelativeUnaggPath);
    }

    @Override
    public BeanTreePath getUnfabricatedBeanTreePath(BeanTreePath aggBeanTreePath) {
        Path aggPath = aggBeanTreePath.getPath();
        String aggChild = (String)aggPath.getComponents().get(1);
        Path restOfAggPath = aggPath.subPath(2, aggPath.length());
        String unaggChild = this.getUnfabricatedName(aggChild);
        Path serverRelativeUnaggPath = new Path(unaggChild).childPath(restOfAggPath);
        return BeanTreePath.create(aggBeanTreePath.getBeanRepo(), new Path("DomainRuntime.ServerRuntimes")).childPath(serverRelativeUnaggPath);
    }
}

