/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.schema;

import java.util.List;
import weblogic.console.schema.BooleanValue;
import weblogic.console.schema.ListValue;
import weblogic.console.schema.StringValue;
import weblogic.console.schema.Value;
import weblogic.console.schema.YamlSource;
import weblogic.console.schema.beaninfo.BeanPropertyDefSource;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.schema.BeanFieldDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.MBeanAttributeDefSource;
import weblogic.remoteconsole.common.repodef.schema.UsedIfDefSource;

public class BeanPropertyDefCustomizerSource
extends BeanFieldDefCustomizerSource {
    private StringValue onlineName = StringValue.create();
    private StringValue offlineName = StringValue.create();
    private BooleanValue useUnlocalizedNameAsLabel = BooleanValue.create();
    private Value<UsedIfDefSource> usedIf = Value.create();
    private Value<Writable> writable = Value.create((Object)((Object)Writable.defer));
    private Value<MBeanAttributeDefSource> mbeanAttribute = Value.create((Object)((Object)new MBeanAttributeDefSource()));
    private Value<BeanPropertyDefSource> definition = Value.create();
    private BooleanValue supportsModelTokens = BooleanValue.create((Boolean)true);
    private BooleanValue dontReturnIfHiddenColumn = BooleanValue.create();
    private BooleanValue disableMBeanJavadoc = BooleanValue.create();
    private ListValue<String> requiredCapabilities = ListValue.create();

    public void merge(BeanPropertyDefCustomizerSource from, Path fromContainedBeanPath) {
        super.merge(from, fromContainedBeanPath);
        this.onlineName = this.onlineName.merge(from.onlineName, fromContainedBeanPath);
        this.offlineName = this.offlineName.merge(from.offlineName, fromContainedBeanPath);
        this.useUnlocalizedNameAsLabel = this.useUnlocalizedNameAsLabel.merge(from.useUnlocalizedNameAsLabel, fromContainedBeanPath);
        this.writable = this.writable.merge(from.writable, fromContainedBeanPath);
        this.mbeanAttribute = this.mbeanAttribute.merge(from.mbeanAttribute, fromContainedBeanPath);
        this.definition = this.definition.merge(from.definition, fromContainedBeanPath);
        this.supportsModelTokens = this.supportsModelTokens.merge(from.supportsModelTokens, fromContainedBeanPath);
        this.dontReturnIfHiddenColumn = this.dontReturnIfHiddenColumn.merge(from.dontReturnIfHiddenColumn, fromContainedBeanPath);
        this.disableMBeanJavadoc = this.disableMBeanJavadoc.merge(from.disableMBeanJavadoc, fromContainedBeanPath);
        this.requiredCapabilities = this.requiredCapabilities.merge(from.requiredCapabilities, fromContainedBeanPath);
        this.mergeUsedIf(from, fromContainedBeanPath);
    }

    private void mergeUsedIf(BeanPropertyDefCustomizerSource from, Path fromContainedBeanPath) {
        if (from.usedIf.isSpecifiedInYaml()) {
            this.setUsedIf(new UsedIfDefSource(from.getUsedIf(), fromContainedBeanPath));
        }
    }

    public String getOnlineName() {
        return (String)this.onlineName.getValue();
    }

    public void setOnlineName(String value) {
        this.onlineName = this.onlineName.setValue(value);
    }

    public String getOfflineName() {
        return (String)this.offlineName.getValue();
    }

    public void setOfflineName(String value) {
        this.offlineName = this.offlineName.setValue(value);
    }

    public boolean isUseUnlocalizedNameAsLabel() {
        return (Boolean)this.useUnlocalizedNameAsLabel.getValue();
    }

    public void setUseUnlocalizedNameAsLabel(boolean value) {
        this.useUnlocalizedNameAsLabel = this.useUnlocalizedNameAsLabel.setValue(Boolean.valueOf(value));
    }

    public UsedIfDefSource getUsedIf() {
        return (UsedIfDefSource)((Object)this.usedIf.getValue());
    }

    public void setUsedIf(UsedIfDefSource value) {
        this.usedIf = this.usedIf.setValue((Object)value);
    }

    public Writable getWritable() {
        return (Writable)((Object)this.writable.getValue());
    }

    public void setWritable(Writable value) {
        this.writable = this.writable.setValue((Object)value);
    }

    public MBeanAttributeDefSource getMbeanAttribute() {
        return (MBeanAttributeDefSource)((Object)this.mbeanAttribute.getValue());
    }

    public void setMbeanAttribute(MBeanAttributeDefSource value) {
        this.mbeanAttribute = this.mbeanAttribute.setValue((Object)value);
    }

    public BeanPropertyDefSource getDefinition() {
        return (BeanPropertyDefSource)this.definition.getValue();
    }

    public void setDefinition(BeanPropertyDefSource value) {
        this.definition = this.definition.setValue((Object)value);
    }

    public boolean isSupportsModelTokens() {
        return (Boolean)this.supportsModelTokens.getValue();
    }

    public void setSupportsModelTokens(boolean val) {
        this.supportsModelTokens = this.supportsModelTokens.setValue(Boolean.valueOf(val));
    }

    public boolean isSupportsModelTokensSpecifiedInYaml() {
        return this.supportsModelTokens.isSpecifiedInYaml();
    }

    public boolean isDontReturnIfHiddenColumn() {
        return (Boolean)this.dontReturnIfHiddenColumn.getValue();
    }

    public void setDontReturnIfHiddenColumn(boolean val) {
        this.dontReturnIfHiddenColumn = this.dontReturnIfHiddenColumn.setValue(Boolean.valueOf(val));
    }

    public boolean isDisableMBeanJavadoc() {
        return (Boolean)this.disableMBeanJavadoc.getValue();
    }

    public void setDisableMBeanJavadoc(boolean value) {
        this.disableMBeanJavadoc = this.disableMBeanJavadoc.setValue(Boolean.valueOf(value));
    }

    public List<String> getRequiredCapabilities() {
        return (List)this.requiredCapabilities.getValue();
    }

    public void setRequiredCapabilities(List<String> val) {
        this.requiredCapabilities = this.requiredCapabilities.setValue(val);
    }

    @Override
    protected void validateExtension() {
        super.validateExtension();
        this.validateExtensionChild(this.getUsedIf(), "usedIf");
        this.validateExtensionChild(this.getMbeanAttribute(), "mbeanAttribute");
        this.validateExtensionChild((YamlSource)this.getDefinition(), "definition");
    }

    public static enum Writable {
        defer,
        never,
        always,
        createOnly;

    }
}

