/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.schema;

import java.util.List;
import weblogic.console.schema.BooleanValue;
import weblogic.console.schema.ListValue;
import weblogic.console.schema.StringValue;
import weblogic.console.schema.Value;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.schema.BeanFieldPresentationDefSource;
import weblogic.remoteconsole.common.repodef.schema.BeanValueDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.LegalValueDefCustomizerSource;
import weblogic.remoteconsole.common.utils.CustomizerInvocationUtils;

public class BeanFieldDefCustomizerSource
extends BeanValueDefCustomizerSource {
    private StringValue name = StringValue.create();
    private StringValue formName = StringValue.create();
    private StringValue label = StringValue.create();
    private StringValue helpSummaryHTML = StringValue.create();
    private StringValue helpDetailsHTML = StringValue.create();
    private StringValue helpHTML = StringValue.create();
    private BooleanValue required = BooleanValue.create();
    private ListValue<String> optionsSources = ListValue.create();
    private BooleanValue allowNullReference = BooleanValue.create((Boolean)true);
    private StringValue getMethod = StringValue.create();
    private StringValue optionsMethod = StringValue.create();
    private Value<BeanFieldPresentationDefSource> presentation = Value.create((Object)((Object)new BeanFieldPresentationDefSource()));
    private BooleanValue useUnlocalizedLegalValuesAsLabels = BooleanValue.create();
    private ListValue<LegalValueDefCustomizerSource> legalValues = ListValue.create();

    public void merge(BeanFieldDefCustomizerSource from, Path fromContainedBeanPath) {
        super.merge(from, fromContainedBeanPath);
        this.formName = this.formName.merge(from.formName, fromContainedBeanPath);
        this.label = this.label.merge(from.label, fromContainedBeanPath);
        this.required = this.required.merge(from.required, fromContainedBeanPath);
        this.optionsSources = this.optionsSources.merge(from.optionsSources, fromContainedBeanPath);
        this.allowNullReference = this.allowNullReference.merge(from.allowNullReference, fromContainedBeanPath);
        this.getMethod = this.getMethod.merge(from.getMethod, fromContainedBeanPath);
        this.optionsMethod = this.optionsMethod.merge(from.optionsMethod, fromContainedBeanPath);
        this.presentation = this.presentation.merge(from.presentation, fromContainedBeanPath);
        this.useUnlocalizedLegalValuesAsLabels = this.useUnlocalizedLegalValuesAsLabels.merge(from.useUnlocalizedLegalValuesAsLabels, fromContainedBeanPath);
        this.legalValues = this.legalValues.merge(from.legalValues, fromContainedBeanPath);
        this.mergeHelp(from, fromContainedBeanPath);
    }

    private void mergeHelp(BeanFieldDefCustomizerSource from, Path fromContainedBeanPath) {
        if (from.helpHTML.isSpecifiedInYaml() || from.helpSummaryHTML.isSpecifiedInYaml() || from.helpDetailsHTML.isSpecifiedInYaml()) {
            this.helpSummaryHTML = this.helpSummaryHTML.copyFrom(from.helpSummaryHTML, fromContainedBeanPath);
            this.helpDetailsHTML = this.helpDetailsHTML.copyFrom(from.helpDetailsHTML, fromContainedBeanPath);
            this.helpHTML = this.helpHTML.copyFrom(from.helpHTML, fromContainedBeanPath);
        }
    }

    public String getName() {
        return (String)this.name.getValue();
    }

    public void setName(String value) {
        this.name = this.name.setValue(value);
    }

    public String getFormName() {
        return (String)this.formName.getValue();
    }

    public void setFormName(String value) {
        this.formName = this.formName.setValue(value);
    }

    public String getLabel() {
        return (String)this.label.getValue();
    }

    public void setLabel(String value) {
        this.label = this.label.setValue(value);
    }

    public String getHelpSummaryHTML() {
        return (String)this.helpSummaryHTML.getValue();
    }

    public void setHelpSummaryHTML(String value) {
        this.helpSummaryHTML = this.helpSummaryHTML.setValue(value);
    }

    public String getHelpDetailsHTML() {
        return (String)this.helpDetailsHTML.getValue();
    }

    public void setHelpDetailsHTML(String value) {
        this.helpDetailsHTML = this.helpDetailsHTML.setValue(value);
    }

    public String getHelpHTML() {
        return (String)this.helpHTML.getValue();
    }

    public void setHelpHTML(String value) {
        this.helpHTML = this.helpHTML.setValue(value);
    }

    public boolean isRequiredSpecifiedInYaml() {
        return this.required.isSpecifiedInYaml();
    }

    public boolean isRequired() {
        return (Boolean)this.required.getValue();
    }

    public void setRequired(boolean value) {
        this.required = this.required.setValue(Boolean.valueOf(value));
    }

    public List<String> getOptionsSources() {
        return (List)this.optionsSources.getValue();
    }

    public void setOptionsSources(List<String> value) {
        this.optionsSources = this.optionsSources.setValue(value);
    }

    public void addOptionsSource(String value) {
        this.optionsSources = this.optionsSources.add((Object)value);
    }

    public boolean isAllowNullReference() {
        return (Boolean)this.allowNullReference.getValue();
    }

    public void setAllowNullReference(boolean value) {
        this.allowNullReference = this.allowNullReference.setValue(Boolean.valueOf(value));
    }

    public String getGetMethod() {
        return (String)this.getMethod.getValue();
    }

    public void setGetMethod(String value) {
        if (StringUtils.isEmpty((String)value) || CustomizerInvocationUtils.methodExists(value)) {
            this.getMethod = this.getMethod.setValue(value);
        }
    }

    public Path getGetMethodContainedBeanPath() {
        return this.getMethod.getContainedBeanPath();
    }

    public String getOptionsMethod() {
        return (String)this.optionsMethod.getValue();
    }

    public void setOptionsMethod(String value) {
        if (StringUtils.isEmpty((String)value) || CustomizerInvocationUtils.methodExists(value)) {
            this.optionsMethod = this.optionsMethod.setValue(value);
        }
    }

    public Path getOptionsMethodContainedBeanPath() {
        return this.optionsMethod.getContainedBeanPath();
    }

    public BeanFieldPresentationDefSource getPresentation() {
        return (BeanFieldPresentationDefSource)((Object)this.presentation.getValue());
    }

    public void setPresentation(BeanFieldPresentationDefSource value) {
        this.presentation = this.presentation.setValue((Object)value);
    }

    public boolean isUseUnlocalizedLegalValuesAsLabels() {
        return (Boolean)this.useUnlocalizedLegalValuesAsLabels.getValue();
    }

    public void setUseUnlocalizedLegalValuesAsLabels(boolean value) {
        this.useUnlocalizedLegalValuesAsLabels = this.useUnlocalizedLegalValuesAsLabels.setValue(Boolean.valueOf(value));
    }

    public List<LegalValueDefCustomizerSource> getLegalValues() {
        return (List)this.legalValues.getValue();
    }

    public void setLegalValues(List<LegalValueDefCustomizerSource> value) {
        this.legalValues = this.legalValues.setValue(value);
    }

    public void addLegalValue(LegalValueDefCustomizerSource value) {
        this.legalValues = this.legalValues.add((Object)value);
    }

    public String toString() {
        return this.getName();
    }

    protected void validateExtension() {
        super.validateExtension();
        this.validateExtensionChild(this.getPresentation(), "presentation");
        this.validateExtensionChildren(this.getLegalValues(), "legalValues");
        this.validateExtensionStringPropertyNotSpecified(this.getGetMethod(), "getMethod");
        this.validateExtensionStringPropertyNotSpecified(this.getOptionsMethod(), "optionsMethod");
    }
}

