/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef.schema;

import java.util.List;
import weblogic.console.schema.BooleanValue;
import weblogic.console.schema.ListValue;
import weblogic.console.schema.StringValue;
import weblogic.console.schema.Value;
import weblogic.console.schema.YamlSource;
import weblogic.console.schema.beaninfo.BeanActionDefSource;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.schema.ActionInputFormDefSource;
import weblogic.remoteconsole.common.repodef.schema.BeanActionParamDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.BeanActionPollingDefSource;
import weblogic.remoteconsole.common.repodef.schema.BeanValueDefCustomizerSource;
import weblogic.remoteconsole.common.repodef.schema.MBeanOperationDefSource;
import weblogic.remoteconsole.common.utils.CustomizerInvocationUtils;

public class BeanActionDefCustomizerSource
extends BeanValueDefCustomizerSource {
    private StringValue name = StringValue.create();
    private StringValue label = StringValue.create();
    private StringValue helpLabel = StringValue.create();
    private StringValue successMessage = StringValue.create();
    private StringValue failureMessage = StringValue.create();
    private StringValue helpSummaryHTML = StringValue.create();
    private StringValue helpDetailsHTML = StringValue.create();
    private StringValue helpHTML = StringValue.create();
    private StringValue actionMethod = StringValue.create();
    private Value<BeanActionDefSource> definition = Value.create();
    private Value<MBeanOperationDefSource> mbeanOperation = Value.create((Object)((Object)new MBeanOperationDefSource()));
    private Value<ActionInputFormDefSource> inputForm = Value.create();
    private ListValue<BeanActionParamDefCustomizerSource> parameters = ListValue.create();
    private Value<BeanActionPollingDefSource> polling = Value.create();
    private BooleanValue disableMBeanJavadoc = BooleanValue.create();

    public void merge(BeanActionDefCustomizerSource from, Path fromContainedBeanPath) {
        super.merge(from, fromContainedBeanPath);
        this.label = this.label.merge(from.label, fromContainedBeanPath);
        this.successMessage = this.successMessage.merge(from.successMessage, fromContainedBeanPath);
        this.failureMessage = this.failureMessage.merge(from.failureMessage, fromContainedBeanPath);
        this.helpLabel = this.helpLabel.merge(from.helpLabel, fromContainedBeanPath);
        this.actionMethod = this.actionMethod.merge(from.actionMethod, fromContainedBeanPath);
        this.definition = this.definition.merge(from.definition, fromContainedBeanPath);
        this.mbeanOperation = this.mbeanOperation.merge(from.mbeanOperation, fromContainedBeanPath);
        this.inputForm = this.inputForm.merge(from.inputForm, fromContainedBeanPath);
        this.polling = this.polling.merge(from.polling, fromContainedBeanPath);
        this.disableMBeanJavadoc = this.disableMBeanJavadoc.merge(from.disableMBeanJavadoc, fromContainedBeanPath);
        this.mergeHelp(from, fromContainedBeanPath);
        this.mergeParameters(from, fromContainedBeanPath);
    }

    private void mergeHelp(BeanActionDefCustomizerSource from, Path fromContainedBeanPath) {
        if (from.helpHTML.isSpecifiedInYaml() || from.helpSummaryHTML.isSpecifiedInYaml() || from.helpDetailsHTML.isSpecifiedInYaml()) {
            this.helpSummaryHTML = this.helpSummaryHTML.copyFrom(from.helpSummaryHTML, fromContainedBeanPath);
            this.helpDetailsHTML = this.helpDetailsHTML.copyFrom(from.helpDetailsHTML, fromContainedBeanPath);
            this.helpHTML = this.helpHTML.copyFrom(from.helpHTML, fromContainedBeanPath);
        }
    }

    private void mergeParameters(BeanActionDefCustomizerSource from, Path fromContainedBeanPath) {
        for (BeanActionParamDefCustomizerSource fromParam : from.getParameters()) {
            BeanActionParamDefCustomizerSource toParam = this.findOrCreateActionParamDef(fromParam.getName());
            toParam.merge(fromParam, fromContainedBeanPath);
        }
    }

    private BeanActionParamDefCustomizerSource findOrCreateActionParamDef(String name) {
        for (BeanActionParamDefCustomizerSource param : this.getParameters()) {
            if (!name.equals(param.getName())) continue;
            return param;
        }
        BeanActionParamDefCustomizerSource newParam = new BeanActionParamDefCustomizerSource();
        newParam.setName(name);
        this.addParameter(newParam);
        return newParam;
    }

    public String getName() {
        return (String)this.name.getValue();
    }

    public void setName(String value) {
        this.name = this.name.setValue(value);
    }

    public String getLabel() {
        return (String)this.label.getValue();
    }

    public void setLabel(String value) {
        this.label = this.label.setValue(value);
    }

    public String getHelpLabel() {
        return (String)this.helpLabel.getValue();
    }

    public void setHelpLabel(String value) {
        this.helpLabel = this.helpLabel.setValue(value);
    }

    public String getSuccessMessage() {
        return (String)this.successMessage.getValue();
    }

    public void setSuccessMessage(String value) {
        this.successMessage = this.successMessage.setValue(value);
    }

    public String getFailureMessage() {
        return (String)this.failureMessage.getValue();
    }

    public void setFailureMessage(String value) {
        this.failureMessage = this.failureMessage.setValue(value);
    }

    public String getHelpSummaryHTML() {
        return (String)this.helpSummaryHTML.getValue();
    }

    public void setHelpSummaryHTML(String value) {
        this.helpSummaryHTML = this.helpSummaryHTML.setValue(value);
    }

    public String getHelpDetailsHTML() {
        return (String)this.helpDetailsHTML.getValue();
    }

    public void setHelpDetailsHTML(String value) {
        this.helpDetailsHTML = this.helpDetailsHTML.setValue(value);
    }

    public String getHelpHTML() {
        return (String)this.helpHTML.getValue();
    }

    public void setHelpHTML(String value) {
        this.helpHTML = this.helpHTML.setValue(value);
    }

    public String getActionMethod() {
        return (String)this.actionMethod.getValue();
    }

    public void setActionMethod(String value) {
        if (StringUtils.isEmpty((String)value) || CustomizerInvocationUtils.methodExists(value)) {
            this.actionMethod = this.actionMethod.setValue(value);
        }
    }

    public BeanActionDefSource getDefinition() {
        return (BeanActionDefSource)this.definition.getValue();
    }

    public void setDefinition(BeanActionDefSource value) {
        this.definition = this.definition.setValue((Object)value);
    }

    public MBeanOperationDefSource getMbeanOperation() {
        return (MBeanOperationDefSource)((Object)this.mbeanOperation.getValue());
    }

    public void setMbeanOperation(MBeanOperationDefSource value) {
        this.mbeanOperation = this.mbeanOperation.setValue((Object)value);
    }

    public ActionInputFormDefSource getInputForm() {
        return (ActionInputFormDefSource)((Object)this.inputForm.getValue());
    }

    public void setInputForm(ActionInputFormDefSource value) {
        this.inputForm = this.inputForm.setValue((Object)value);
    }

    public List<BeanActionParamDefCustomizerSource> getParameters() {
        return (List)this.parameters.getValue();
    }

    public void setParameters(List<BeanActionParamDefCustomizerSource> value) {
        this.parameters = this.parameters.setValue(value);
    }

    public void addParameter(BeanActionParamDefCustomizerSource value) {
        this.parameters = this.parameters.add((Object)value);
    }

    public BeanActionPollingDefSource getPolling() {
        return (BeanActionPollingDefSource)((Object)this.polling.getValue());
    }

    public void setPolling(BeanActionPollingDefSource value) {
        this.polling = this.polling.setValue((Object)value);
    }

    public boolean isDisableMBeanJavadoc() {
        return (Boolean)this.disableMBeanJavadoc.getValue();
    }

    public void setDisableMBeanJavadoc(boolean value) {
        this.disableMBeanJavadoc = this.disableMBeanJavadoc.setValue(Boolean.valueOf(value));
    }

    public String toString() {
        return this.getName();
    }

    protected void validateExtension() {
        super.validateExtension();
        this.validateExtensionChild((YamlSource)this.getDefinition(), "definition");
        this.validateExtensionChild(this.getMbeanOperation(), "mbeanOperation");
        this.validateExtensionChild(this.getInputForm(), "inputForm");
        this.validateExtensionChild(this.getPolling(), "polling");
        this.validateExtensionChildren(this.getParameters(), "parameters");
        this.validateExtensionStringPropertyNotSpecified(this.getActionMethod(), "actionMethod");
    }
}

