/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef;

import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.ActionInputFormPagePath;
import weblogic.remoteconsole.common.repodef.CreateFormPagePath;
import weblogic.remoteconsole.common.repodef.PagesPath;
import weblogic.remoteconsole.common.repodef.SlicePagePath;
import weblogic.remoteconsole.common.repodef.TablePagePath;

public abstract class PagePath {
    private PagesPath pagesPath;
    private String key;

    protected PagePath(PagesPath pagesPath) {
        this.pagesPath = pagesPath;
    }

    public PagesPath getPagesPath() {
        return this.pagesPath;
    }

    public String getKey() {
        if (this.key == null) {
            this.key = this.computeKey();
        }
        return this.key;
    }

    public static TablePagePath newTablePagePath(PagesPath pagesPath) {
        return new TablePagePath(pagesPath);
    }

    public static SlicePagePath newSlicePagePath(PagesPath pagesPath, Path slicePath) {
        return new SlicePagePath(pagesPath, slicePath);
    }

    public static CreateFormPagePath newCreateFormPagePath(PagesPath pagesPath) {
        return new CreateFormPagePath(pagesPath);
    }

    public static ActionInputFormPagePath newActionInputFormPagePath(PagePath pagePath, String action) {
        return new ActionInputFormPagePath(pagePath, action);
    }

    public String getPDJQueryParams() {
        return "";
    }

    public String getRDJQueryParams() {
        return "";
    }

    public String getPDJUri() {
        return this.getPagesPath().getTypeDef().getTypeName() + this.getPDJQueryParams();
    }

    public boolean isTablePagePath() {
        return this instanceof TablePagePath;
    }

    public TablePagePath asTablePagePath() {
        return (TablePagePath)this;
    }

    public boolean isSlicePagePath() {
        return this instanceof SlicePagePath;
    }

    public SlicePagePath asSlicePagePath() {
        return (SlicePagePath)this;
    }

    public boolean isCreateFormPagePath() {
        return this instanceof CreateFormPagePath;
    }

    public CreateFormPagePath asCreateFormPagePath() {
        return (CreateFormPagePath)this;
    }

    public boolean isActionInputFormPagePath() {
        return this instanceof ActionInputFormPagePath;
    }

    public ActionInputFormPagePath asActionInputFormPagePath() {
        return (ActionInputFormPagePath)this;
    }

    public String toString() {
        return this.getKey();
    }

    public String computeKey() {
        return this.getPagesPath().getKey();
    }
}

