/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanChildNavTreeNodeDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.GroupNavTreeNodeDef;
import weblogic.remoteconsole.common.repodef.LinkDef;
import weblogic.remoteconsole.common.repodef.LinksDef;
import weblogic.remoteconsole.common.repodef.NavTreeDef;
import weblogic.remoteconsole.common.repodef.NavTreeNodeDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.PageRepoDef;
import weblogic.remoteconsole.common.repodef.SliceDef;
import weblogic.remoteconsole.common.repodef.SlicesDef;

public abstract class PageDefWalker {
    private PageRepoDef pageRepoDef;
    private Set<String> visitedTypeNames = new HashSet<String>();

    private PageRepoDef getPageRepoDef() {
        return this.pageRepoDef;
    }

    private Set<String> getVisitedTypeNames() {
        return this.visitedTypeNames;
    }

    protected void processPageDef(PageDef def) {
    }

    protected void processTypeDef(BeanTypeDef def) {
    }

    protected void processSlicesDef(SlicesDef def) {
    }

    protected void processSliceDef(SliceDef def) {
    }

    protected void processNavTreeDef(NavTreeDef def) {
    }

    protected void processNavTreeNodeDef(NavTreeNodeDef def) {
    }

    protected void processGroupNavTreeNodeDef(GroupNavTreeNodeDef def) {
    }

    protected void processChildNavTreeNodeDef(BeanChildNavTreeNodeDef def) {
    }

    protected void processLinksDef(LinksDef def) {
    }

    protected void processLinkDef(LinkDef def) {
    }

    protected void walk(PageRepoDef pageRepoDef) {
        this.pageRepoDef = pageRepoDef;
        this.getVisitedTypeNames().clear();
        this.walkNavTreeDef(this.getPageRepoDef().getRootNavTreeDef());
        this.walkTypeDef(this.getPageRepoDef().getBeanRepoDef().getRootTypeDef());
    }

    protected void walkTypeDef(BeanTypeDef typeDef) {
        String typeName = typeDef.getTypeName();
        if (this.getVisitedTypeNames().contains(typeName)) {
            return;
        }
        this.getVisitedTypeNames().add(typeName);
        this.processTypeDef(typeDef);
        this.walkNavTreeDef(this.getPageRepoDef().getNavTreeDef(typeDef));
        this.walkSlicesDef(this.getPageRepoDef().getSlicesDef(typeDef));
        this.walkLinksDef(this.getPageRepoDef().getLinksDef(typeDef));
        this.walkPageDef(this.getPageRepoDef().newTablePagePath(typeDef));
        this.walkPageDef(this.getPageRepoDef().newCreateFormPagePath(typeDef));
        this.walkProperties(typeDef);
        this.walkChildren(typeDef);
        this.walkSubTypes(typeDef);
    }

    protected void walkProperties(BeanTypeDef typeDef) {
        for (BeanPropertyDef propertyDef : typeDef.getPropertyDefs()) {
            this.walkChildTypeDef(typeDef, propertyDef.getParentPath());
        }
    }

    protected void walkChildren(BeanTypeDef typeDef) {
        for (BeanChildDef childDef : typeDef.getChildDefs()) {
            this.walkChildTypeDef(typeDef, childDef.getParentPath());
        }
    }

    protected void walkChildTypeDef(BeanTypeDef parentTypeDef, Path childPath) {
        if (!childPath.isEmpty()) {
            this.walkTypeDef(parentTypeDef.getChildDef(childPath).getChildTypeDef());
        }
    }

    protected void walkNavTreeDef(NavTreeDef navTreeDef) {
        if (navTreeDef == null) {
            return;
        }
        this.processNavTreeDef(navTreeDef);
        for (NavTreeNodeDef nodeDef : navTreeDef.getContentDefs()) {
            this.walkNavTreeNodeDef(nodeDef);
        }
    }

    protected void walkNavTreeNodeDef(NavTreeNodeDef nodeDef) {
        this.processNavTreeNodeDef(nodeDef);
        if (nodeDef.isGroupNodeDef()) {
            this.walkGroupNodeDef(nodeDef.asGroupNodeDef());
        } else if (nodeDef.isChildNodeDef()) {
            this.walkChildNodeDef(nodeDef.asChildNodeDef());
        }
    }

    protected void walkGroupNodeDef(GroupNavTreeNodeDef groupNodeDef) {
        this.processGroupNavTreeNodeDef(groupNodeDef);
        for (NavTreeNodeDef nodeDef : groupNodeDef.getContentDefs()) {
            this.walkNavTreeNodeDef(nodeDef);
        }
    }

    protected void walkChildNodeDef(BeanChildNavTreeNodeDef childNodeDef) {
        this.processChildNavTreeNodeDef(childNodeDef);
        this.walkTypeDef(childNodeDef.getLastChildDef().getChildTypeDef());
    }

    protected void walkSlicesDef(SlicesDef slicesDef) {
        if (slicesDef != null) {
            this.processSlicesDef(slicesDef);
            this.walkSliceDefs(slicesDef.getContentDefs());
        }
    }

    protected void walkSliceDefs(List<SliceDef> contentDefs) {
        for (SliceDef sliceDef : contentDefs) {
            this.walkSliceDef(sliceDef);
        }
    }

    protected void walkSliceDef(SliceDef sliceDef) {
        this.processSliceDef(sliceDef);
        List<SliceDef> contentDefs = sliceDef.getContentDefs();
        if (contentDefs.isEmpty()) {
            this.walkPageDef(this.getPageRepoDef().newSlicePagePath(sliceDef.getSlicesDef().getTypeDef(), sliceDef.getPath()));
        } else {
            this.walkSliceDefs(contentDefs);
        }
    }

    protected void walkLinksDef(LinksDef linksDef) {
        if (linksDef != null) {
            this.processLinksDef(linksDef);
            this.walkLinkDefs(linksDef.getInstanceLinkDefs());
            this.walkLinkDefs(linksDef.getCollectionLinkDefs());
        }
    }

    protected void walkLinkDefs(List<LinkDef> linkDefs) {
        for (LinkDef linkDef : linkDefs) {
            this.processLinkDef(linkDef);
        }
    }

    protected void walkSubTypes(BeanTypeDef typeDef) {
        if (typeDef.isHomogeneous()) {
            return;
        }
        for (BeanTypeDef subTypeDef : typeDef.getSubTypeDefs()) {
            this.walkTypeDef(subTypeDef);
        }
    }

    protected void walkPageDef(PagePath pagePath) {
        PageDef pageDef = this.getPageRepoDef().getPageDef(pagePath);
        if (pageDef != null) {
            this.processPageDef(pageDef);
        }
    }
}

