/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.utils.SupportedLocales;

public class Localizer {
    private Locale locale;
    private ResourceBundle resourceBundle;
    private static final String DISPLAYED_DATE_TIME_FORMAT = "EEE MMM dd kk:mm:ss z yyyy";

    public Localizer(String resourceBundleName, List<Locale> locales) {
        this(resourceBundleName, SupportedLocales.getFirstSupportedAcceptLocale(locales));
    }

    public Localizer(String resourceBundleName, Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.resourceBundle = ResourceBundle.getBundle(resourceBundleName, this.locale, Thread.currentThread().getContextClassLoader());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String formatDate(Date date) {
        return date != null ? new SimpleDateFormat(DISPLAYED_DATE_TIME_FORMAT).format(date) : "";
    }

    public String localizeString(LocalizableString localizableString, Object ... args) {
        String pattern = this.getPattern(localizableString);
        if (StringUtils.isEmpty((String)pattern) || args.length < 1) {
            return pattern;
        }
        return MessageFormat.format(pattern, args);
    }

    private String getPattern(LocalizableString localizableString) {
        if (localizableString == null) {
            return "";
        }
        String english = localizableString.getEnglishText(new Object[0]);
        if (StringUtils.isEmpty((String)english)) {
            return "";
        }
        if (localizableString.isUnlocalized()) {
            return english;
        }
        String key = localizableString.getResourceBundleKey();
        if (!this.resourceBundle.containsKey(key)) {
            return english;
        }
        String translated = this.resourceBundle.getString(key);
        return translated;
    }
}

