/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef;

import java.util.ArrayList;
import java.util.List;
import weblogic.remoteconsole.common.repodef.LocalizableString;

public class LocalizedConstants {
    private static List<LocalizableString> allConstants = new ArrayList<LocalizableString>();
    public static final LocalizableString INVALID_PORT = LocalizedConstants.addConstant("invalidPort", "Invalid port (must be an integer): {0}");
    public static final LocalizableString INVALID_GRID_LINK_LISTENER = LocalizedConstants.addConstant("invalidGridLinkListener", "Invalid listener (must be host:port): {0}");
    public static final LocalizableString BAD_PATH_GOOD_CONNECTION = LocalizedConstants.addConstant("badPathOnGoodConnection", "There is a server at this address, but the end point doesn't seem to be correct.");
    public static final LocalizableString TAKE_OFF_THE_SLASH_MANAGEMENT = LocalizedConstants.addConstant("takeOffSlashManagement", "most likely the /management part is not needed in the URL");
    public static final LocalizableString TAKE_OFF_THE_SLASH_CONSOLE = LocalizedConstants.addConstant("takeOffSlashConsole", "most likely the /console part is not needed in the URL");
    public static final LocalizableString USE_ADMIN_PORT = LocalizedConstants.addConstant("useAdminPort", "most likely the port should be set to the domain's administration port (which defaults to 9002)");
    public static final LocalizableString WEBLOGIC_REST_DELEGATION_NOT_WORKING_MESSAGE = LocalizedConstants.addConstant("weblogicRestDelegationNotWorkingMessage", "The domain is experiencing REST communication issues between servers.");
    public static final LocalizableString SUGGEST_RESTART_SERVER_MESSAGE = LocalizedConstants.addConstant("suggestRestartServerMessage", "A restart of the administration server may resolve communication errors.");
    public static final LocalizableString WEBLOGIC_REST_DELEGATION_NOT_WORKING_LINK = LocalizedConstants.addConstant("weblogicRestDelegationNotWorkingLink", "Troubleshoot");
    public static final LocalizableString WEBLOGIC_REST_DELEGATION_NOT_WORKING_DETAILS_LABEL = LocalizedConstants.addConstant("weblogicRestDelegationNotWorkingDetailsLabel", "Details");
    public static final LocalizableString UNSUPPORTED_DOMAIN_VERSION = LocalizedConstants.addConstant("unsupportedDomainVersion", "Unsupported WebLogic domain version");
    public static final LocalizableString DELETE_REFERENCES_FIRST = LocalizedConstants.addConstant("deleteReferencesFirst", "We recommend that you remove references to an object before you delete it.");
    public static final LocalizableString MBEAN_INFO_TITLE = LocalizedConstants.addConstant("mbeanInfoTitle", "MBean Info");
    public static final LocalizableString BEAN_ALREADY_EXISTS = LocalizedConstants.addConstant("beanAlreadyExists", "Already exists: {0}");
    public static final LocalizableString NULL_REFERENCE = LocalizedConstants.addConstant("nullReference", "None");
    public static final LocalizableString REFER_TO_LOGS = LocalizedConstants.addConstant("referToLogs", "The cause of the failure is unavailable.  The WebLogic Remote Console and the admin server logs may have more information.");
    public static final LocalizableString REQUIRED_PROPERTY_NOT_SPECIFIED = LocalizedConstants.addConstant("requiredPropertyNotSpecified", "Required property not specified: {0}");
    public static final LocalizableString EDIT_LABEL = LocalizedConstants.addConstant("label.edit", "Edit Tree");
    public static final LocalizableString CONFIGURATION_LABEL = LocalizedConstants.addConstant("label.configuration", "Configuration View Tree");
    public static final LocalizableString COMPOSITE_CONFIGURATION_LABEL = LocalizedConstants.addConstant("label.compositeConfig", "Composite View Tree");
    public static final LocalizableString PROPERTY_LIST_CONFIGURATION_LABEL = LocalizedConstants.addConstant("label.propertyList", "Property List");
    public static final LocalizableString MONITORING_LABEL = LocalizedConstants.addConstant("label.monitoring", "Monitoring Tree");
    public static final LocalizableString SECURITY_DATA_LABEL = LocalizedConstants.addConstant("label.securityData", "Security Data Tree");
    public static final LocalizableString FILTERING_DASHBOARD_DEFAULT_DESCRIPTION = LocalizedConstants.addConstant("filteringDashboardDefaultDescription", "Displays all {0} instances in the domain matching this custom filtering dashboard's filters.</p>");
    public static final LocalizableString CUSTOM_FILTERING_DASHBOARD_TYPE_LABEL = LocalizedConstants.addConstant("label.customFilteringDashboardType", "Custom Filtering Dashboard");
    public static final LocalizableString BUILTIN_FILTERING_DASHBOARD_TYPE_LABEL = LocalizedConstants.addConstant("label.builtinFilteringDashboardType", "Builtin Filtering Dashboard");
    public static final LocalizableString NEW_CUSTOM_FILTERING_DASHBOARD_LABEL = LocalizedConstants.addConstant("label.newCustomFilteringDashboard", "New Dashboard");
    public static final LocalizableString UNSPECIFIED_CUSTOM_FILTERING_DASHBOARD_FILTERED_VALUE = LocalizedConstants.addConstant("label.unspecifiedCustomFilteringDashboardFilteredValue", "A value must be specified for {0}");
    public static final LocalizableString INVALID_MODEL_TOKEN = LocalizedConstants.addConstant("invalidModelToken", "Invalid model token: {0}");
    public static final LocalizableString NO_UNRESOLVED_REF = LocalizedConstants.addConstant("noUnresolvedRef", "Unresolved Reference value was not specified: {0}");
    public static final LocalizableString NO_REFS_VALUE = LocalizedConstants.addConstant("noRefsValue", "References value was not specified: {0}");
    public static final LocalizableString UNMAPPED_SECTION = LocalizedConstants.addConstant("unmappedSection", "Unmapped section for: {0}");
    public static final LocalizableString NO_MACHINES_DEF = LocalizedConstants.addConstant("noMachinesDef", "No Machines child definition: {0}");
    public static final LocalizableString KEY_VALUE_NOT_MAP = LocalizedConstants.addConstant("keyValueNotMap", "{0} is not a folder.");
    public static final LocalizableString VALUE_NOT_MAP = LocalizedConstants.addConstant("valueNotMap", "{0} is not a folder.");
    public static final LocalizableString MODEL_INVALID = LocalizedConstants.addConstant("modelInvalid", "Invalid WDT model.  It must contain at least one of the following top-level folders: {0}");
    public static final LocalizableString NO_SECURITY_VALIDATION_WARNINGS_LABEL = LocalizedConstants.addConstant("noSecurityValidationWarningsLabel", "No security warnings.");
    public static final LocalizableString HAVE_SECURITY_VALIDATION_WARNINGS_LABEL = LocalizedConstants.addConstant("haveSecurityValidationWarningsLabel", "Security warnings detected.");
    public static final LocalizableString SECURITY_VALIDATION_WARNINGS_LINK_LABEL = LocalizedConstants.addConstant("securityValidationWarningsLinkLabel", "View/Refresh Report");
    public static final LocalizableString NEED_SERVER_RESTART_LABEL = LocalizedConstants.addConstant("needServerRestartLabel", "One or more servers need to be restarted.");
    public static final LocalizableString SERVER_RESTART_LINK_LABEL = LocalizedConstants.addConstant("serverRestartLinkLabel", "View Servers");
    public static final LocalizableString PROPERTY_LIST_PROPERTIES = LocalizedConstants.addConstant("label.propertyList.properties", "Properties");
    public static final LocalizableString PROPERTY_LIST_HELP_TEXT = LocalizedConstants.addConstant("label.propertyList.helpText", "The set of properties contained in the property list file.");
    public static final LocalizableString EMPTY_SIMPLE_SEARCH_STRING = LocalizedConstants.addConstant("emptySimpleSearchString", "The search string must not be empty.");
    public static final LocalizableString ALREADY_EXISTS = LocalizedConstants.addConstant("alreadyExists", "{0} already exists.");
    public static final LocalizableString WDT_MODEL_TOKEN_NOT_SUPPORTED = LocalizedConstants.addConstant("wdtModelTokenNotSupported", "{0} does not support variables: {1}");
    public static final LocalizableString WDT_PROPERTY_VALUE_NOT_A_STRING = LocalizedConstants.addConstant("wdtPropertyValueNotAString", "The value of {0} is not a string: {1}");
    public static final LocalizableString WDT_PROPERTY_VALUE_NOT_A_BOOLEAN = LocalizedConstants.addConstant("wdtPropertyValueNotABoolean", "The value of {0} is not true or false: {1}");
    public static final LocalizableString WDT_PROPERTY_VALUE_NOT_AN_INT = LocalizedConstants.addConstant("wdtPropertyValueNotAnInt", "The value of {0} is not an int: {1}");
    public static final LocalizableString WDT_PROPERTY_VALUE_NOT_A_LONG = LocalizedConstants.addConstant("wdtPropertyValueNotALong", "The value of {0} is not a long: {1}");
    public static final LocalizableString WDT_PROPERTY_VALUE_NOT_A_DOUBLE = LocalizedConstants.addConstant("wdtPropertyValueNotADouble", "The value of {0} is not a double: {1}");
    public static final LocalizableString WDT_PROPERTY_VALUE_NOT_PROPERTIES = LocalizedConstants.addConstant("wdtPropertyValueNotProperties", "The value of {0} is not a set of properties: {1}");
    public static final LocalizableString WDT_INVALID_SECURITY_PROVIDER_TYPE = LocalizedConstants.addConstant("wdtInvalidSecurityProviderType", "{0} is not a valid security provider type.");
    public static final LocalizableString WDT_INVALID_SECTION = LocalizedConstants.addConstant("wdtInvalidSection", "{0} is not a valid top-level folder. It must be one of: {1}");
    public static final LocalizableString WDT_INVALID_CHILD = LocalizedConstants.addConstant("wdtInvalidChild", "{0} is not a valid folder.");
    public static final LocalizableString WDT_INVALID_PROPERTY = LocalizedConstants.addConstant("wdtInvalidProperty", "{0} is not a valid attribute.");
    public static final LocalizableString UNLABELED_PROPERTY = LocalizedConstants.addConstant("unlabeledProperty", " ");
    public static final LocalizableString DOWNLOADLOGFILE_ERROR = LocalizedConstants.addConstant("downloadLogFileError", "Error in creating log file: ");
    public static final LocalizableString NO_JMS_MESSAGES = LocalizedConstants.addConstant("noUnfilteredJmsMessages", "<p>This destination has no messages.</p>");
    public static final LocalizableString ALL_UNFILTERED_JMS_MESSAGES = LocalizedConstants.addConstant("allUnfilteredJmsMessages", "<p>This unfiltered table displays all {0} messages in this destination.</p>");
    public static final LocalizableString SOME_UNFILTERED_JMS_MESSAGES = LocalizedConstants.addConstant("someUnfilteredJmsMessages", "<p>This destination has {0} messages. This unfiltered table displays the first {1} sorted messages.</p><ul><li>Sorted on: {2}</li><li>Ascending: {3}</li></ul>");
    public static final LocalizableString NO_FILTERED_JMS_MESSAGES = LocalizedConstants.addConstant("noFilteredJmsMessages", "<p>This destination has {0} messages. It does not have any matching messages.</p><ul><li>JMS message selector: {1}</li></ul>");
    public static final LocalizableString ALL_FILTERED_JMS_MESSAGES = LocalizedConstants.addConstant("allFilteredJmsMessages", "<p>This destination has {0} messages. This filtered table displays all {1} matching messages.</p><ul><li>JMS message selector: {2}</li></ul>");
    public static final LocalizableString SOME_FILTERED_JMS_MESSAGES = LocalizedConstants.addConstant("someFilteredJmsMessages", "<p>This destination has {0} messages. This filtered table lists the first {2} of {1} sorted matching messages.</p><ul><li>JMS message selector: {3}</li><li>Sorted on: {4}</li><li>Ascending: {5}</li></ul>");
    public static final LocalizableString TX_STATUS_ACTIVE = LocalizedConstants.addConstant("txStatusActive", "active");
    public static final LocalizableString TX_STATUS_PRE_PREPARING = LocalizedConstants.addConstant("txStatusPrePreparing", "pre-preparing");
    public static final LocalizableString TX_STATUS_PRE_PREPARED = LocalizedConstants.addConstant("txStatusPrePrepared", "pre-prepared");
    public static final LocalizableString TX_STATUS_PREPARING = LocalizedConstants.addConstant("txStatusPerparing", "preparing");
    public static final LocalizableString TX_STATUS_PREPARED = LocalizedConstants.addConstant("txStatusPrepared", "prepared");
    public static final LocalizableString TX_STATUS_LOGGING = LocalizedConstants.addConstant("txStatusLogging", "logging");
    public static final LocalizableString TX_STATUS_COMMITTING = LocalizedConstants.addConstant("txStatusCommitting", "committing");
    public static final LocalizableString TX_STATUS_COMMITTED = LocalizedConstants.addConstant("txStatusCommitted", "committed");
    public static final LocalizableString TX_STATUS_ROLLING_BACK = LocalizedConstants.addConstant("txStatusRollingBack", "rolling-back");
    public static final LocalizableString TX_STATUS_MARKED_ROLLBACK = LocalizedConstants.addConstant("txStatusMarkedRollback", "marked-rollback");
    public static final LocalizableString TX_STATUS_ROLLEDBACK = LocalizedConstants.addConstant("txStatusRolledback", "rolledback");
    public static final LocalizableString TX_STATUS_NEW = LocalizedConstants.addConstant("txStatusNew", "new");
    public static final LocalizableString TX_STATUS_SUSPENDED = LocalizedConstants.addConstant("txStatusSuspended", "suspended");
    public static final LocalizableString TX_STATUS_UNKNOWN = LocalizedConstants.addConstant("txStatusUnknown", "unknown");
    public static final LocalizableString MBEAN_EXTERNAL_HELP_INTRO_LABEL = LocalizedConstants.addConstant("mbeanExternalHelpIntroLabel", "MBean:");
    public static final LocalizableString MBEAN_ATTRIBUTE_EXTERNAL_HELP_INTRO_LABEL = LocalizedConstants.addConstant("mbeanPropertyExternalHelpIntroLabel", "MBean Attribute:");
    public static final LocalizableString MBEAN_OPERATION_EXTERNAL_HELP_INTRO_LABEL = LocalizedConstants.addConstant("mbeanOperationExternalHelpIntroLabel", "MBean Operation:");
    public static final LocalizableString UNLOCK_USER_SUCCESS = LocalizedConstants.addConstant("mbeanOperationUnlockUserSuccess", "The unlock user action completed successfully.");
    public static final LocalizableString SSO_TOKEN_UNAVAILABLE = LocalizedConstants.addConstant("ssoTokenUnavailable", "Unable to connect, token is unavailable.");
    public static final LocalizableString HEALTH_STATE_OK = LocalizedConstants.addConstant("healthStateOkay", "Okay");
    public static final LocalizableString HEALTH_STATE_WARN = LocalizedConstants.addConstant("healthStateWarn", "Warn");
    public static final LocalizableString HEALTH_STATE_CRITICAL = LocalizedConstants.addConstant("healthStateCritical", "Critical");
    public static final LocalizableString HEALTH_STATE_FAILED = LocalizedConstants.addConstant("healthStateFailed", "Failed");
    public static final LocalizableString HEALTH_STATE_OVERLOADED = LocalizedConstants.addConstant("healthStateOverloaded", "Overloaded");
    public static final LocalizableString HEALTH_STATE_UNKNOWN = LocalizedConstants.addConstant("healthStateUnknown", "Unknown");
    public static final LocalizableString VARIABLE_ASSIGNMENT_INTRO = LocalizedConstants.addConstant("variableAssignmentIntro", "<ul><li>Module : {0}</li><li>Descriptor : {1}</li><li>xpath : {2}</li><li>Variable : {3}</li></ul>");
    public static final LocalizableString APPLICATION_HAS_PLAN = LocalizedConstants.addConstant("applicationHasPlan", "The application ''{0}'' already has a deployment plan: ''{1}''");
    public static final LocalizableString APPLICATION_HAS_NO_PLAN = LocalizedConstants.addConstant("applicationHasNoPlan", "The application ''{0}'' does not have a deployment plan.");
    public static final LocalizableString REFER_TO_DEPLOYMENT_TASKS_DASHBOARD = LocalizedConstants.addConstant("referToDeploymentTasksDashboard", "Refer to Deployment Tasks dashboard for more information.");
    public static final LocalizableString DATA_PROVIDER_HELP_NAME_SUMMARY = LocalizedConstants.addConstant("dataProviderHelpNameSummary", "The name of the provider");
    public static final LocalizableString DATA_PROVIDER_HELP_NAME_DETAIL = LocalizedConstants.addConstant("dataProviderHelpNameDetail", "A provider name should be unique within a project.  It is not a functional field, but is used by the user to identify the connection");
    public static final LocalizableString ADMIN_SERVER_HELP_URL_SUMMARY = LocalizedConstants.addConstant("adminServerHelpURLSummary", "The URL of the Administration Server being targeted");
    public static final LocalizableString ADMIN_SERVER_HELP_URL_DETAIL = LocalizedConstants.addConstant("adminServerHelpURLDetail", "The URL of the Administration Server being targeted. Note that the context path is not part of this URL, as in https://adminserver.example.com:7002). The end point that is being reached is https://adminserver.example.com:7002/management, but the path part is automatically added by the Remote Console software");
    public static final LocalizableString ADMIN_SERVER_HELP_PROXY_SUMMARY = LocalizedConstants.addConstant("adminServerHelpProxySummary", "Allows the setting of a proxy server for this particular provider to use while connecting");
    public static final LocalizableString ADMIN_SERVER_HELP_PROXY_DETAIL = LocalizedConstants.addConstant("adminServerHelpProxyDetail", "Allows the setting of a proxy server for this particular provider to use while connecting. It is termed an 'override' because it takes precedence over any global settings for proxying. The format of the entry is either 'DIRECT' to not use a proxy at all or a URL (i.e. protocol://host:port - with no path), following the traditional standard for specifying a proxy server. The protocol portion can be http, https, socks, socks4 or socks5.");
    public static final LocalizableString ADMIN_SERVER_HELP_USERNAME_SUMMARY = LocalizedConstants.addConstant("adminServerHelpUserNameSummary", "The user id portion of the credential needed to log in to the Admin Server");
    public static final LocalizableString ADMIN_SERVER_HELP_USERNAME_DETAIL = LocalizedConstants.addConstant("adminServerHelpUserNameDetail", "The user id portion of the credential needed to log in to the Admin Server. Note that this assumes a 'BASIC AUTH' authentication scheme. The 'Single Sign-On' option allows one to use a different authentication mechanism.");
    public static final LocalizableString ADMIN_SERVER_HELP_PASSWORD_SUMMARY = LocalizedConstants.addConstant("adminServerHelpPasswordSummary", "The password portion of the credential needed to log in to the Admin Server");
    public static final LocalizableString ADMIN_SERVER_HELP_PASSWORD_DETAIL = LocalizedConstants.addConstant("adminServerHelpPasswordDetail", "The password portion of the credential needed to log in to the Admin Server. Note that this assumes a 'BASIC AUTH' authentication scheme. The 'Single Sign-On' option allows one to use a different authentication mechanism.");
    public static final LocalizableString ADMIN_SERVER_HELP_INSECURE_SUMMARY = LocalizedConstants.addConstant("adminServerHelpInsecureSummary", "Turn off certificate checking for this provider's connection");
    public static final LocalizableString ADMIN_SERVER_HELP_INSECURE_DETAIL = LocalizedConstants.addConstant("adminServerHelpInsecureDetail", "You can allow WebLogic Remote Console to connect to an Administration Server regardless of warnings about expired, untrusted, or missing certificates. We *strongly* recommend that you only enable this setting for development or demonstration environments.");
    public static final LocalizableString ADMIN_SERVER_HELP_SSO_SUMMARY = LocalizedConstants.addConstant("adminServerHelpSSOSummary", "Use an alternative authentication method, requires WebLogic 14.1.2.0.0 or greater");
    public static final LocalizableString ADMIN_SERVER_HELP_SSO_DETAIL = LocalizedConstants.addConstant("adminServerHelpSSODetail", "Sends users to the browser to complete the login process with an alternative authentication method such as Single Sign On. Supported with WebLogic Server 14.1.2.0.0 or greater.");
    public static final LocalizableString WDT_PROVIDER_HELP_FILE_SUMMARY = LocalizedConstants.addConstant("wdtProviderHelpFileSummary", "The path to a WebLogic Deploy Tooling model file");
    public static final LocalizableString WDT_PROVIDER_HELP_FILE_DETAIL = LocalizedConstants.addConstant("wdtProviderHelpFileDetail", "The path to a WebLogic Deploy Tooling model file");
    public static final LocalizableString PROPERTY_LIST_PROVIDER_HELP_FILE_SUMMARY = LocalizedConstants.addConstant("propertyListProviderHelpFileSummary", "The path to a property file");
    public static final LocalizableString PROPERTY_LIST_PROVIDER_HELP_FILE_DETAIL = LocalizedConstants.addConstant("propertyListProviderHelpFileDetail", "The path to a property file, as described in java.util.Properties");
    public static final LocalizableString WDT_COMPOSITE_PROVIDER_HELP_MODELS_SUMMARY = LocalizedConstants.addConstant("wdtCompositeProviderHelpModelsSummary", "A list of WebLogic Deploy Tooling model providers");
    public static final LocalizableString WDT_COMPOSITE_PROVIDER_HELP_MODELS_DETAIL = LocalizedConstants.addConstant("wdtCompositeProviderHelpModelsDetail", "A list of WebLogic Deploy Tooling model providers. These models will be combined to form a single model and assessed as such");
    public static final LocalizableString CANT_CONNECT_TO_ADMIN_SERVER = LocalizedConstants.addConstant("cantConnectToDomain", "Unable to connect to the WebLogic domain's administration server.");
    public static final LocalizableString CANT_SHUTDOWN_ADMIN_SERVER_AND_MANAGED_SERVERS = LocalizedConstants.addConstant("cantShutdownAdminServerAndManagedServers", "Shut down the managed servers then shut down the administration server.");
    public static final LocalizableString DATA_SOURCE_TEST_POOL_SUCCESS = LocalizedConstants.addConstant("dataSourceTestPoolSuccess", "The test of {0} on server {1} was successful.");
    public static final LocalizableString DATA_SOURCE_TEST_POOL_FAILURE = LocalizedConstants.addConstant("dataSourceTestPoolFailure", "The test of {0} on server {1} failed: {2}");
    public static final LocalizableString CUSTOM_HOSTNAME_VERIFIER_NOT_SPECIFIED = LocalizedConstants.addConstant("customHostnameVerifierNotSpecified", "Custom Hostname Verifier must be specified.");
    public static final LocalizableString CANNOT_DELETE_BUILTIN_DASHBOARD = LocalizedConstants.addConstant("cannotDeleteBuiltintDashboard", "Builtin dashboards cannot be deleted: ''{0}''");
    public static final LocalizableString CANNOT_MODIFY_BUILTIN_DASHBOARD = LocalizedConstants.addConstant("cannotModifyBuiltintDashboard", "Builtin dashboards cannot be modified: ''{0}''");
    public static final LocalizableString NODE_MANAGER_LOG_DOWNLOAD_LABEL = LocalizedConstants.addConstant("nodeManagerLogDownloadLabel", "Download");
    public static final LocalizableString NODE_MANAGER_LOG_DOWNLOAD_NOT_SUPPORTED = LocalizedConstants.addConstant("nodeManagerLogDownloadNotSupported", "Download Log not supported");
    public static final LocalizableString NODE_MANAGER_LOG_NOT_AVAILABLE_LABEL = LocalizedConstants.addConstant("nodeManagerLogNotAvailableLabel", "Not Available");
    public static final LocalizableString CONSOLE_REST_EXTENSION_NOT_INSTALLED = LocalizedConstants.addConstant("consoleRestExtensionNotInstalled", "not installed");
    public static final LocalizableString READONLY_DEPLOYMENT_CONFIGURATION_PAGE_INTRO = LocalizedConstants.addConstant("readOnlyDeploymentConfigurationPageIntro", "<p>Note: You cannot modify this deployment's configuration because the deployment does not have a deployment plan.</p>");
    public static final LocalizableString AUTODEPLOYED_DEPLOYMENT_CONFIGURATION_PAGE_INTRO = LocalizedConstants.addConstant("autoDeployedDeploymentConfigurationPageIntro", "<p>Note: You cannot modify this deployment's configuration because the deployment is auto-deployed.</p>");
    public static final LocalizableString WEBLOGIC_REST_REQUEST_TIMED_OUT = LocalizedConstants.addConstant("weblogicRESTRequestTimedOut", "A request to the WebLogic administration server timed out.  Increasing the WebLogic Remote Console's 'Administration Server Read Timeout' may help.");
    public static final LocalizableString LEGACY_TOO_MANY_USERS = LocalizedConstants.addConstant("legacyTooManyUsers", "<p>Note: There are more users than the WebLogic Remote Console supports. Only {0} are displayed.</p>");
    public static final LocalizableString LEGACY_TOO_MANY_GROUPS = LocalizedConstants.addConstant("legacyTooManyGroups", "<p>Note: There are more groups than the WebLogic Remote Console supports. Only {0} are displayed.</p>");
    public static final LocalizableString TOO_MANY_USERS = LocalizedConstants.addConstant("tooManyUsers", "<p>Some users are not displayed because there are too many matches. Please filter this table.</p>");
    public static final LocalizableString TOO_MANY_GROUPS = LocalizedConstants.addConstant("tooManyGroups", "<p>Some groups are not displayed because there are too many matches. Please filter this table.</p>");
    public static final LocalizableString USERS_FILTER = LocalizedConstants.addConstant("userFilter", "<p>Only users whose name matches the filter ''{0}'' are displayed.</p>");
    public static final LocalizableString GROUPS_FILTER = LocalizedConstants.addConstant("groupFilter", "<p>Only groups whose name matches the filter ''{0}'' are displayed.</p>");
    public static final LocalizableString CLONED_SERVER_NOT_ALL_SETTINGS_COPIED = LocalizedConstants.addConstant("clonedServerNotAllSettingsCopied", "Note: Sensitive settings for the Server such as the passwords and keys, have not been copied.");
    public static final LocalizableString DEFAULT_HOSTED_PROVIDER_NAME = LocalizedConstants.addConstant("thisServer", "This Server");
    public static final LocalizableString USER_GROUP_READER_STATUS_OK = LocalizedConstants.addConstant("userGroupReaderStatusOK", "OK");
    public static final LocalizableString SECURITY_PROVIDER_DATA_NOT_AVAILABLE = LocalizedConstants.addConstant("securityProviderDataNotAvailable", "<p>No data is available because:</p><p>{0}</p>");
    public static final LocalizableString MIGRATION_TARGET_NOT_FOUND = LocalizedConstants.addConstant("migratableTargetNotFound", "<p>Migratable Target does not exist.</p>");
    public static final LocalizableString NO_HOSTING_SERVER_FOR_MT = LocalizedConstants.addConstant("noHostingServerForMT", "<p>No server currently hosting the services on this migratable target.</p>");
    public static final LocalizableString REFER_TO_MIGRATION_TASKS = LocalizedConstants.addConstant("referToMigrationTask", "<p>Refer to migration task for more info.</p>");
    public static final LocalizableString NONE_CONFIGURED = LocalizedConstants.addConstant("noneConfigured", "None Configured");
    public static final LocalizableString EXPORT_SECURITY_DATA_CONSTRAINTS_INTRO = LocalizedConstants.addConstant("exportSecurityDataConstraintsIntro", "<p>This provider supports the following constraints: {0}. If no constraints are specified then all security data will be exported.</p>");
    public static final LocalizableString IMPORT_SECURITY_DATA_CONSTRAINTS_INTRO = LocalizedConstants.addConstant("importSecurityDataConstraintsIntro", "<p>This provider supports the following constraints: {0}. If no constraints are specified then all security data will be imported.</p>");
    public static final LocalizableString JDBC_XA_DRIVER_INCOMPATIBLE_GLOBAL_TRANSACTIONS_PROTOCOL = LocalizedConstants.addConstant("javaXADriverIncompatibleGlobalTransactionsProtocol", "<b>Warning</b>: This data source has an XA driver but its Global Transactions Protocol isn''t set to Two-Phase Commit.");
    public static final LocalizableString JDBC_NON_XA_DRIVER_INCOMPATIBLE_GLOBAL_TRANSACTIONS_PROTOCOL = LocalizedConstants.addConstant("javaNonXADriverIncompatibleGlobalTransactionsProtocol", "<b>Warning</b>: This data source has a non-XA driver but its Global Transactions Protocol is set to Two-Phase Commit.");
    public static final LocalizableString JMS_CANNOT_VIEW_MESSAGE_BODY_BECAUSE_WRONG_TYPE = LocalizedConstants.addConstant("jmsCannotViewMessageBodyBecauseWrongType", "<p>The message body for ''{0}'' cannot be viewed because it isn''t a text or xml message.</p><p><b>Note</b>: Consider exporting the message to a file.</p>");
    public static final LocalizableString JMS_CANNOT_VIEW_MESSAGE_BODY_BECAUSE_TOO_BIG = LocalizedConstants.addConstant("jmsCannotViewMessageBodyBecauseTooBig", "<p>The message body for ''{0}'' cannot be viewed because it''s too big.</p><p><b>Note</b>: You can view the message body by exporting the message to a file.</p>");
    public static final LocalizableString JMS_DISPLAYED_TRIMMED_MESSAGE_BODY = LocalizedConstants.addConstant("jmsDisplayedTrimmedMessageBody", "<p>This page displays the beginning of the message body for ''{0}''.</p><p><b>Note</b>: You can view the full message body by exporting the message to a file.</p>");
    public static final LocalizableString JMS_DISPLAYED_MESSAGE_BODY = LocalizedConstants.addConstant("jmsDisplayedMessageBody", "<p>This page displays the message body for ''{0}''.</p>");

    private LocalizedConstants() {
    }

    public static List<LocalizableString> getAllConstants() {
        return allConstants;
    }

    private static LocalizableString addConstant(String constantKey, String englishText) {
        LocalizableString ls = new LocalizableString("constant." + constantKey, englishText);
        allConstants.add(ls);
        return ls;
    }
}

