/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import weblogic.remoteconsole.common.repodef.LocalizableString;

public class LocalizedConsoleRestExtensionConstants {
    public static final String KEY_PREFIX = "consoleRestExtension.";
    private static Map<String, LocalizableString> allConstants = new HashMap<String, LocalizableString>();

    private LocalizedConsoleRestExtensionConstants() {
    }

    public static LocalizableString findConstant(String constantKey) {
        return allConstants.get(constantKey);
    }

    public static Collection<LocalizableString> getAllConstants() {
        return allConstants.values();
    }

    private static void addConstant(String relativeConstantKey, String englishText) {
        LocalizableString ls = new LocalizableString(KEY_PREFIX + relativeConstantKey, englishText);
        allConstants.put(ls.getResourceBundleKey(), ls);
    }

    static {
        LocalizedConsoleRestExtensionConstants.addConstant("requiredPropertyNotSpecified", "Required property not specified: {0}");
        LocalizedConsoleRestExtensionConstants.addConstant("alreadyExists", "Already exists: {0}");
        LocalizedConsoleRestExtensionConstants.addConstant("userPasswordCredentialNotFound", "There is no credential configured for the remote user {0}.");
        LocalizedConsoleRestExtensionConstants.addConstant("userPasswordCredentialNotDeletableBecauseUsed", "This credential cannot be removed because it is used by {0}.");
        LocalizedConsoleRestExtensionConstants.addConstant("userPasswordResourceNotDeletableBecauseMultipleMappings", "This resource cannot be removed because it contains more than one credential mapping.");
        LocalizedConsoleRestExtensionConstants.addConstant("invalidPredicateArgumentValue", "Predicate: ''{0}'', Argument: ''{1}'', Error : ''{3}''");
        LocalizedConsoleRestExtensionConstants.addConstant("applicationHasPlan", "The application ''{0}'' already has a deployment plan.");
        LocalizedConsoleRestExtensionConstants.addConstant("applicationHasNoPlan", "The application ''{0}'' does not have a deployment plan.");
        LocalizedConsoleRestExtensionConstants.addConstant("planPathNotXml", "The plan path ''{0}'' must end in ''.xml''.");
        LocalizedConsoleRestExtensionConstants.addConstant("planPathNotUnderDomainRoot", "The plan path ''{0}'' must be under domain home:  ''{1}''");
        LocalizedConsoleRestExtensionConstants.addConstant("planPathIsADirectory", "The plan path ''{0}'' is a directory.  Specify a file name ended with .xml ");
        LocalizedConsoleRestExtensionConstants.addConstant("planPathAlreadyExists", "The plan path ''{0}'' already exists.  Overwriting an existing file is not allowed.");
        LocalizedConsoleRestExtensionConstants.addConstant("stageModeNotSupported", "This deployment cannot be redeployed because its staging mode is ''{0}''.  Remove and add it instead.");
        LocalizedConsoleRestExtensionConstants.addConstant("libraryRedeployNotSupported", "The library ''{0}'' cannot be redeployed because its source is not under the administration server's upload directory.  Remove and add it instead.");
        LocalizedConsoleRestExtensionConstants.addConstant("descriptorBeanNotRemovable", "''{0}'' cannot be removed because it is defined in the application''s deployment descriptors.");
        LocalizedConsoleRestExtensionConstants.addConstant("testDataSourceConfigurationSucceeded", "Successfully connected to this data source's database from the WebLogic domain's Administration Server.");
        LocalizedConsoleRestExtensionConstants.addConstant("testDataSourceConfigurationFailed", "Could not connect to this data source's database from the WebLogic domain's Administration Server.");
    }
}

