/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef;

import java.text.MessageFormat;
import weblogic.console.utils.StringUtils;

public class LocalizableString {
    private String resourceBundleKey;
    private String englishText;
    private static final String UNLOCALIZED_RESOURCE_BUNDLE_KEY_PREFIX = "unlocalized.";
    public static final LocalizableString NULL = new LocalizableString(null, null);

    public LocalizableString(String unlocalizedText) {
        this(UNLOCALIZED_RESOURCE_BUNDLE_KEY_PREFIX + unlocalizedText, unlocalizedText);
    }

    public LocalizableString(String resourceBundleKey, String englishText) {
        this.resourceBundleKey = resourceBundleKey;
        this.englishText = englishText;
    }

    public static boolean isUnlocalized(String resourceBundleKey) {
        return resourceBundleKey.startsWith(UNLOCALIZED_RESOURCE_BUNDLE_KEY_PREFIX);
    }

    public boolean isUnlocalized() {
        if (NULL == this) {
            return false;
        }
        return LocalizableString.isUnlocalized(this.getResourceBundleKey());
    }

    public String getResourceBundleKey() {
        return this.resourceBundleKey;
    }

    public String getEnglishText(Object ... args) {
        if (args.length == 0) {
            return this.englishText;
        }
        return MessageFormat.format(this.englishText, args);
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((String)this.getEnglishText(new Object[0]));
    }

    public String toString() {
        return "LocalizableString<key=" + this.getResourceBundleKey() + ", english=" + this.getEnglishText(new Object[0]) + ">";
    }
}

