/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef;

import java.util.ArrayList;
import java.util.List;
import weblogic.remoteconsole.common.repodef.FormDef;
import weblogic.remoteconsole.common.repodef.FormSectionUsedIfDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;

public interface FormSectionDef {
    public FormDef getFormDef();

    public LocalizableString getTitle();

    public LocalizableString getIntroductionHTML();

    public FormSectionUsedIfDef getUsedIfDef();

    public List<PagePropertyDef> getPropertyDefs();

    default public List<PagePropertyDef> getAllPropertyDefs() {
        if (this.getSectionDefs().isEmpty()) {
            return this.getPropertyDefs();
        }
        ArrayList<PagePropertyDef> ret = new ArrayList<PagePropertyDef>();
        for (FormSectionDef section : this.getSectionDefs()) {
            ret.addAll(section.getAllPropertyDefs());
        }
        return ret;
    }

    public List<FormSectionDef> getSectionDefs();

    default public List<FormSectionDef> getAllSectionDefs() {
        if (this.getSectionDefs().isEmpty()) {
            return List.of();
        }
        ArrayList<FormSectionDef> allDefs = new ArrayList<FormSectionDef>();
        FormSectionDef.addSectionDefs(allDefs, this.getSectionDefs());
        return allDefs;
    }

    private static void addSectionDefs(List<FormSectionDef> allDefs, List<FormSectionDef> sectionDefs) {
        allDefs.addAll(sectionDefs);
        for (FormSectionDef sectionDef : sectionDefs) {
            FormSectionDef.addSectionDefs(allDefs, sectionDef.getSectionDefs());
        }
    }
}

