/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef;

import java.util.ArrayList;
import java.util.List;
import weblogic.remoteconsole.common.repodef.CustomPageDef;
import weblogic.remoteconsole.common.repodef.HelpTopicDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.SliceTableDef;
import weblogic.remoteconsole.common.utils.ListUtils;

public class CustomSliceTableDef
implements SliceTableDef {
    private CustomPageDef pageDef = new CustomPageDef();
    private boolean setReadOnly = false;
    private boolean readOnly;
    private List<PagePropertyDef> displayedColumnDefs = new ArrayList<PagePropertyDef>();
    private List<PagePropertyDef> hiddenColumnDefs = new ArrayList<PagePropertyDef>();
    private List<PagePropertyDef> allPropertyDefs = new ArrayList<PagePropertyDef>();
    private String getTableRowsMethod;
    private boolean supportsNavigation;
    private boolean useRowIdentities;

    public CustomSliceTableDef() {
    }

    public CustomSliceTableDef(SliceTableDef toClone) {
        this.pageDef = new CustomPageDef(toClone);
        this.readOnly = toClone.isReadOnly();
        this.getDisplayedColumnDefs().addAll(ListUtils.nonNull(toClone.getDisplayedColumnDefs()));
        this.getHiddenColumnDefs().addAll(ListUtils.nonNull(toClone.getHiddenColumnDefs()));
        this.computeAllPropertyDefs();
        this.setGetTableRowsMethod(toClone.getGetTableRowsMethod());
        this.setUseRowIdentities(toClone.isUseRowIdentities());
    }

    @Override
    public boolean isReadOnly() {
        if (this.setReadOnly) {
            return this.readOnly;
        }
        for (PagePropertyDef propertyDef : this.getAllPropertyDefs()) {
            if (!propertyDef.isUpdateWritable()) continue;
            return false;
        }
        return true;
    }

    public void setReadOnly(boolean val) {
        this.readOnly = val;
        this.setReadOnly = true;
    }

    public CustomSliceTableDef readOnly(boolean val) {
        this.setReadOnly(val);
        return this;
    }

    @Override
    public List<PagePropertyDef> getDisplayedColumnDefs() {
        return this.displayedColumnDefs;
    }

    public void setDisplayedColumnDefs(List<PagePropertyDef> val) {
        this.displayedColumnDefs = val;
        this.computeAllPropertyDefs();
    }

    public CustomSliceTableDef displayedColumnDefs(List<PagePropertyDef> val) {
        this.setDisplayedColumnDefs(val);
        return this;
    }

    @Override
    public List<PagePropertyDef> getHiddenColumnDefs() {
        return this.hiddenColumnDefs;
    }

    public void setHiddenColumnDefs(List<PagePropertyDef> val) {
        this.hiddenColumnDefs = val;
        this.computeAllPropertyDefs();
    }

    public CustomSliceTableDef hiddenColumnDefs(List<PagePropertyDef> val) {
        this.setHiddenColumnDefs(val);
        return this;
    }

    @Override
    public List<PagePropertyDef> getAllPropertyDefs() {
        return this.allPropertyDefs;
    }

    private void computeAllPropertyDefs() {
        this.allPropertyDefs.clear();
        this.allPropertyDefs.addAll(this.getDisplayedColumnDefs());
        this.allPropertyDefs.addAll(this.getHiddenColumnDefs());
    }

    @Override
    public String getGetTableRowsMethod() {
        return this.getTableRowsMethod;
    }

    public void setGetTableRowsMethod(String val) {
        this.getTableRowsMethod = val;
    }

    public CustomSliceTableDef getTableRowsMethod(String val) {
        this.setGetTableRowsMethod(val);
        return this;
    }

    @Override
    public boolean isSupportsNavigation() {
        return this.supportsNavigation;
    }

    public void setSupportsNavigation(boolean val) {
        this.supportsNavigation = val;
    }

    public CustomSliceTableDef supportsNavigation(boolean val) {
        this.setSupportsNavigation(val);
        return this;
    }

    @Override
    public boolean isUseRowIdentities() {
        return this.useRowIdentities;
    }

    public void setUseRowIdentities(boolean val) {
        this.useRowIdentities = val;
    }

    public CustomSliceTableDef useRowIdentities(boolean val) {
        this.setUseRowIdentities(val);
        return this;
    }

    @Override
    public List<PageActionDef> getActionDefs() {
        return this.pageDef.getActionDefs();
    }

    public void setActionDefs(List<PageActionDef> val) {
        this.pageDef.setActionDefs(val);
    }

    public CustomSliceTableDef actionDefs(List<PageActionDef> val) {
        this.setActionDefs(val);
        return this;
    }

    @Override
    public PagePath getPagePath() {
        return this.pageDef.getPagePath();
    }

    public void setPagePath(PagePath val) {
        this.pageDef.setPagePath(val);
    }

    public CustomSliceTableDef pagePath(PagePath val) {
        this.setPagePath(val);
        return this;
    }

    @Override
    public LocalizableString getIntroductionHTML() {
        return this.pageDef.getIntroductionHTML();
    }

    public void setIntroductionHTML(LocalizableString val) {
        this.pageDef.setIntroductionHTML(val);
    }

    public CustomSliceTableDef introductionHTML(LocalizableString val) {
        this.setIntroductionHTML(val);
        return this;
    }

    @Override
    public LocalizableString getHelpPageTitle() {
        return this.pageDef.getHelpPageTitle();
    }

    public void setHelpPageTitle(LocalizableString val) {
        this.pageDef.setHelpPageTitle(val);
    }

    public CustomSliceTableDef helpPageTitle(LocalizableString val) {
        this.setHelpPageTitle(val);
        return this;
    }

    @Override
    public List<HelpTopicDef> getHelpTopicDefs() {
        return this.pageDef.getHelpTopicDefs();
    }

    public void setHelpTopicDefs(List<HelpTopicDef> val) {
        this.pageDef.setHelpTopicDefs(val);
    }

    public CustomSliceTableDef helpTopicDefs(List<HelpTopicDef> val) {
        this.setHelpTopicDefs(val);
        return this;
    }

    @Override
    public String getCustomizePageDefMethod() {
        return this.pageDef.getCustomizePageDefMethod();
    }

    @Override
    public String getCustomizePageMethod() {
        return this.pageDef.getCustomizePageMethod();
    }

    public void setCustomizePageMethod(String val) {
        this.pageDef.setCustomizePageMethod(val);
    }

    public CustomSliceTableDef customizePageMethod(String val) {
        this.setCustomizePageMethod(val);
        return this;
    }

    @Override
    public boolean isInstanceBasedPDJ() {
        return this.pageDef.isInstanceBasedPDJ();
    }

    public void setInstanceBasedPDJ(boolean val) {
        this.pageDef.setInstanceBasedPDJ(val);
    }

    public CustomSliceTableDef instanceBasedPDJ(boolean val) {
        this.setInstanceBasedPDJ(val);
        return this;
    }
}

