/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef;

import java.util.ArrayList;
import java.util.List;
import weblogic.remoteconsole.common.repodef.CustomFormDef;
import weblogic.remoteconsole.common.repodef.FormSectionDef;
import weblogic.remoteconsole.common.repodef.HelpTopicDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.SliceFormDef;
import weblogic.remoteconsole.common.repodef.SliceFormPresentationDef;
import weblogic.remoteconsole.common.repodef.SlicesDef;
import weblogic.remoteconsole.common.utils.ListUtils;

public class CustomSliceFormDef
implements SliceFormDef {
    private CustomFormDef formDef = new CustomFormDef();
    private boolean setReadOnly = false;
    private boolean readOnly;
    private SlicesDef slicesDef;
    private List<PagePropertyDef> advancedPropertyDefs = new ArrayList<PagePropertyDef>();
    private SliceFormPresentationDef presentationDef;

    public CustomSliceFormDef() {
    }

    public CustomSliceFormDef(SliceFormDef toClone) {
        this.formDef = new CustomFormDef(toClone);
        this.readOnly = toClone.isReadOnly();
        this.slicesDef = toClone.getSlicesDef();
        this.getAdvancedPropertyDefs().addAll(ListUtils.nonNull(toClone.getAdvancedPropertyDefs()));
        this.setPresentationDef(toClone.getPresentationDef());
    }

    @Override
    public boolean isReadOnly() {
        if (this.setReadOnly) {
            return this.readOnly;
        }
        for (PagePropertyDef propertyDef : this.getAllPropertyDefs()) {
            if (!propertyDef.isUpdateWritable()) continue;
            return false;
        }
        return true;
    }

    public void setReadOnly(boolean val) {
        this.readOnly = val;
        this.setReadOnly = true;
    }

    public CustomSliceFormDef readOnly(boolean val) {
        this.setReadOnly(val);
        return this;
    }

    @Override
    public SlicesDef getSlicesDef() {
        return this.slicesDef;
    }

    public void setSlicesDef(SlicesDef val) {
        this.slicesDef = val;
    }

    public CustomSliceFormDef slicesDef(SlicesDef val) {
        this.setSlicesDef(val);
        return this;
    }

    @Override
    public List<PagePropertyDef> getAdvancedPropertyDefs() {
        return this.advancedPropertyDefs;
    }

    public void setAdvancedPropertyDefs(List<PagePropertyDef> val) {
        this.advancedPropertyDefs = val;
    }

    public CustomSliceFormDef advancedPropertyDefs(List<PagePropertyDef> val) {
        this.setAdvancedPropertyDefs(val);
        return this;
    }

    @Override
    public SliceFormPresentationDef getPresentationDef() {
        return this.presentationDef;
    }

    public void setPresentationDef(SliceFormPresentationDef val) {
        this.presentationDef = val;
    }

    public CustomSliceFormDef presentationDef(SliceFormPresentationDef val) {
        this.setPresentationDef(val);
        return this;
    }

    @Override
    public List<PagePropertyDef> getPropertyDefs() {
        return this.formDef.getPropertyDefs();
    }

    public void setPropertyDefs(List<PagePropertyDef> val) {
        this.formDef.setPropertyDefs(val);
    }

    public CustomSliceFormDef propertyDefs(List<PagePropertyDef> val) {
        this.setPropertyDefs(val);
        return this;
    }

    @Override
    public List<PagePropertyDef> getAllPropertyDefs() {
        List<PagePropertyDef> allDefs = this.formDef.getAllPropertyDefs();
        allDefs.addAll(this.advancedPropertyDefs);
        return allDefs;
    }

    @Override
    public List<FormSectionDef> getSectionDefs() {
        return this.formDef.getSectionDefs();
    }

    public void setSectionDefs(List<FormSectionDef> val) {
        this.formDef.setSectionDefs(val);
    }

    public CustomSliceFormDef sectionDefs(List<FormSectionDef> val) {
        this.setSectionDefs(val);
        return this;
    }

    @Override
    public List<FormSectionDef> getAllSectionDefs() {
        return this.formDef.getAllSectionDefs();
    }

    @Override
    public PagePath getPagePath() {
        return this.formDef.getPagePath();
    }

    public void setPagePath(PagePath val) {
        this.formDef.setPagePath(val);
    }

    public CustomSliceFormDef pagePath(PagePath val) {
        this.setPagePath(val);
        return this;
    }

    @Override
    public LocalizableString getIntroductionHTML() {
        return this.formDef.getIntroductionHTML();
    }

    public void setIntroductionHTML(LocalizableString val) {
        this.formDef.setIntroductionHTML(val);
    }

    public CustomSliceFormDef introductionHTML(LocalizableString val) {
        this.setIntroductionHTML(val);
        return this;
    }

    @Override
    public LocalizableString getHelpPageTitle() {
        return this.formDef.getHelpPageTitle();
    }

    public void setHelpPageTitle(LocalizableString val) {
        this.formDef.setHelpPageTitle(val);
    }

    public CustomSliceFormDef helpPageTitle(LocalizableString val) {
        this.setHelpPageTitle(val);
        return this;
    }

    @Override
    public List<HelpTopicDef> getHelpTopicDefs() {
        return this.formDef.getHelpTopicDefs();
    }

    public void setHelpTopicDefs(List<HelpTopicDef> val) {
        this.formDef.setHelpTopicDefs(val);
    }

    public CustomSliceFormDef helpTopicDefs(List<HelpTopicDef> val) {
        this.setHelpTopicDefs(val);
        return this;
    }

    @Override
    public List<PageActionDef> getActionDefs() {
        return this.formDef.getActionDefs();
    }

    public void setActionDefs(List<PageActionDef> val) {
        this.formDef.setActionDefs(val);
    }

    public CustomSliceFormDef actionDefs(List<PageActionDef> val) {
        this.setActionDefs(val);
        return this;
    }

    @Override
    public String getCustomizePageMethod() {
        return this.formDef.getCustomizePageMethod();
    }

    @Override
    public String getCustomizePageDefMethod() {
        return this.formDef.getCustomizePageDefMethod();
    }

    public void setCustomizePageMethod(String val) {
        this.formDef.setCustomizePageMethod(val);
    }

    public CustomSliceFormDef customizePageMethod(String val) {
        this.setCustomizePageMethod(val);
        return this;
    }

    @Override
    public boolean isInstanceBasedPDJ() {
        return this.formDef.isInstanceBasedPDJ();
    }

    public void setInstanceBasedPDJ(boolean val) {
        this.formDef.setInstanceBasedPDJ(val);
    }

    public CustomSliceFormDef instanceBasedPDJ(boolean val) {
        this.setInstanceBasedPDJ(val);
        return this;
    }
}

