/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common.repodef;

import java.util.ArrayList;
import java.util.List;
import weblogic.remoteconsole.common.repodef.CustomPageDef;
import weblogic.remoteconsole.common.repodef.FormDef;
import weblogic.remoteconsole.common.repodef.FormSectionDef;
import weblogic.remoteconsole.common.repodef.HelpTopicDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.utils.ListUtils;

class CustomFormDef {
    private CustomPageDef pageDef = new CustomPageDef();
    private List<PagePropertyDef> propertyDefs = new ArrayList<PagePropertyDef>();
    private List<FormSectionDef> sectionDefs = new ArrayList<FormSectionDef>();

    public CustomFormDef() {
    }

    public CustomFormDef(FormDef toClone) {
        this.pageDef = new CustomPageDef(toClone);
        this.getPropertyDefs().addAll(ListUtils.nonNull(toClone.getPropertyDefs()));
        this.getSectionDefs().addAll(ListUtils.nonNull(toClone.getSectionDefs()));
    }

    List<PagePropertyDef> getPropertyDefs() {
        return this.propertyDefs;
    }

    void setPropertyDefs(List<PagePropertyDef> val) {
        this.propertyDefs = val;
    }

    List<PagePropertyDef> getAllPropertyDefs() {
        ArrayList<PagePropertyDef> allDefs = new ArrayList<PagePropertyDef>(this.propertyDefs);
        for (FormSectionDef sectionDef : this.sectionDefs) {
            allDefs.addAll(sectionDef.getAllPropertyDefs());
        }
        return allDefs;
    }

    List<FormSectionDef> getSectionDefs() {
        return this.sectionDefs;
    }

    void setSectionDefs(List<FormSectionDef> val) {
        this.sectionDefs = val;
    }

    List<FormSectionDef> getAllSectionDefs() {
        ArrayList<FormSectionDef> allDefs = new ArrayList<FormSectionDef>(this.sectionDefs);
        for (FormSectionDef sectionDef : this.sectionDefs) {
            allDefs.addAll(sectionDef.getAllSectionDefs());
        }
        return allDefs;
    }

    PagePath getPagePath() {
        return this.pageDef.getPagePath();
    }

    void setPagePath(PagePath val) {
        this.pageDef.setPagePath(val);
    }

    LocalizableString getIntroductionHTML() {
        return this.pageDef.getIntroductionHTML();
    }

    void setIntroductionHTML(LocalizableString val) {
        this.pageDef.setIntroductionHTML(val);
    }

    LocalizableString getHelpPageTitle() {
        return this.pageDef.getHelpPageTitle();
    }

    void setHelpPageTitle(LocalizableString val) {
        this.pageDef.setHelpPageTitle(val);
    }

    List<HelpTopicDef> getHelpTopicDefs() {
        return this.pageDef.getHelpTopicDefs();
    }

    void setHelpTopicDefs(List<HelpTopicDef> val) {
        this.pageDef.setHelpTopicDefs(val);
    }

    List<PageActionDef> getActionDefs() {
        return this.pageDef.getActionDefs();
    }

    void setActionDefs(List<PageActionDef> val) {
        this.pageDef.setActionDefs(val);
    }

    String getCustomizePageMethod() {
        return this.pageDef.getCustomizePageMethod();
    }

    void setCustomizePageMethod(String val) {
        this.pageDef.setCustomizePageMethod(val);
    }

    String getCustomizePageDefMethod() {
        return this.pageDef.getCustomizePageDefMethod();
    }

    void setCustomizePageDefMethod(String val) {
        this.pageDef.setCustomizePageDefMethod(val);
    }

    boolean isInstanceBasedPDJ() {
        return this.pageDef.isInstanceBasedPDJ();
    }

    void setInstanceBasedPDJ(boolean val) {
        this.pageDef.setInstanceBasedPDJ(val);
    }
}

