/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.yaml.snakeyaml.Yaml;

public class YamlUtils {
    private static final Logger LOGGER = Logger.getLogger(YamlUtils.class.getName());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readResource(String yamlPath, Class<T> type, boolean mustExist) {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(yamlPath);){
            T t = YamlUtils.read(is, yamlPath, type, mustExist);
            return t;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Exception reading yaml resource " + yamlPath, e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readFile(String yamlPath, Class<T> type, boolean mustExist) {
        File file = new File(yamlPath);
        if (!file.exists()) {
            return null;
        }
        try (FileInputStream is = new FileInputStream(yamlPath);){
            T t = YamlUtils.read(is, yamlPath, type, mustExist);
            return t;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Exception reading yaml file " + yamlPath, e);
            return null;
        }
    }

    public static <T> T read(InputStream is, String yamlPath, Class<T> type, boolean mustExist) {
        if ("true".equals(System.getenv("debugYaml")) && is != null) {
            LOGGER.info("YamlUtils.read " + yamlPath);
        }
        LOGGER.fine("YamlUtils.read " + yamlPath + " " + String.valueOf(is));
        if (is == null) {
            if (mustExist) {
                throw new AssertionError((Object)(yamlPath + " does not exist."));
            }
            return null;
        }
        try {
            return (T)new Yaml().loadAs(is, type);
        }
        catch (Throwable t) {
            throw new AssertionError("Problem reading yaml file " + yamlPath + " into " + type.getName(), t);
        }
    }

    public static void configurationError(String error) {
        String msg = "Configuration Error: " + error;
        LOGGER.severe(msg);
        throw new AssertionError((Object)msg);
    }
}

