/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.backend.build;

import java.util.ArrayList;
import java.util.Stack;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanChildNavTreeNodeDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.weblogic.WDTPageRepoDef;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicPageDefWalker;
import weblogic.remoteconsole.common.utils.WebLogicMBeansVersion;
import weblogic.remoteconsole.common.utils.WebLogicMBeansVersions;
import weblogic.remoteconsole.common.utils.WebLogicVersions;

public class WDTDumpPageProperties
extends WebLogicPageDefWalker {
    private Stack<BeanChildDef> childDefPath = new Stack();
    private Stack<BeanTypeDef> childTypeDefPath = new Stack();

    private WDTDumpPageProperties(WebLogicMBeansVersion mbeansVersion) {
        super(mbeansVersion);
    }

    public static void main(String[] args) {
        try {
            new WDTDumpPageProperties(WebLogicMBeansVersions.getVersion(WebLogicVersions.getLatestVersion(), WebLogicMBeansVersion.ALL_CAPABILITIES)).walk();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    protected void walk() {
        this.walk(this.getMBeansVersion().findOrCreate(WDTPageRepoDef.class));
    }

    @Override
    protected void processPageDef(PageDef pageDef) {
        BeanTypeDef actualTypeDef = pageDef.getPagePath().getPagesPath().getTypeDef();
        BeanTypeDef currentTypeDef = this.childTypeDefPath.peek();
        this.childTypeDefPath.pop();
        this.childTypeDefPath.push(actualTypeDef);
        for (PagePropertyDef propertyDef : pageDef.getAllPropertyDefs()) {
            this.processPagePropertyDef(propertyDef);
        }
        this.childTypeDefPath.pop();
        this.childTypeDefPath.push(currentTypeDef);
    }

    private void processPagePropertyDef(PagePropertyDef propertyDef) {
        if (!propertyDef.isCreateWritable() && !propertyDef.isUpdateWritable()) {
            return;
        }
        if (propertyDef.isPageLevelField()) {
            return;
        }
        if (propertyDef.isKey()) {
            return;
        }
        if ("Type".equals(propertyDef.getPropertyName())) {
            return;
        }
        BeanTypeDef typeDef = propertyDef.getPageDef().getPagePath().getPagesPath().getTypeDef();
        this.pushChildPath(typeDef, propertyDef.getParentPath());
        System.out.println(this.getContainmentPath() + " " + propertyDef.getOfflinePropertyName());
        this.popChildPath(typeDef, propertyDef.getParentPath());
    }

    @Override
    protected void walkProperties(BeanTypeDef typeDef) {
    }

    @Override
    protected void walkChildren(BeanTypeDef typeDef) {
    }

    @Override
    protected void walkChildNodeDef(BeanChildNavTreeNodeDef childNodeDef) {
        this.pushChildPath(childNodeDef.getNavTreeDef().getTypeDef(), childNodeDef.getChildNodePath());
        super.walkChildNodeDef(childNodeDef);
        this.popChildPath(childNodeDef.getNavTreeDef().getTypeDef(), childNodeDef.getChildNodePath());
    }

    private String getContainmentPath() {
        ArrayList<String> rtn = new ArrayList<String>();
        boolean collapsed = false;
        for (int i = 0; i < this.childDefPath.size(); ++i) {
            BeanChildDef childDef = (BeanChildDef)this.childDefPath.get(i);
            if (!collapsed) {
                String childName = childDef.getOfflineChildName();
                BeanTypeDef typeDefFromPath = (BeanTypeDef)this.childTypeDefPath.get(i);
                BeanTypeDef typeDefFromChild = childDef.getChildTypeDef();
                String typeFromPath = typeDefFromPath.getTypeName();
                String typeFromChild = typeDefFromChild.getTypeName();
                if (!"JDBCSystemResourceMBean".equals(typeFromChild) && !typeFromPath.equals(typeFromChild)) {
                    childName = typeDefFromPath.getInstanceName();
                }
                if ("OracleIdentityCloudIntegrator".equals(childName)) {
                    childName = "weblogic.security.providers.authentication.OracleIdentityCloudIntegrator";
                }
                rtn.add(childName);
                if (!childDef.isCollapsedInWDT()) continue;
                collapsed = true;
                continue;
            }
            collapsed = false;
        }
        return ((Object)rtn).toString();
    }

    private void pushChildPath(BeanTypeDef parentTypeDef, Path childPath) {
        BeanTypeDef typeDef = parentTypeDef;
        for (String child : childPath.getComponents()) {
            BeanChildDef childDef = typeDef.getChildDef(new Path(child), true);
            this.childDefPath.push(childDef);
            typeDef = childDef.getChildTypeDef();
            this.childTypeDefPath.push(typeDef);
        }
    }

    private void popChildPath(BeanTypeDef parentTypeDef, Path childPath) {
        for (String child : childPath.getComponents()) {
            this.childDefPath.pop();
            this.childTypeDefPath.pop();
        }
    }
}

