/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.backend.build;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import weblogic.console.backend.build.PropertiesSorter;
import weblogic.remoteconsole.common.repodef.ActionInputFormDef;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.CreateFormDef;
import weblogic.remoteconsole.common.repodef.FormSectionDef;
import weblogic.remoteconsole.common.repodef.HelpTopicDef;
import weblogic.remoteconsole.common.repodef.LegalValueDef;
import weblogic.remoteconsole.common.repodef.LinkDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.LocalizedConsoleRestExtensionConstants;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.NavTreeNodeDef;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PageActionExternalHelpDef;
import weblogic.remoteconsole.common.repodef.PageActionParamDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.PagePropertyExternalHelpDef;
import weblogic.remoteconsole.common.repodef.SliceDef;
import weblogic.remoteconsole.common.repodef.SliceFormDef;
import weblogic.remoteconsole.common.repodef.SliceTableDef;
import weblogic.remoteconsole.common.repodef.TableDef;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicLocalizationUtils;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicPageDefWalker;
import weblogic.remoteconsole.common.repodef.yaml.UsageTracker;
import weblogic.remoteconsole.common.utils.WebLogicMBeansVersion;
import weblogic.remoteconsole.common.utils.WebLogicMBeansVersions;
import weblogic.remoteconsole.common.utils.WebLogicVersion;
import weblogic.remoteconsole.common.utils.WebLogicVersions;
import weblogic.remoteconsole.server.repo.BuiltinFilteringDashboard;
import weblogic.remoteconsole.server.repo.DashboardManager;
import weblogic.remoteconsole.server.repo.PersistedDashboard;
import weblogic.remoteconsole.server.repo.PersistedDashboards;
import weblogic.remoteconsole.server.repo.PersistedFilteringDashboard;

public class EnglishResourceBundleCreator
extends WebLogicPageDefWalker {
    private static final Logger LOGGER = Logger.getLogger(EnglishResourceBundleCreator.class.getName());
    private String bundleDir;
    private Properties resourceDefinitions = new Properties();

    private String getBundleDir() {
        return this.bundleDir;
    }

    private Properties getResourceDefinitions() {
        return this.resourceDefinitions;
    }

    private EnglishResourceBundleCreator(WebLogicMBeansVersion mbeansVersion, String bundleDir) {
        super(mbeansVersion);
        this.bundleDir = bundleDir;
    }

    public static void main(String[] args) {
        try {
            LOGGER.info("EnglishResourceBundleCreator.main");
            String bundleDir = args[0];
            UsageTracker.trackUsage();
            for (WebLogicVersion weblogicVersion : WebLogicVersions.getSupportedVersions()) {
                WebLogicMBeansVersion mbeansVersion = WebLogicMBeansVersions.getVersion(weblogicVersion, WebLogicMBeansVersion.ALL_CAPABILITIES);
                new EnglishResourceBundleCreator(mbeansVersion, bundleDir).create();
            }
            UsageTracker.reportMissing();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private void create() throws Exception {
        this.walk();
        for (LocalizableString ls : LocalizedConstants.getAllConstants()) {
            this.addResourceDefinition(ls);
        }
        for (LocalizableString ls : LocalizedConsoleRestExtensionConstants.getAllConstants()) {
            this.addResourceDefinition(ls);
        }
        this.addBuiltinDashboards();
        this.writeResourceBundles();
    }

    private void writeResourceBundles() throws Exception {
        this.writeResourceBundle("US English", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResourceBundle(String language, String languagePath) throws Exception {
        String domainVersion = this.getMBeansVersion().getWebLogicVersion().getDomainVersion();
        String fileName = this.getBundleDir() + "/" + WebLogicLocalizationUtils.getResourceBundleName(domainVersion) + languagePath + ".properties";
        try (FileOutputStream os = new FileOutputStream(fileName);){
            PropertiesSorter.store((Properties)this.getResourceDefinitions(), (OutputStream)os, (String)("Remote Console WebLogic " + domainVersion + " " + language + " Resource Definitions"));
        }
    }

    @Override
    protected void processPageDef(PageDef pageDef) {
        this.addResourceDefinition(pageDef.getIntroductionHTML());
        this.addResourceDefinition(pageDef.getHelpPageTitle());
        this.processHelpTopicDefs(pageDef.getHelpTopicDefs());
        this.processPageActionDefs(pageDef.getActionDefs());
        if (pageDef.isSliceFormDef()) {
            this.processSliceFormDef(pageDef.asSliceFormDef());
        } else if (pageDef.isSliceTableDef()) {
            this.processSliceTableDef(pageDef.asSliceTableDef());
        } else if (pageDef.isCreateFormDef()) {
            this.processCreateFormDef(pageDef.asCreateFormDef());
        } else if (pageDef.isTableDef()) {
            this.processTableDef(pageDef.asTableDef());
        } else if (pageDef.isActionInputFormDef()) {
            this.processActionInputFormDef(pageDef.asActionInputFormDef());
        } else {
            throw new AssertionError((Object)("Unknown PageDef type: " + String.valueOf(pageDef.getPagePath())));
        }
    }

    private void processHelpTopicDefs(List<HelpTopicDef> helpTopicDefs) {
        for (HelpTopicDef helpTopicDef : helpTopicDefs) {
            this.addResourceDefinition(helpTopicDef.getLabel());
        }
    }

    private void processSliceFormDef(SliceFormDef sliceFormDef) {
        this.processPagePropertyDefs(sliceFormDef.getAllPropertyDefs());
        this.processSectionDefs(sliceFormDef.getAllSectionDefs());
    }

    private void processSliceTableDef(SliceTableDef sliceTableDef) {
        this.processPagePropertyDefs(sliceTableDef.getAllPropertyDefs());
    }

    private void processCreateFormDef(CreateFormDef createFormDef) {
        this.processPagePropertyDefs(createFormDef.getAllPropertyDefs());
        this.processSectionDefs(createFormDef.getAllSectionDefs());
    }

    private void processSectionDefs(List<FormSectionDef> sectionDefs) {
        for (FormSectionDef sectionDef : sectionDefs) {
            this.addResourceDefinition(sectionDef.getTitle());
            this.addResourceDefinition(sectionDef.getIntroductionHTML());
        }
    }

    private void processTableDef(TableDef tableDef) {
        this.processPagePropertyDefs(tableDef.getAllPropertyDefs());
    }

    private void processActionInputFormDef(ActionInputFormDef inputFormDef) {
        for (PageActionParamDef paramDef : inputFormDef.getParamDefs()) {
            this.processPageActionParamDef(paramDef);
        }
    }

    private void processPageActionParamDef(PageActionParamDef paramDef) {
        this.addResourceDefinition(paramDef.getLabel());
        this.addResourceDefinition(paramDef.getHelpSummaryHTML());
        this.addResourceDefinition(paramDef.getDetailedHelpHTML());
        for (LegalValueDef legalValueDef : paramDef.getLegalValueDefs()) {
            this.addResourceDefinition(legalValueDef.getLabel());
        }
    }

    private void processPageActionDefs(List<PageActionDef> actionDefs) {
        for (PageActionDef actionDef : actionDefs) {
            this.processPageActionDef(actionDef);
        }
    }

    private void processPageActionDef(PageActionDef actionDef) {
        this.addResourceDefinition(actionDef.getLabel());
        if (actionDef.isInvokable()) {
            ActionInputFormDef inputFormDef;
            this.addResourceDefinition(actionDef.getHelpLabel());
            LocalizableString message = actionDef.getSuccessMessage();
            if (message != null) {
                this.addResourceDefinition(message);
            }
            if ((message = actionDef.getFailureMessage()) != null) {
                this.addResourceDefinition(message);
            }
            this.addResourceDefinition(actionDef.getHelpSummaryHTML());
            this.addResourceDefinition(actionDef.getDetailedHelpHTML());
            PageActionExternalHelpDef externalHelpDef = actionDef.getExternalHelpDef();
            if (externalHelpDef != null) {
                this.addResourceDefinition(externalHelpDef.getLabel());
                this.addResourceDefinition(externalHelpDef.getIntroLabel());
                this.addResourceDefinition(externalHelpDef.getTitle());
            }
            if ((inputFormDef = actionDef.getInputFormDef()) != null) {
                this.processPageDef(inputFormDef);
            }
        }
        this.processPageActionDefs(actionDef.getActionDefs());
    }

    private void processPagePropertyDefs(List<PagePropertyDef> propertyDefs) {
        for (PagePropertyDef propertyDef : propertyDefs) {
            this.processPagePropertyDef(propertyDef);
        }
    }

    private void processPagePropertyDef(PagePropertyDef propertyDef) {
        this.addResourceDefinition(propertyDef.getLabel());
        this.addResourceDefinition(propertyDef.getHelpSummaryHTML());
        this.addResourceDefinition(propertyDef.getDetailedHelpHTML());
        this.addResourceDefinition(propertyDef.getPresentationDef().getInlineFieldHelp());
        for (LegalValueDef legalValueDef : propertyDef.getLegalValueDefs()) {
            this.addResourceDefinition(legalValueDef.getLabel());
        }
        PagePropertyExternalHelpDef externalHelpDef = propertyDef.getExternalHelpDef();
        if (externalHelpDef != null) {
            this.addResourceDefinition(externalHelpDef.getLabel());
            this.addResourceDefinition(externalHelpDef.getIntroLabel());
            this.addResourceDefinition(externalHelpDef.getTitle());
        }
        propertyDef.getSecureDefaultValue();
        propertyDef.getProductionDefaultValue();
        propertyDef.getDefaultValue();
    }

    @Override
    protected void processTypeDef(BeanTypeDef typeDef) {
        this.addResourceDefinition(typeDef.getInstanceNameLabel());
        for (BeanChildDef childDef : typeDef.getChildDefs()) {
            this.addResourceDefinition(childDef.getLabel());
            this.addResourceDefinition(childDef.getSingularLabel());
        }
        typeDef.getDeleteCustomizerDef();
        for (BeanPropertyDef propertyDef : typeDef.getPropertyDefs()) {
            propertyDef.getGetValueCustomizerDef();
            propertyDef.getGetOptionsCustomizerDef();
        }
    }

    @Override
    protected void processNavTreeNodeDef(NavTreeNodeDef navTreeNodeDef) {
        this.addResourceDefinition(navTreeNodeDef.getLabel());
    }

    @Override
    protected void processSliceDef(SliceDef sliceDef) {
        this.addResourceDefinition(sliceDef.getLabel());
    }

    @Override
    protected void processLinkDef(LinkDef linkDef) {
        this.addResourceDefinition(linkDef.getLabel());
        LocalizableString nfm = linkDef.getNotFoundMessage();
        if (nfm != null) {
            this.addResourceDefinition(linkDef.getNotFoundMessage());
        }
    }

    private void addBuiltinDashboards() {
        PersistedDashboards dashboards = DashboardManager.createPersistedBuiltinDashboards();
        for (Map.Entry<String, PersistedDashboard> entry : dashboards.getDashboards().entrySet()) {
            this.addBuiltinDashboard(entry.getKey(), entry.getValue());
        }
    }

    private void addBuiltinDashboard(String name, PersistedDashboard dashboard) {
        if (dashboard.isFilteringDashboard()) {
            this.addBuiltinFilteringDashboard(name, dashboard.asFilteringDashboard());
        }
    }

    private void addBuiltinFilteringDashboard(String name, PersistedFilteringDashboard dashboard) {
        this.addResourceDefinition(BuiltinFilteringDashboard.getNameLabel(name));
        this.addResourceDefinition(BuiltinFilteringDashboard.getDescriptionLabel(name, dashboard.getDescription()));
    }

    private void addResourceDefinition(LocalizableString localizableString) {
        if (localizableString.isUnlocalized()) {
            return;
        }
        if (localizableString.isEmpty()) {
            return;
        }
        this.getResourceDefinitions().setProperty(localizableString.getResourceBundleKey(), localizableString.getEnglishText(new Object[0]));
    }
}

