/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.tracing;

import io.helidon.common.reactive.Single;
import io.helidon.webclient.WebClientServiceRequest;
import io.helidon.webclient.spi.WebClientService;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class WebClientTracing
implements WebClientService {
    private static final int HTTP_STATUS_ERROR_THRESHOLD = 400;
    private static final int HTTP_STATUS_SERVER_ERROR_THRESHOLD = 500;

    private WebClientTracing() {
    }

    public static WebClientTracing create() {
        return new WebClientTracing();
    }

    public Single<WebClientServiceRequest> request(WebClientServiceRequest request) {
        String method = request.method().name().toUpperCase();
        Optional optionalTracer = request.context().get(Tracer.class);
        Tracer tracer = optionalTracer.orElseGet(GlobalTracer::get);
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(this.composeName(method, request));
        request.context().get(SpanContext.class).ifPresent(arg_0 -> ((Tracer.SpanBuilder)spanBuilder).asChildOf(arg_0));
        Span span = spanBuilder.start();
        Tags.COMPONENT.set(span, "helidon-webclient");
        Tags.HTTP_METHOD.set(span, method);
        Tags.HTTP_URL.set(span, request.uri().toString());
        request.context().register((Object)span.context());
        HashMap<String, String> tracerHeaders = new HashMap<String, String>();
        tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new TextMapAdapter(tracerHeaders));
        tracerHeaders.forEach((name, value) -> request.headers().put(name, new String[]{value}));
        request.whenResponseReceived().thenAccept(response -> {
            int status = response.status().code();
            Tags.HTTP_STATUS.set(span, Integer.valueOf(status));
            if (status >= 400) {
                Tags.ERROR.set(span, Boolean.valueOf(true));
                span.log(Map.of("event", "error", "message", "Response HTTP status: " + status, "error.kind", status < 500 ? "ClientError" : "ServerError"));
            }
            span.finish();
        });
        return Single.just((Object)request);
    }

    private String composeName(String method, WebClientServiceRequest request) {
        return method + "-" + request.schema() + "://" + request.host() + ":" + request.port() + request.path().toString();
    }
}

