/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.LazyValue;
import io.helidon.common.http.DataChunk;
import io.helidon.common.reactive.RequestedCounter;
import io.helidon.common.reactive.RetrySchema;
import io.helidon.common.reactive.SingleSubscriberHolder;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated(since="2.0.0", forRemoval=true)
public class ReadableByteChannelPublisher
implements Flow.Publisher<DataChunk> {
    private static final Logger LOGGER = Logger.getLogger(ReadableByteChannelPublisher.class.getName());
    private static final int DEFAULT_CHUNK_CAPACITY = 8192;
    private final ReadableByteChannel channel;
    private final RetrySchema retrySchema;
    private final boolean externalExecutor;
    private final int chunkCapacity;
    private final LazyValue<ScheduledExecutorService> executor;
    private final SingleSubscriberHolder<DataChunk> subscriber = new SingleSubscriberHolder();
    private final RequestedCounter requested = new RequestedCounter();
    private final AtomicBoolean publishing = new AtomicBoolean(false);
    private final AtomicInteger retryCounter = new AtomicInteger();
    private volatile long lastRetryDelay = 0L;
    private volatile DataChunk currentChunk;

    @Deprecated(since="2.0.0", forRemoval=true)
    public ReadableByteChannelPublisher(ReadableByteChannel channel, RetrySchema retrySchema) {
        this.channel = channel;
        this.retrySchema = retrySchema;
        this.executor = LazyValue.create(() -> Executors.newScheduledThreadPool(1));
        this.externalExecutor = false;
        this.chunkCapacity = 8192;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super DataChunk> subscriberParam) {
        if (this.subscriber.register(subscriberParam)) {
            this.publishing.set(true);
            try {
                subscriberParam.onSubscribe(new Flow.Subscription(){

                    @Override
                    public void request(long n) {
                        ReadableByteChannelPublisher.this.requested.increment(n, t -> ReadableByteChannelPublisher.this.tryComplete((Throwable)t));
                        ReadableByteChannelPublisher.this.tryPublish();
                    }

                    @Override
                    public void cancel() {
                        ReadableByteChannelPublisher.this.subscriber.cancel();
                        ReadableByteChannelPublisher.this.closeExecutor();
                    }
                });
            }
            finally {
                this.publishing.set(false);
            }
            this.tryPublish();
        }
    }

    LazyValue<ScheduledExecutorService> executor() {
        return this.executor;
    }

    private DataChunk allocateNewChunk() {
        return DataChunk.create((boolean)false, (ByteBuffer[])new ByteBuffer[]{ByteBuffer.allocate(this.chunkCapacity)});
    }

    private boolean publishSingleOrFinish(Flow.Subscriber<? super DataChunk> subscr) throws Exception {
        DataChunk chunk;
        if (this.currentChunk == null) {
            chunk = this.allocateNewChunk();
        } else {
            chunk = this.currentChunk;
            this.currentChunk = null;
        }
        ByteBuffer bb = chunk.data()[0];
        int count = 0;
        while (bb.remaining() > 0 && (count = this.channel.read(bb)) > 0) {
        }
        if (bb.capacity() > bb.remaining()) {
            bb.flip();
            subscr.onNext((DataChunk)chunk);
        } else {
            this.currentChunk = chunk;
        }
        if (count < 0) {
            try {
                this.channel.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Cannot close readable byte channel! (Close attempt after fully read channel.)", e);
            }
            this.tryComplete();
            if (this.currentChunk != null) {
                this.currentChunk.release();
            }
            return true;
        }
        return count > 0;
    }

    private void tryPublish() {
        boolean immediateRetry = true;
        while (immediateRetry) {
            long nextDelay;
            immediateRetry = false;
            if (this.subscriber.isClosed() || this.requested.get() <= 0L || !this.publishing.compareAndSet(false, true)) continue;
            try {
                Flow.Subscriber sub = this.subscriber.get();
                while (!this.subscriber.isClosed() && this.requested.tryDecrement()) {
                    if (this.publishSingleOrFinish(sub)) continue;
                    this.requested.increment(1L, this::tryComplete);
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.tryComplete(e);
            }
            catch (Exception e) {
                this.tryComplete(e);
            }
            finally {
                this.publishing.set(false);
            }
            if (this.subscriber.isClosed() || this.requested.get() <= 0L) continue;
            this.lastRetryDelay = nextDelay = this.retrySchema.nextDelay(this.retryCounter.getAndIncrement(), this.lastRetryDelay);
            if (nextDelay < 0L) {
                this.tryComplete(new TimeoutException("Wait for the next item timeout!"));
                continue;
            }
            if (nextDelay == 0L) {
                immediateRetry = true;
                continue;
            }
            this.planNextTry(nextDelay);
        }
    }

    private synchronized void planNextTry(long afterMillis) {
        ((ScheduledExecutorService)this.executor.get()).schedule(this::tryPublish, afterMillis, TimeUnit.MILLISECONDS);
    }

    private void tryComplete() {
        this.subscriber.close(Flow.Subscriber::onComplete);
        this.closeExecutor();
    }

    private void tryComplete(Throwable t) {
        this.subscriber.close(sub -> sub.onError(t));
        this.closeExecutor();
    }

    private synchronized void closeExecutor() {
        if (!this.externalExecutor && this.executor.isLoaded()) {
            ((ScheduledExecutorService)this.executor.get()).shutdownNow();
        }
    }
}

