/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.ContentWriters;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Flow;
import java.util.function.Function;

final class PathBodyWriter
implements MessageBodyWriter<Path> {
    private static final PathBodyWriter DEFAULT = new PathBodyWriter();

    private PathBodyWriter() {
    }

    @Override
    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        return MessageBodyOperator.PredicateResult.supports(Path.class, type);
    }

    @Override
    public Flow.Publisher<DataChunk> write(Single<? extends Path> content, GenericType<? extends Path> type, MessageBodyWriterContext context) {
        return content.flatMap((Function)((Object)new PathToChunks(context)));
    }

    static PathBodyWriter create() {
        return DEFAULT;
    }

    private static final class PathToChunks
    implements Mapper<Path, Flow.Publisher<DataChunk>> {
        private final MessageBodyWriterContext context;

        PathToChunks(MessageBodyWriterContext context) {
            this.context = context;
        }

        public Flow.Publisher<DataChunk> map(Path path) {
            try {
                this.context.contentType(MediaType.APPLICATION_OCTET_STREAM);
                this.context.contentLength(Files.size(path));
                FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);
                return ContentWriters.byteChannelWriter().apply(fc);
            }
            catch (IOException ex) {
                return Single.error((Throwable)ex);
            }
        }
    }
}

