/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.GenericType;
import io.helidon.common.http.Content;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Reader;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.MessageBodyContent;
import io.helidon.media.common.MessageBodyFilter;
import io.helidon.media.common.MessageBodyFilters;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.common.MessageBodyReaders;
import io.helidon.media.common.MessageBodyStreamReader;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Predicate;

public final class MessageBodyReadableContent
implements MessageBodyReaders,
MessageBodyFilters,
MessageBodyContent,
Content {
    private final Flow.Publisher<DataChunk> publisher;
    private final MessageBodyReaderContext context;

    MessageBodyReadableContent(Flow.Publisher<DataChunk> publisher, MessageBodyReaderContext context) {
        Objects.requireNonNull(publisher, "publisher is null!");
        Objects.requireNonNull(context, "context is null!");
        this.publisher = publisher;
        this.context = context;
    }

    private MessageBodyReadableContent(MessageBodyReadableContent orig) {
        Objects.requireNonNull(orig, "orig is null!");
        this.publisher = orig.publisher;
        this.context = orig.context;
    }

    public MessageBodyReaderContext readerContext() {
        return this.context;
    }

    @Override
    public MessageBodyReadableContent registerFilter(MessageBodyFilter filter) {
        this.context.registerFilter(filter);
        return this;
    }

    @Override
    public MessageBodyReadableContent registerReader(MessageBodyReader<?> reader) {
        this.context.registerReader((MessageBodyReader)reader);
        return this;
    }

    @Override
    public MessageBodyReadableContent registerReader(MessageBodyStreamReader<?> reader) {
        this.context.registerReader((MessageBodyStreamReader)reader);
        return this;
    }

    @Deprecated
    public void registerFilter(Function<Flow.Publisher<DataChunk>, Flow.Publisher<DataChunk>> function) {
        this.context.registerFilter(p -> (Flow.Publisher)function.apply((Flow.Publisher<DataChunk>)p));
    }

    @Deprecated
    public <T> void registerReader(Class<T> type, Reader<T> reader) {
        this.context.registerReader(type, reader);
    }

    @Deprecated
    public <T> void registerReader(Predicate<Class<?>> predicate, Reader<T> reader) {
        this.context.registerReader(predicate, reader);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super DataChunk> subscriber) {
        try {
            this.context.applyFilters(this.publisher).subscribe(subscriber);
        }
        catch (Exception e) {
            subscriber.onError(new IllegalArgumentException("Unexpected exception occurred during publishers chaining", e));
        }
    }

    public <T> Single<T> as(Class<T> type) {
        return this.context.unmarshall(this.publisher, GenericType.create(type));
    }

    public <T> Single<T> as(GenericType<T> type) {
        return this.context.unmarshall(this.publisher, type);
    }

    public <T> Multi<T> asStream(Class<T> type) {
        return this.asStream(GenericType.create(type));
    }

    public <T> Multi<T> asStream(GenericType<T> type) {
        return Multi.create(this.context.unmarshallStream(this.publisher, type));
    }

    public static MessageBodyReadableContent create(Flow.Publisher<DataChunk> publisher, MessageBodyReaderContext context) {
        return new MessageBodyReadableContent(publisher, context);
    }
}

