/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.GenericType;
import io.helidon.media.common.MessageBodyContext;
import io.helidon.media.common.MessageBodyOperator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class MessageBodyOperators<T extends MessageBodyOperator<?>>
implements Iterable<T>,
AutoCloseable {
    private final LinkedList<T> operators;
    private final ReadWriteLock lock;
    private final AtomicBoolean readLocked;
    private MessageBodyOperators<T> parent;

    MessageBodyOperators(MessageBodyOperators<T> parent) {
        this.parent = parent;
        this.operators = new LinkedList();
        this.lock = new ReentrantReadWriteLock();
        this.readLocked = new AtomicBoolean(false);
    }

    MessageBodyOperators() {
        this(null);
    }

    void registerLast(T operator) {
        this.register(operator, false);
    }

    void registerFirst(T operator) {
        this.register(operator, true);
    }

    private void register(T operator, boolean addFirst) {
        Objects.requireNonNull(operator, "operator is null!");
        try {
            this.lock.writeLock().lock();
            if (addFirst) {
                this.operators.addFirst(operator);
            } else {
                this.operators.addLast(operator);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <U extends MessageBodyOperator<V>, V extends MessageBodyContext> T select(GenericType<?> type, V context) {
        Objects.requireNonNull(type, "type is null!");
        Objects.requireNonNull(context, "context is null!");
        MessageBodyOperator assignableOperator = null;
        MessageBodyOperators<T> current = this;
        while (current != null) {
            try {
                current.lock.readLock().lock();
                for (MessageBodyOperator operator : current.operators) {
                    MessageBodyOperator.PredicateResult accept = operator.accept(type, context);
                    if (accept == MessageBodyOperator.PredicateResult.COMPATIBLE && assignableOperator == null) {
                        assignableOperator = operator;
                        continue;
                    }
                    if (accept != MessageBodyOperator.PredicateResult.SUPPORTED) continue;
                    MessageBodyOperator messageBodyOperator = operator;
                    return (T)messageBodyOperator;
                }
            }
            finally {
                current.lock.readLock().unlock();
            }
            current = current.parent;
        }
        return (T)assignableOperator;
    }

    @Override
    public Iterator<T> iterator() {
        return new ParentedIterator(this);
    }

    @Override
    public void close() {
        if (this.readLocked.compareAndSet(true, false)) {
            this.lock.readLock().unlock();
        }
    }

    private static final class ParentedIterator<T extends MessageBodyOperator<?>>
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private final Lock readLock;
        private final Iterator<T> parent;
        private final AtomicBoolean locked;
        private final AtomicBoolean hasNext;

        ParentedIterator(MessageBodyOperators<T> registry) {
            this.iterator = registry.operators.iterator();
            this.readLock = registry.lock.readLock();
            this.parent = registry.parent != null ? registry.parent.iterator() : null;
            this.locked = registry.readLocked;
            this.hasNext = new AtomicBoolean(true);
        }

        @Override
        public boolean hasNext() {
            if (!this.hasNext.get()) {
                if (this.parent != null) {
                    return this.parent.hasNext();
                }
                return false;
            }
            if (this.locked.compareAndSet(false, true)) {
                this.readLock.lock();
            }
            if (this.iterator.hasNext()) {
                return true;
            }
            if (this.locked.compareAndSet(true, false)) {
                this.readLock.unlock();
            }
            this.hasNext.set(false);
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext.get()) {
                return (T)((MessageBodyOperator)this.iterator.next());
            }
            if (this.parent != null) {
                return (T)((MessageBodyOperator)this.parent.next());
            }
            throw new NoSuchElementException();
        }
    }
}

