/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.config.ConfigSources;
import io.helidon.media.common.DefaultMediaSupport;
import io.helidon.media.common.MediaContextBuilder;
import io.helidon.media.common.MediaSupport;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.common.MessageBodyStreamReader;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.media.common.spi.MediaSupportProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class MediaContext {
    private final MessageBodyReaderContext readerContext;
    private final MessageBodyWriterContext writerContext;

    private MediaContext(MessageBodyReaderContext readerContext, MessageBodyWriterContext writerContext) {
        this.readerContext = readerContext;
        this.writerContext = writerContext;
    }

    public static MediaContext create() {
        return MediaContext.builder().build();
    }

    public static MediaContext create(Config config) {
        return MediaContext.builder().config(config).build();
    }

    public static MediaContext empty() {
        return MediaContext.builder().registerDefaults(false).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public MessageBodyReaderContext readerContext() {
        return this.readerContext;
    }

    public MessageBodyWriterContext writerContext() {
        return this.writerContext;
    }

    private static final class DefaultsProvider
    implements MediaSupportProvider {
        private DefaultsProvider() {
        }

        @Override
        public String configKey() {
            return "defaults";
        }

        @Override
        public MediaSupport create(Config config) {
            return DefaultMediaSupport.builder().config(config).build();
        }
    }

    public static class Builder
    implements io.helidon.common.Builder<MediaContext>,
    MediaContextBuilder<Builder> {
        private static final String SERVICE_NAME = "name";
        private static final String DEFAULTS_NAME = "defaults";
        private static final int DEFAULTS_PRIORITY = 100;
        private static final int BUILDER_PRIORITY = 200;
        private static final int LOADER_PRIORITY = 300;
        private final HelidonServiceLoader.Builder<MediaSupportProvider> services = HelidonServiceLoader.builder(ServiceLoader.load(MediaSupportProvider.class));
        private final List<MessageBodyReader<?>> builderReaders = new ArrayList();
        private final List<MessageBodyStreamReader<?>> builderStreamReaders = new ArrayList();
        private final List<MessageBodyWriter<?>> builderWriters = new ArrayList();
        private final List<MessageBodyStreamWriter<?>> builderStreamWriter = new ArrayList();
        private final List<MediaSupport> mediaSupports = new ArrayList<MediaSupport>();
        private final Map<String, Map<String, String>> servicesConfig = new HashMap<String, Map<String, String>>();
        private final MessageBodyReaderContext readerContext = MessageBodyReaderContext.create();
        private final MessageBodyWriterContext writerContext = MessageBodyWriterContext.create();
        private boolean registerDefaults = true;
        private boolean discoverServices = false;
        private boolean filterServices = false;

        private Builder() {
        }

        public Builder config(Config config) {
            config.get("register-defaults").asBoolean().ifPresent(this::registerDefaults);
            config.get("discover-services").asBoolean().ifPresent(this::discoverServices);
            config.get("filter-services").asBoolean().ifPresent(this::filterServices);
            config.get("services").asNodeList().ifPresent(it -> it.forEach(serviceConfig -> {
                String name = (String)serviceConfig.get(SERVICE_NAME).asString().get();
                this.servicesConfig.merge(name, (Map)serviceConfig.detach().asMap().orElseGet(Map::of), (first, second) -> {
                    HashMap result = new HashMap(first);
                    result.putAll(second);
                    return result;
                });
            }));
            return this;
        }

        @Override
        public Builder addMediaSupport(MediaSupport mediaSupport) {
            Objects.requireNonNull(mediaSupport);
            this.mediaSupports.add(mediaSupport);
            return this;
        }

        public Builder addMediaSupport(MediaSupport mediaSupport, int priority) {
            Objects.requireNonNull(mediaSupport);
            this.services.addService(config -> mediaSupport, priority);
            return this;
        }

        @Override
        public Builder addReader(MessageBodyReader<?> reader) {
            this.builderReaders.add(reader);
            return this;
        }

        @Override
        public Builder addStreamReader(MessageBodyStreamReader<?> streamReader) {
            this.builderStreamReaders.add(streamReader);
            return this;
        }

        @Override
        public Builder addWriter(MessageBodyWriter<?> writer) {
            this.builderWriters.add(writer);
            return this;
        }

        @Override
        public Builder addStreamWriter(MessageBodyStreamWriter<?> streamWriter) {
            this.builderStreamWriter.add(streamWriter);
            return this;
        }

        public Builder registerDefaults(boolean registerDefaults) {
            this.registerDefaults = registerDefaults;
            return this;
        }

        public Builder discoverServices(boolean discoverServices) {
            this.discoverServices = discoverServices;
            return this;
        }

        public Builder filterServices(boolean filterServices) {
            this.filterServices = filterServices;
            return this;
        }

        public MediaContext build() {
            this.servicesConfig.forEach((key, values) -> values.remove(SERVICE_NAME));
            if (this.filterServices) {
                this.services.useSystemServiceLoader(false);
                this.filterServices();
            } else {
                this.services.useSystemServiceLoader(this.discoverServices);
            }
            if (this.registerDefaults) {
                this.services.addService((Object)new DefaultsProvider(), 100);
            }
            this.services.defaultPriority(300).addService(config -> new MediaSupport(){

                @Override
                public void register(MessageBodyReaderContext readerContext, MessageBodyWriterContext writerContext) {
                    builderReaders.forEach(readerContext::registerReader);
                    builderStreamReaders.forEach(readerContext::registerReader);
                    builderWriters.forEach(writerContext::registerWriter);
                    builderStreamWriter.forEach(writerContext::registerWriter);
                }
            }, 200).addService(config -> new MediaSupport(){

                @Override
                public void register(MessageBodyReaderContext readerContext, MessageBodyWriterContext writerContext) {
                    mediaSupports.forEach(it -> it.register(readerContext, writerContext));
                }
            }, 200).build().asList().stream().map(it -> it.create(Config.just((Supplier[])new Supplier[]{ConfigSources.create((Map)this.servicesConfig.getOrDefault(it.configKey(), new HashMap()))}))).collect(Collectors.toCollection(LinkedList::new)).descendingIterator().forEachRemaining(mediaService -> mediaService.register(this.readerContext, this.writerContext));
            return new MediaContext(this.readerContext, this.writerContext);
        }

        private void filterServices() {
            HelidonServiceLoader.builder(ServiceLoader.load(MediaSupportProvider.class)).defaultPriority(300).build().asList().stream().filter(provider -> this.servicesConfig.containsKey(provider.configKey())).forEach(arg_0 -> this.services.addService(arg_0));
        }
    }
}

